<?php
if ( ! class_exists( 'NISHIKI_PRO_CONTENT_ADMIN' ) ) {
	/**
	 * 再利用コンテンツ（管理画面）
	 */
	class NISHIKI_PRO_CONTENT_ADMIN extends NISHIKI_PRO_CONTENT_UTILITY {

		/**
		 * NISHIKI_PRO_CONTENT_ADMIN constructor.
		 */
		public function __construct() {
			// オプションページ追加フック.
			add_action( 'admin_menu', array( $this, 'nishiki_pro_content_admin_menu' ), 20 );

			// フォーム追加.
			add_action( 'admin_init', array( $this, 'nishiki_pro_content_common_register_settings' ), 20 );
			add_action( 'admin_init', array( $this, 'nishiki_pro_content_home_register_settings' ), 20 );
			add_action( 'admin_init', array( $this, 'nishiki_pro_content_post_register_settings' ), 20 );
			add_action( 'admin_init', array( $this, 'nishiki_pro_content_archive_register_settings' ), 20 );
			add_action( 'admin_init', array( $this, 'nishiki_pro_content_search_register_settings' ), 20 );
			add_action( 'admin_init', array( $this, 'nishiki_pro_content_404_register_settings' ), 20 );
			add_action( 'admin_init', array( $this, 'nishiki_pro_content_shortcode_register_settings' ), 20 );

		}

		/**
		 * サブメニュー追加
		 */
		public function nishiki_pro_content_admin_menu() {
			add_submenu_page(
				'nishiki-pro-general.php',
				'再利用コンテンツ管理',
				'再利用コンテンツ管理',
				'manage_options',
				'nishiki-pro-content.php',
				array( $this, 'nishiki_pro_content_admin_page' )
			);
		}

		/**
		 * フォームの設定(基本)
		 */
		public function nishiki_pro_content_common_register_settings() {
			register_setting(
				$this->plugin_name . '_common',
				$this->plugin_name . '_common',
				array( $this, 'sanitize' )
			);

			add_settings_section(
				$this->plugin_name . '_common',
				__( '基本設定', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_cb' ),
				$this->plugin_name . '_common'
			);

			add_settings_field(
				'display',
				__( 'コンテンツを表示', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_display_checkbox_cb' ),
				$this->plugin_name . '_common',
				$this->plugin_name . '_common',
				array(
					'label_for'   => 'display',
					'page_name'   => 'common',
					'description' => 'チェックを入れると、全ページで設定したコンテンツが表示されます。一時的に全部のコンテンツを非表示にしたい場合などに使ってください。',
				)
			);
		}

		/**
		 * フォームの設定（トップページ）
		 */
		public function nishiki_pro_content_home_register_settings() {

			register_setting(
				$this->plugin_name . '_home',
				$this->plugin_name . '_home',
				array( $this, 'sanitize' )
			);

			add_settings_section(
				$this->plugin_name . '_home',
				__( 'トップページ設定', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_cb' ),
				$this->plugin_name . '_home'
			);

			add_settings_field(
				'display',
				__( 'コンテンツを表示', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_display_checkbox_cb' ),
				$this->plugin_name . '_home',
				$this->plugin_name . '_home',
				array(
					'label_for'   => 'display',
					'page_name'   => 'home',
					'description' => 'チェックを入れると、設定したコンテンツが表示されます。',
				)
			);

			add_settings_field(
				'before_site_header',
				__( 'ヘッダーの上', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_home',
				$this->plugin_name . '_home',
				array(
					'label_for' => 'before_site_header',
					'page_name' => 'home',
					'title'     => '',
				)
			);

			add_settings_field(
				'after_site_header',
				__( 'ヘッダーの下', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_home',
				$this->plugin_name . '_home',
				array(
					'label_for' => 'after_site_header',
					'page_name' => 'home',
					'title'     => '',
				)
			);

			add_settings_field(
				'before_site_nav',
				__( 'ナビゲーションの前', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_home',
				$this->plugin_name . '_home',
				array(
					'label_for' => 'before_site_nav',
					'page_name' => 'home',
					'title'     => '',
				)
			);

			add_settings_field(
				'after_site_nav',
				__( 'ナビゲーションの後', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_home',
				$this->plugin_name . '_home',
				array(
					'label_for' => 'after_site_nav',
					'page_name' => 'home',
					'title'     => '',
				)
			);

			add_settings_field(
				'before_header',
				__( 'ページタイトルの上', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_home',
				$this->plugin_name . '_home',
				array(
					'label_for' => 'before_header',
					'page_name' => 'home',
					'title'     => '',
				)
			);

			add_settings_field(
				'after_header',
				__( 'ページタイトルの下', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_home',
				$this->plugin_name . '_home',
				array(
					'label_for' => 'after_header',
					'page_name' => 'home',
					'title'     => '',
				)
			);

			add_settings_field(
				'before_title',
				__( 'ページタイトルテキストの上', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_home',
				$this->plugin_name . '_home',
				array(
					'label_for' => 'before_title',
					'page_name' => 'home',
					'title'     => '',
				)
			);

			add_settings_field(
				'after_title',
				__( 'ページタイトルテキストの下', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_home',
				$this->plugin_name . '_home',
				array(
					'label_for' => 'after_title',
					'page_name' => 'home',
					'title'     => '',
				)
			);

			add_settings_field(
				'before_content',
				__( '本文の上', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_home',
				$this->plugin_name . '_home',
				array(
					'label_for' => 'before_content',
					'page_name' => 'home',
				)
			);

			add_settings_field(
				'after_content',
				__( '本文の下', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_home',
				$this->plugin_name . '_home',
				array(
					'label_for' => 'after_content',
					'page_name' => 'home',
				)
			);

			add_settings_field(
				'before_footer',
				__( 'フッターの上', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_home',
				$this->plugin_name . '_home',
				array(
					'label_for' => 'before_footer',
					'page_name' => 'home',
				)
			);

			add_settings_field(
				'after_footer',
				__( 'フッターの下', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_home',
				$this->plugin_name . '_home',
				array(
					'label_for' => 'after_footer',
					'page_name' => 'home',
				)
			);

		}

		/**
		 * フォームの設定（投稿・固定ページ）
		 */
		public function nishiki_pro_content_post_register_settings() {

			register_setting(
				$this->plugin_name . '_post',
				$this->plugin_name . '_post',
				array( $this, 'sanitize' )
			);

			add_settings_section(
				$this->plugin_name . '_post',
				__( '投稿・固定ページ設定', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_cb' ),
				$this->plugin_name . '_post'
			);

			add_settings_field(
				'display',
				__( 'コンテンツを表示', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_display_checkbox_cb' ),
				$this->plugin_name . '_post',
				$this->plugin_name . '_post',
				array(
					'label_for'   => 'display',
					'page_name'   => 'post',
					'description' => 'チェックを入れると、設定したコンテンツが表示されます。',
				)
			);

			add_settings_field(
				'post_type',
				__( '表示する投稿タイプ', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_display_post_type_cb' ),
				$this->plugin_name . '_post',
				$this->plugin_name . '_post',
				array(
					'label_for' => 'post_type',
					'page_name' => 'post',
				)
			);

			add_settings_field(
				'exclude_id',
				__( '表示を除外する', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_exclude_id_cb' ),
				$this->plugin_name . '_post',
				$this->plugin_name . '_post',
				array(
					'label_for'   => 'exclude_id',
					'page_name'   => 'post',
					'description' => '除外する投稿・固定ページのID（カンマ区切りで複数指定）',
				)
			);

			add_settings_field(
				'before_site_header',
				__( 'ヘッダーの上', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_post',
				$this->plugin_name . '_post',
				array(
					'label_for' => 'before_site_header',
					'page_name' => 'post',
					'title'     => '',
				)
			);

			add_settings_field(
				'after_site_header',
				__( 'ヘッダーの下', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_post',
				$this->plugin_name . '_post',
				array(
					'label_for' => 'after_site_header',
					'page_name' => 'post',
					'title'     => '',
				)
			);

			add_settings_field(
				'before_site_nav',
				__( 'ナビゲーションの前', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_post',
				$this->plugin_name . '_post',
				array(
					'label_for' => 'before_site_nav',
					'page_name' => 'post',
					'title'     => '',
				)
			);

			add_settings_field(
				'after_site_nav',
				__( 'ナビゲーションの後', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_post',
				$this->plugin_name . '_post',
				array(
					'label_for' => 'after_site_nav',
					'page_name' => 'post',
					'title'     => '',
				)
			);

			add_settings_field(
				'before_header',
				__( 'ページタイトルの上', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_post',
				$this->plugin_name . '_post',
				array(
					'label_for' => 'before_header',
					'page_name' => 'post',
					'title'     => '',
				)
			);

			add_settings_field(
				'after_header',
				__( 'ページタイトルの下', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_post',
				$this->plugin_name . '_post',
				array(
					'label_for' => 'after_header',
					'page_name' => 'post',
					'title'     => '',
				)
			);

			add_settings_field(
				'before_title',
				__( 'ページタイトルテキストの上', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_post',
				$this->plugin_name . '_post',
				array(
					'label_for' => 'before_title',
					'page_name' => 'post',
					'title'     => '',
				)
			);

			add_settings_field(
				'after_title',
				__( 'ページタイトルテキストの下', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_post',
				$this->plugin_name . '_post',
				array(
					'label_for' => 'after_title',
					'page_name' => 'post',
					'title'     => '',
				)
			);

			add_settings_field(
				'before_content',
				__( '本文の上', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_post',
				$this->plugin_name . '_post',
				array(
					'label_for' => 'before_content',
					'page_name' => 'post',
				)
			);

			add_settings_field(
				'after_content',
				__( '本文の下', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_post',
				$this->plugin_name . '_post',
				array(
					'label_for' => 'after_content',
					'page_name' => 'post',
				)
			);

			add_settings_field(
				'before_footer',
				__( 'フッターの上', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_post',
				$this->plugin_name . '_post',
				array(
					'label_for' => 'before_footer',
					'page_name' => 'post',
				)
			);

			add_settings_field(
				'after_footer',
				__( 'フッターの下', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_post',
				$this->plugin_name . '_post',
				array(
					'label_for' => 'after_footer',
					'page_name' => 'post',
				)
			);

			add_settings_field(
				'more',
				__( 'moreタグ（続きを読む）の場所', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_post',
				$this->plugin_name . '_post',
				array(
					'label_for' => 'more',
					'page_name' => 'post',
				)
			);
		}

		/**
		 * フォームの設定（アーカイブページ）
		 */
		public function nishiki_pro_content_archive_register_settings() {
			register_setting(
				$this->plugin_name . '_archive',
				$this->plugin_name . '_archive',
				array( $this, 'sanitize' )
			);

			add_settings_section(
				$this->plugin_name . '_archive',
				__( 'アーカイブページ設定', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_cb' ),
				$this->plugin_name . '_archive'
			);

			add_settings_field(
				'display',
				__( 'コンテンツを表示', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_display_checkbox_cb' ),
				$this->plugin_name . '_archive',
				$this->plugin_name . '_archive',
				array(
					'label_for'   => 'display',
					'page_name'   => 'archive',
					'description' => 'チェックを入れると、設定したコンテンツが表示されます。',
				)
			);

			add_settings_field(
				'archive',
				__( '表示するアーカイブページ', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_display_archive_cb' ),
				$this->plugin_name . '_archive',
				$this->plugin_name . '_archive',
				array(
					'label_for' => 'archive',
					'page_name' => 'archive',
				)
			);

			add_settings_field(
				'exclude_id',
				__( '表示を除外する', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_exclude_id_cb' ),
				$this->plugin_name . '_archive',
				$this->plugin_name . '_archive',
				array(
					'label_for'   => 'exclude_id',
					'page_name'   => 'archive',
					'description' => '除外するアーカイブページのID（カンマ区切りで複数指定）',
				)
			);

			add_settings_field(
				'before_site_header',
				__( 'ヘッダーの上', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_archive',
				$this->plugin_name . '_archive',
				array(
					'label_for' => 'before_site_header',
					'page_name' => 'archive',
					'title'     => '',
				)
			);

			add_settings_field(
				'after_site_header',
				__( 'ヘッダーの下', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_archive',
				$this->plugin_name . '_archive',
				array(
					'label_for' => 'after_site_header',
					'page_name' => 'archive',
					'title'     => '',
				)
			);

			add_settings_field(
				'before_site_nav',
				__( 'ナビゲーションの前', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_archive',
				$this->plugin_name . '_archive',
				array(
					'label_for' => 'before_site_nav',
					'page_name' => 'archive',
					'title'     => '',
				)
			);

			add_settings_field(
				'after_site_nav',
				__( 'ナビゲーションの後', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_archive',
				$this->plugin_name . '_archive',
				array(
					'label_for' => 'after_site_nav',
					'page_name' => 'archive',
					'title'     => '',
				)
			);

			add_settings_field(
				'before_header',
				__( 'ページタイトルの上', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_archive',
				$this->plugin_name . '_archive',
				array(
					'label_for' => 'before_header',
					'page_name' => 'archive',
					'title'     => '',
				)
			);

			add_settings_field(
				'after_header',
				__( 'ページタイトルの下', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_archive',
				$this->plugin_name . '_archive',
				array(
					'label_for' => 'after_header',
					'page_name' => 'archive',
					'title'     => '',
				)
			);

			add_settings_field(
				'before_title',
				__( 'ページタイトルテキストの上', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_archive',
				$this->plugin_name . '_archive',
				array(
					'label_for' => 'before_title',
					'page_name' => 'archive',
				)
			);

			add_settings_field(
				'after_title',
				__( 'ページタイトルテキストの下', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_archive',
				$this->plugin_name . '_archive',
				array(
					'label_for' => 'after_title',
					'page_name' => 'archive',
				)
			);

			add_settings_field(
				'before_content',
				__( '本文の上', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_archive',
				$this->plugin_name . '_archive',
				array(
					'label_for' => 'before_content',
					'page_name' => 'archive',
				)
			);

			add_settings_field(
				'after_content',
				__( '本文の下', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_archive',
				$this->plugin_name . '_archive',
				array(
					'label_for' => 'after_content',
					'page_name' => 'archive',
				)
			);

			add_settings_field(
				'before_footer',
				__( 'フッターの上', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_archive',
				$this->plugin_name . '_archive',
				array(
					'label_for' => 'before_footer',
					'page_name' => 'archive',
				)
			);

			add_settings_field(
				'after_footer',
				__( 'フッターの下', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_archive',
				$this->plugin_name . '_archive',
				array(
					'label_for' => 'after_footer',
					'page_name' => 'archive',
				)
			);

		}

		/**
		 * フォームの設定（検索結果ページ）
		 */
		public function nishiki_pro_content_search_register_settings() {

			register_setting(
				$this->plugin_name . '_search',
				$this->plugin_name . '_search',
				array( $this, 'sanitize' )
			);

			add_settings_section(
				$this->plugin_name . '_search',
				__( 'アーカイブページ設定', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_cb' ),
				$this->plugin_name . '_search'
			);

			add_settings_field(
				'display',
				__( 'コンテンツを表示', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_display_checkbox_cb' ),
				$this->plugin_name . '_search',
				$this->plugin_name . '_search',
				array(
					'label_for'   => 'display',
					'page_name'   => 'search',
					'description' => 'チェックを入れると、設定したコンテンツが表示されます。',
				)
			);

			add_settings_field(
				'before_site_header',
				__( 'ヘッダーの上', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_search',
				$this->plugin_name . '_search',
				array(
					'label_for' => 'before_site_header',
					'page_name' => 'search',
					'title'     => '',
				)
			);

			add_settings_field(
				'after_site_header',
				__( 'ヘッダーの下', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_search',
				$this->plugin_name . '_search',
				array(
					'label_for' => 'after_site_header',
					'page_name' => 'search',
					'title'     => '',
				)
			);

			add_settings_field(
				'before_site_nav',
				__( 'ナビゲーションの前', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_search',
				$this->plugin_name . '_search',
				array(
					'label_for' => 'before_site_nav',
					'page_name' => 'search',
					'title'     => '',
				)
			);

			add_settings_field(
				'after_site_nav',
				__( 'ナビゲーションの後', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_search',
				$this->plugin_name . '_search',
				array(
					'label_for' => 'after_site_nav',
					'page_name' => 'search',
					'title'     => '',
				)
			);

			add_settings_field(
				'before_header',
				__( 'ページタイトルの上', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_search',
				$this->plugin_name . '_search',
				array(
					'label_for' => 'before_header',
					'page_name' => 'search',
					'title'     => '',
				)
			);

			add_settings_field(
				'after_header',
				__( 'ページタイトルの下', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_search',
				$this->plugin_name . '_search',
				array(
					'label_for' => 'after_header',
					'page_name' => 'search',
					'title'     => '',
				)
			);

			add_settings_field(
				'before_title',
				__( 'ページタイトルテキストの上', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_search',
				$this->plugin_name . '_search',
				array(
					'label_for' => 'before_title',
					'page_name' => 'search',
				)
			);

			add_settings_field(
				'after_title',
				__( 'ページタイトルテキストの下', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_search',
				$this->plugin_name . '_search',
				array(
					'label_for' => 'after_title',
					'page_name' => 'search',
				)
			);

			add_settings_field(
				'before_content',
				__( '本文の上', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_search',
				$this->plugin_name . '_search',
				array(
					'label_for' => 'before_content',
					'page_name' => 'search',
				)
			);

			add_settings_field(
				'after_content',
				__( '本文の下', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_search',
				$this->plugin_name . '_search',
				array(
					'label_for' => 'after_content',
					'page_name' => 'search',
				)
			);

			add_settings_field(
				'before_footer',
				__( 'フッターの上', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_search',
				$this->plugin_name . '_search',
				array(
					'label_for' => 'before_footer',
					'page_name' => 'search',
				)
			);

			add_settings_field(
				'after_footer',
				__( 'フッターの下', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_search',
				$this->plugin_name . '_search',
				array(
					'label_for' => 'after_footer',
					'page_name' => 'search',
				)
			);
		}

		/**
		 * フォームの設定（404ページ）
		 */
		public function nishiki_pro_content_404_register_settings() {

			register_setting(
				$this->plugin_name . '_404page',
				$this->plugin_name . '_404page',
				array( $this, 'sanitize' )
			);

			add_settings_section(
				$this->plugin_name . '_404page',
				__( '404ページ設定', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_cb' ),
				$this->plugin_name . '_404page'
			);

			add_settings_field(
				'display',
				__( 'コンテンツを表示', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_display_checkbox_cb' ),
				$this->plugin_name . '_404page',
				$this->plugin_name . '_404page',
				array(
					'label_for'   => 'display',
					'page_name'   => '404page',
					'description' => 'チェックを入れると、設定したコンテンツが表示されます。',
				)
			);

			add_settings_field(
				'before_site_header',
				__( 'ヘッダーの上', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_404page',
				$this->plugin_name . '_404page',
				array(
					'label_for' => 'before_site_header',
					'page_name' => '404page',
					'title'     => '',
				)
			);

			add_settings_field(
				'after_site_header',
				__( 'ヘッダーの下', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_404page',
				$this->plugin_name . '_404page',
				array(
					'label_for' => 'after_site_header',
					'page_name' => '404page',
					'title'     => '',
				)
			);

			add_settings_field(
				'before_header',
				__( 'ページタイトルの上', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_404page',
				$this->plugin_name . '_404page',
				array(
					'label_for' => 'before_header',
					'page_name' => '404page',
					'title'     => '',
				)
			);

			add_settings_field(
				'before_site_nav',
				__( 'ナビゲーションの前', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_404page',
				$this->plugin_name . '_404page',
				array(
					'label_for' => 'before_site_nav',
					'page_name' => '404page',
					'title'     => '',
				)
			);

			add_settings_field(
				'after_site_nav',
				__( 'ナビゲーションの後', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_404page',
				$this->plugin_name . '_404page',
				array(
					'label_for' => 'after_site_nav',
					'page_name' => '404page',
					'title'     => '',
				)
			);

			add_settings_field(
				'after_header',
				__( 'ページタイトルの下', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_404page',
				$this->plugin_name . '_404page',
				array(
					'label_for' => 'after_header',
					'page_name' => '404page',
					'title'     => '',
				)
			);

			add_settings_field(
				'before_title',
				__( 'ページタイトルテキストの上', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_404page',
				$this->plugin_name . '_404page',
				array(
					'label_for' => 'before_title',
					'page_name' => '404page',
				)
			);

			add_settings_field(
				'after_title',
				__( 'ページタイトルテキストの下', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_404page',
				$this->plugin_name . '_404page',
				array(
					'label_for' => 'after_title',
					'page_name' => '404page',
				)
			);

			add_settings_field(
				'before_content',
				__( '本文の上', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_404page',
				$this->plugin_name . '_404page',
				array(
					'label_for' => 'before_content',
					'page_name' => '404page',
				)
			);

			add_settings_field(
				'after_content',
				__( '本文の下', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_404page',
				$this->plugin_name . '_404page',
				array(
					'label_for' => 'after_content',
					'page_name' => '404page',
				)
			);

			add_settings_field(
				'before_footer',
				__( 'フッターの上', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_404page',
				$this->plugin_name . '_404page',
				array(
					'label_for' => 'before_footer',
					'page_name' => '404page',
				)
			);

			add_settings_field(
				'after_footer',
				__( 'フッターの下', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_form_cb' ),
				$this->plugin_name . '_404page',
				$this->plugin_name . '_404page',
				array(
					'label_for' => 'after_footer',
					'page_name' => '404page',
				)
			);
		}


		/**
		 * フォームの設定（ショートコードの説明）
		 */
		public function nishiki_pro_content_shortcode_register_settings() {

			register_setting(
				$this->plugin_name . '_shortcode',
				$this->plugin_name . '_shortcode',
				array( $this, 'sanitize' )
			);

			add_settings_section(
				$this->plugin_name . '_shortcode',
				__( '操作マニュアル', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_content_shortcode_cb' ),
				$this->plugin_name . '_shortcode'
			);

		}

		/**
		 * タブ出力
		 */
		public function create_tab() {
			$admin_url  = 'admin.php?page=nishiki-pro-content.php';
			$flag       = false;
			$tab_array  = $this->tab_array;
			$get_action = ! empty( $_GET['action'] ) ? htmlspecialchars( $_GET['action'] ) : '';

			echo '<div class="nav-tab-wrapper">';
			foreach ( $tab_array as $key => $val ) {
				$active = '';
				if ( ! isset( $get_action ) && false === $flag ) {
					$active = ' nav-tab-active';
					$flag   = 1;
				} elseif ( isset( $get_action ) && $key === $get_action && false === $flag ) {
					$active = ' nav-tab-active';
				}
				if( empty( $get_action ) && 'common' == $key ){
					$active = ' nav-tab-active';
				}
	
				echo '<a href="' . esc_url(
					add_query_arg(
						array(
							'action' => $key,
						),
						$admin_url
					)
				) . '" class="nav-tab' . esc_attr( $active ) . '">' . esc_html( $val ) . '</a>';
			}

			echo '</div>';
		}

		/**
		 * 設定画面出力
		 */
		public function create_setting() {
			$tab_array  = $this->tab_array;
			$flag       = false;
			$get_action = ! empty( $_GET['action'] ) ? htmlspecialchars( $_GET['action'] ) : '';

			foreach ( $tab_array as $key => $val ) {
				if ( ! isset( $get_action ) && false === $flag ) {
					$flag = true;
				} elseif ( isset( $get_action ) && $key === $get_action && false === $flag ) {
					$flag = true;
				}

				if ( true === $flag ) {
					settings_fields( $this->plugin_name . '_' . $key );
					do_settings_sections( $this->plugin_name . '_' . $key );
					// if ( 'shortcode' !== $key ) {
					// submit_button();
					// }

					break;
				}
			}

			if( false === $flag ){
				settings_fields( $this->plugin_name . '_common' );
				do_settings_sections( $this->plugin_name . '_common' );
			}

		}

		/**
		 * オプションページの内容
		 */
		public function nishiki_pro_content_admin_page() {
			$this->options = get_option( 'nishiki_pro_content' );
			if ( ! current_user_can( 'manage_options' ) ) {
				wp_die( 'このページを表示する権限がありません。' );
			}
			?>
					<div class="wrap">
						<h1>再利用コンテンツ管理</h1>
						<p>ウェブサイトの各ページに挿入するコンテンツの管理ができます。</p>
							<?php $this->create_tab(); ?>
						<form method="post" action="options.php">
							<?php $this->create_setting(); ?>
						</form>

						<hr>
						<h3>マニュアルを見る</h3>
						<p>
							<a target="_blank" rel="noopener noreferrer" class="button" href="https://support.animagate.com/manual/wp-nishiki-content-function/">操作マニュアル</a>
							<a target="_blank" rel="noopener noreferrer" class="button" href="https://support.animagate.com/manual/wp-nishiki-content-archive-page/">アーカイブページ向けマニュアル</a>
						</p>
					</div>
			<?php
		}

	}

	if ( is_admin() ) {
		$nishiki_pro_content_admin_page = new NISHIKI_PRO_CONTENT_ADMIN();
	}
}
