<?php
if ( ! class_exists( 'NISHIKI_PRO_CONTENT_MCE' ) ) {
	/**
	 * 旧エディター用ボタン追加（いずれ廃止）
	 */
	class NISHIKI_PRO_CONTENT_MCE extends NISHIKI_PRO_CONTENT_UTILITY {

		/**
		 * Cconstructor.
		 */
		public function __construct() {
			add_action( 'admin_init', array( $this, 'nishiki_pro_content_add_list' ), 20 );
		}

		/**
		 * コンテンツ作成されていた場合はMCEボタンを追加する
		 *
		 * @return void
		 */
		public function nishiki_pro_content_add_list() {
			$content_array = $this->create_content_list_json();

			if ( ! empty( $content_array ) ) {
				if ( current_user_can( 'edit_posts' ) && current_user_can( 'edit_pages' ) ) {
					add_filter( 'mce_buttons_3', array( $this, 'nishiki_pro_content_register_mce' ), 20 );
					wp_localize_script( 'jquery', 'nishiki_pro_content_list', $content_array );
				}
			}
		}

		/**
		 * コンテンツリスト用JSON作成
		 *
		 * @return $content_array
		 */
		public function create_content_list_json() {
			$content_list  = $this->nishiki_pro_content_list();
			$content_array = array();

			foreach ( $content_list as $key => $val ) {
				$content_shortcode = '[nishiki_pro_content id="' . $key . '"]';
				$content_array[]   = array(
					'text'  => $val,
					'value' => $content_shortcode,
				);
			}

			return $content_array;
		}

		/**
		 * コンテンツリストをTinyMCEに登録
		 *
		 * @param array $buttons ボタン
		 *
		 * @return $buttons
		 */
		public function nishiki_pro_content_register_mce( $buttons ) {
			array_push( $buttons, 'separator', 'nishiki_pro_content' );
			return $buttons;
		}

	}

	if ( is_admin() ) {
		$nishiki_pro_content_mce = new NISHIKI_PRO_CONTENT_MCE();
	}
}
