<?php
if ( ! class_exists( 'NISHIKI_PRO_CONTENT_UTILITY' ) ) {
	/**
	 * CONTENT UTILITY.
	 */
	class NISHIKI_PRO_CONTENT_UTILITY {
		/**
		 * Holds the options to be used in the fields callbacks
		 *
		 * @var 0.0.1
		 */
		public $options;

		/**
		 * Holds plugin name
		 *
		 * @var 0.0.1
		 */
		public $plugin_name = 'nishiki_pro_content';

		/**
		 * 表示するタブ
		 *
		 * @var array
		 */
		public $tab_array = array(
			'common'  => '全ページ共通',
			'home'    => 'トップページ',
			'post'    => '投稿・固定ページ',
			'archive' => 'アーカイブページ',
			'search'  => '検索結果ページ',
			'404page' => '404ページ',
		);

		/**
		 * コンテンツを表示する箇所
		 *
		 * @var array
		 */
		public $section_array = array(
			'before_site_header'  => 'ヘッダーの上',
			'after_site_header'  => 'ヘッダーの下',
			'before_site_nav'  => 'ナビゲーションの前',
			'after_site_nav'  => 'ナビゲーションの後',
			'before_header'  => 'ページタイトルの上',
			'after_header'   => 'ページタイトルの下',
			'before_title'   => 'ページタイトルテキストの上',
			'after_title'    => 'ページタイトルテキストの下',
			'before_content' => '本文コンテンツの上',
			'after_content'  => '本文コンテンツの下',
			'before_footer'  => 'フッターの上',
			'after_footer'   => 'フッターの下',
			'more'           => 'moreタグ（続きを読む）の場所',
		);

		/**
		 * フォーム作成（チェックボックス一つ）
		 *
		 * @param string $option_name オプション名
		 * @param string $section セクション
		 * @param string $title タイトル名
		 * @param string $label ラベル名
		 * @return void
		 */
		public function create_form_checkbox( $option_name, $section, $title, $label ) {
			$this->options = get_option( $option_name );
			$label_name    = $section . '_' . $label;
			if ( isset( $this->options['display'] ) ) {
				$checked = ' checked="checked"';
			} else {
				$checked = '';
			}

			echo '<p><input type="checkbox" id="' . esc_attr( $label_name ) . '" name="' . esc_attr( $option_name ) . '[' . esc_attr( $section ) . ']" value="1"' . esc_attr( $checked ) . '><label for="' . esc_attr( $label_name ) . '">' . esc_html( $title ) . '</label></p>';
		}

		/**
		 * フォーム作成（チェックボックス複数）
		 *
		 * @param string $option_name オプション名
		 * @param string $section セクション
		 * @param array  $data_array データ配列
		 * @param string $title タイトル名
		 * @param string $label ラベル名
		 * @return void
		 */
		public function create_form_checkbox_multiple( $option_name, $section, $data_array, $title, $label ) {
			$this->options = get_option( $option_name );

			echo '<ul>';
			foreach ( $data_array as $key => $title ) {
				$checked = '';
				if ( isset( $this->options[ $section ] ) ) {
					if ( array_key_exists( $key, $this->options[ $section ] ) ) {
						$checked = ' checked="checked"';
					}
				}
				$label_name = $section . '_' . $key;

				echo '<li><input type="checkbox" id="' . esc_attr( $label_name ) . '" name="' . esc_attr( $option_name ) . '[' . esc_attr( $section ) . '][' . esc_attr( $key ) . ']" value="1"' . esc_attr( $checked ) . '><label for="' . esc_attr( $label_name ) . '">' . esc_html( $title ) . '（' . esc_html( $key ) . '）</label></li>';
			}
			echo '</ul>';
		}

		/**
		 * フォーム作成（テキスト）
		 *
		 * @param string $option_name オプション名
		 * @param string $section セクション
		 * @param string $title タイトル名
		 * @param string $label ラベル名
		 * @param string $placeholder プレースホルダー
		 * @return void
		 */
		public function create_form_text( $option_name, $section, $title, $label, $placeholder = '' ) {
			$data = '';
			if ( ! empty( $label ) ) {
				$label_data = '[' . $label . ']';
				$label_name = $section . '_' . $label;

				if ( isset( $this->options[ $label ][ $section ] ) ) {
					$data = $this->options[ $label ][ $section ];
				}
			} else {
				$label_data = '';
				$label_name = $section;

				if ( isset( $this->options[ $section ] ) ) {
					$data = $this->options[ $section ];
				}
			}

			if ( ! empty( $title ) ) {
				echo '<h4><label for="' . esc_attr( $label_name ) . '">' . esc_html( $title ) . '</label></h4>';
			}
			echo '<p><input placeholder="' . esc_attr( $placeholder ) . '" type="text" id="' . esc_attr( $label_name ) . '" name="' . esc_attr( $option_name ) . esc_attr( $label_data ) . '[' . esc_attr( $section ) . ']" value="' . esc_attr( $data ) . '" /></p>';
		}

		/**
		 * フォーム作成（テキストエリア）
		 *
		 * @param string $option_name オプション名
		 * @param string $section セクション
		 * @param string $title タイトル
		 * @param string $label ラベル
		 * @return void
		 */
		public function create_form_textarea( $option_name, $section, $title, $label ) {
			$data       = '';
			$label_name = $section . '_' . $label;
			if ( isset( $this->options[ $label ][ $section ] ) ) {
				$data = $this->options[ $label ][ $section ];
			}

			// var_dump($data);

			if ( ! empty( $title ) ) {
				echo '<h4><label for="' . esc_attr( $label_name ) . '">' . esc_html( $title ) . '</label></h4>';
			}

			$content   = $data; // あらかじめ表示させておきたい内容
			$editor_id = $label_name; // エディターを区別するために、IDを指定する
			$settings  = array( 'textarea_name' => esc_attr( $option_name ) . '[' . esc_attr( $label ) . '][' . esc_attr( $section ) . ']' ); // 配列としてデータを渡すためname属性指定
			wp_editor( $content, $editor_id, $settings );
		}

		/**
		 * フォーム作成（セレクトボックス）
		 *
		 * @param string $option_name オプション名
		 * @param string $section セクション
		 * @param array  $data_array データ配列
		 * @param string $title タイトル名
		 * @param string $label ラベル名
		 * @return boolean
		 */
		public function create_form_select_box( $option_name, $section, $data_array, $title, $label ) {
			$label_name = $section . '_' . $label;

			if ( ! empty( $title ) ) {
				echo '<h4><label for="' . esc_attr( $label_name ) . '">' . esc_html( $title ) . '</label></h4>';
			}

			echo '<select name="' . esc_attr( $option_name ) . '[' . esc_attr( $label ) . '][' . esc_attr( $section ) . ']" id="' . esc_attr( $label_name ) . '">';
			echo '<option value=""> - 未選択 - </option>';
			if ( ! empty( $data_array ) ) {
				foreach ( $data_array as $key => $type ) {
					if ( isset( $this->options[ $label ][ $section ] ) && $this->options[ $label ][ $section ] === (string) $key ) {
						$selected = ' selected="selected"';
					} else {
						$selected = '';
					}
					echo '<option value="' . esc_attr( $key ) . '"' . esc_attr( $selected ) . '>' . esc_html( $type ) . '</option>';
				}
			}
			echo '</select>';

			return true;
		}

		/**
		 * フォームの出力（全ページ）
		 *
		 * @return void
		 */
		public function nishiki_pro_content_cb() {
			$nonce = wp_create_nonce( 'nishiki_pro_content' );
			echo '<input type="hidden" name="nishiki_pro_content" value="' . esc_attr( $nonce ) . '" />';
		}

		/**
		 * クライアントID(全ページ共通)
		 *
		 * @param array $args 設定
		 * @return void
		 */
		public function nishiki_pro_content_common_client_id_cb( $args ) {
			$option_name   = $this->plugin_name . '_' . $args['page_name'];
			$this->options = get_option( $option_name );

			$this->create_form_text( $option_name, $args['label_for'], '', '', 'pub-xxxxxxxxxxxxxxxx' );

			if ( ! empty( $args['description'] ) ) {
				echo '<p class="description">' . esc_html( $args['description'] ) . '</p>';
			}
		}

		/**
		 * 投稿タイプ選択
		 *
		 * @param array $args 設定
		 * @return void
		 */
		public function nishiki_pro_content_display_post_type_cb( $args ) {
			$option_name   = $this->plugin_name . '_' . $args['page_name'];
			$this->options = get_option( $option_name );

			$pt_args  = array(
				'public' => true,
			);
			$output   = 'objects';
			$operator = 'and';
			$pts      = get_post_types( $pt_args, $output, $operator );

			$pt_array = array();

			foreach ( $pts as $pt ) {
				if ( 'attachment' !== $pt->name ) {
					$pt_array[ $pt->name ] = $pt->label;
				}
			}

			$this->create_form_checkbox_multiple( $option_name, $args['label_for'], $pt_array, '投稿タイプ', '' );

			if ( ! empty( $args['description'] ) ) {
				echo '<p class="description">' . esc_html( $args['description'] ) . '</p>';
			}

		}

		/**
		 * アーカイブページ選択
		 *
		 * @param array $args 設定
		 * @return void
		 */
		public function nishiki_pro_content_display_archive_cb( $args ) {
			$option_name   = $this->plugin_name . '_' . $args['page_name'];
			$this->options = get_option( $option_name );

			$archives       = $this->nishiki_pro_content_taxonomy_list();
			$archives_array = array();

			foreach ( $archives as $archive ) {
				if ( 'post_format' !== $archive->name ) {
					$archives_array[ $archive->name ] = $archive->label;
				}
			}

			$this->create_form_checkbox_multiple( $option_name, $args['label_for'], $archives_array, 'アーカイブページ', '' );

			if ( ! empty( $args['description'] ) ) {
				echo '<p class="description">' . esc_html( $args['description'] ) . '</p>';
			}
		}

		/**
		 * タクソノミーリスト
		 *
		 * @return $taxonomies
		 */
		public function nishiki_pro_content_taxonomy_list() {
			$args       = array(
				'public' => true,
			);
			$output     = 'objects';
			$operator   = 'and';
			$taxonomies = get_taxonomies( $args, $output, $operator );

			return $taxonomies;
		}

		/**
		 * 除外 ID
		 *
		 * @param array $args 設定
		 * @return void
		 */
		public function nishiki_pro_content_exclude_id_cb( $args ) {
			$option_name   = $this->plugin_name . '_' . $args['page_name'];
			$this->options = get_option( $option_name );

			$this->create_form_text( $option_name, $args['label_for'], '', '' );

			if ( ! empty( $args['description'] ) ) {
				echo '<p class="description">' . esc_html( $args['description'] ) . '</p>';
			}
		}

		/**
		 * フォーム作成（コンテンツ）
		 *
		 * @param array $args 設定
		 * @return void
		 */
		public function nishiki_pro_content_form_cb( $args ) {
			$option_name   = $this->plugin_name . '_' . $args['page_name'];
			$this->options = get_option( $option_name );

			echo '<hr>';

			// コンテンツ選択
			$content_array = $this->nishiki_pro_content_list();
			$this->create_form_select_box( $option_name, 'select_content', $content_array, '追加するコンテンツを選択', $args['label_for'] );

			// $this->create_form_textarea( $option_name, 'wp_editor', 'HTMLを追加する', $args['label_for'] );

			if ( ! empty( $args['description'] ) ) {
				echo '<p class="description">' . esc_html( $args['description'] ) . '</p>';
			}

			$this->create_form_text( $option_name, 'priority', '追加するコンテンツの優先度（上級者設定）', $args['label_for'] );
			echo '<p class="description">初期値：10（特に指定がない場合は、空欄のままで大丈夫です）</p>';

			submit_button();
		}

		/**
		 * フォーム作成（表示チェック）
		 *
		 * @param array $args 設定
		 * @return void
		 */
		public function nishiki_pro_content_display_checkbox_cb( $args ) {
			$option_name   = $this->plugin_name . '_' . $args['page_name'];
			$this->options = get_option( $option_name );

			$this->create_form_checkbox( $option_name, 'display', '表示する', $args['label_for'] );

			if ( ! empty( $args['description'] ) ) {
				echo '<p class="description">' . esc_html( $args['description'] ) . '</p>';
			}

			submit_button();
		}

		/**
		 * ショートコードの説明
		 *
		 * @return void
		 */
		public function nishiki_pro_content_shortcode_cb() {
			echo 'ただいまページ作成中です。';
		}

		/**
		 * 入力値のサニタイズ
		 *
		 * @param array $input Contains all settings fields as array keys
		 */
		public function sanitize( $input ) {
			$new_input = array();

			$section_array = $this->section_array;
			foreach ( $section_array as $key => $val ) {
				// 配列
				if ( isset( $input[ $key ] ) ) {
					foreach ( $input[ $key ] as $section => $data ) {
						if ( 'select_content' === $section ) {
							$new_input[ $key ][ $section ] = sanitize_key( $data );
						} else {
							$new_input[ $key ][ $section ] = sanitize_textarea_field( $data );
						}
					}
				}
			}

			// 投稿タイプ
			if ( isset( $input['post_type'] ) ) {
				$new_input['post_type'] = array_map( 'strip_tags', $input['post_type'] );
			}

			// アーカイブ
			if ( isset( $input['archive'] ) ) {
				$new_input['archive'] = array_map( 'strip_tags', $input['archive'] );
			}

			// チェックボックス
			if ( isset( $input['display'] ) ) {
				$new_input['display'] = absint( $input['display'] );
			}

			// テキスト
			if ( isset( $input['exclude_id'] ) ) {
				$new_input['exclude_id'] = sanitize_text_field( $input['exclude_id'] );
			}

			// wp_die(var_dump($new_input));
			return $new_input;
		}

		/**
		 * カスタム投稿タイプかどうかチェック
		 *
		 * @return boolean
		 */
		public function is_custom_post_type() {
			$post_obj = get_post_type_object( get_post_type() );
			if ( ! empty( $post_obj ) && false === $post_obj->_builtin ) {
				return $post_obj;
			} else {
				return false;
			}
		}

		/**
		 * 表示設定チェック
		 *
		 * @return boolean
		 */
		public function is_nishiki_pro_content_display() {
			$options = get_option( 'nishiki_pro_content_common' );

			if ( empty( $options ) ) {
				return false;
			}

			if ( empty( $options['display'] ) ) {
				return false;
			}

			return $options;
		}

		/**
		 * コンテンツリスト
		 *
		 * @return $nishiki_pro_content_array
		 */
		public function nishiki_pro_content_list() {
			if ( ! post_type_exists( 'nishiki_pro_content' ) ) {
				return false;
			}
			$nishiki_pro_content_array = array();
			$content_array             = get_posts(
				array(
					'post_type'      => 'nishiki_pro_content',
					'post_status'    => 'publish',
					'posts_per_page' => -1,
				)
			);

			// $nishiki_pro_content_array[0] = '選択してください';
			foreach ( $content_array as $post_data ) {
				$nishiki_pro_content_array[ $post_data->ID ] = $post_data->post_title;
			}

			wp_reset_postdata();
			return $nishiki_pro_content_array;
		}

		/**
		 * Autop フィルターの除去 & 再適用
		 *
		 * @return void
		 */
		public function remove_restore_autop_the_content() {
			$priority = has_filter( 'the_content', 'wpautop' );
			remove_filter( 'the_content', 'wpautop', $priority );
			add_filter( 'the_content', '_restore_wpautop_hook', $priority + 1 );
		}

	}
}
