<?php
if ( ! class_exists( 'NISHIKI_PRO_CONTENT' ) ) {
	/**
	 * 再利用コンテンツ
	 */
	class NISHIKI_PRO_CONTENT extends NISHIKI_PRO_CONTENT_UTILITY {
		/**
		 * Constructor.
		 */
		public function __construct() {
			add_action(
				'template_redirect',
				function() {
					$this->output( 'home' );
					$this->output( 'post' );
					$this->output( 'archive' );
					$this->output( 'search' );
					$this->output( '404page' );
				}
			);
		}

		/**
		 * コンテンツ出力
		 *
		 * @param string $page_name ページ名
		 * @return boolean
		 */
		public function output( $page_name ) {
			switch ( $page_name ) {
				case 'home':
					// トップページのみ（2ページ以降は非表示）
					if ( ! ( ( is_home() || is_front_page() ) && ! is_paged() ) ) {
						return false;
					}
					break;
				case 'post':
					if ( ! is_singular() || nishiki_pro_is_static_front_page() ) {
						return false;
					}
					break;
				case 'archive':
					if ( ! is_archive() ) {
						return false;
					}
					break;
				case 'search':
					if ( ! is_search() ) {
						return false;
					}
					break;
				case '404page':
					if ( ! is_404() ) {
						return false;
					}
					break;
			}

			global $post;

			$queried_object = get_queried_object();
			$common_data    = $this->is_nishiki_pro_content_display();

			if ( ! empty( $common_data['display'] ) ) {
				$flag    = false;
				$options = get_option( $this->plugin_name . '_' . $page_name );

				if ( 'home' === $page_name ) {
					$flag = true;
				}

				// var_dump($this->plugin_name . '_' . $page_name);

				if ( 'post' === $page_name ) {
					$post_types  = array();
					$exclude_ids = array();

					if ( ! empty( $options['post_type'] ) ) {
						$post_types = $options['post_type'];
					}
					if ( ! empty( $options['exclude_id'] ) ) {
						$exclude_ids = array_map( 'intval', explode( ',', $options['exclude_id'] ) );
					}

					// 配列から削除
					unset( $options['post_type'] );
					unset( $options['exclude_id'] );

					// 投稿タイプ
					if ( empty( $post_types ) ) {
						return false;
					}

					if ( array_key_exists( $post->post_type, $post_types ) && ! in_array( $post->ID, $exclude_ids, true ) ) {
						$flag = true;
					}
				}

				if ( 'archive' === $page_name ) {
					$archives    = array();
					$exclude_ids = array();

					if ( ! empty( $options['archive'] ) ) {
						$archives = $options['archive'];
					}
					if ( ! empty( $options['exclude_id'] ) ) {
						$exclude_ids = array_map( 'intval', explode( ',', $options['exclude_id'] ) );
					}
					// 配列から削除
					unset( $options['archive'] );
					unset( $options['exclude_id'] );

					// 投稿タイプ
					if ( empty( $archives ) ) {
						return false;
					}

					if ( ! empty( $queried_object->taxonomy ) ) {
						if ( array_key_exists( $queried_object->taxonomy, $archives ) && ! in_array( $queried_object->term_taxonomy_id, $exclude_ids, true ) ) {
							$flag = true;
						}
					}

					if ( class_exists( 'WooCommerce' ) ) {
						if ( is_shop() || is_product_taxonomy() ) {
							$flag = true;
						}
					}
				}

				// var_dump($queried_object);

				if ( 'search' === $page_name ) {
					$flag = true;
				}

				if ( '404page' === $page_name ) {
					$flag = true;
				}

				// var_dump( $queried_object );
				// var_dump($options);
				// var_dump($exclude_ids);
				// var_dump($flag);

				// 表示チェック確認ができていたら出力
				if ( ! empty( $options['display'] ) && true === $flag ) {

					// 配列から削除
					unset( $options['display'] );

					foreach ( $options as $section => $values ) {
						$this->create_content( $page_name, $section, $values );
					}
				}
			}

			return true;
		}

		/**
		 * セクション別でコードを作成
		 *
		 * @param string $page_name ページ名
		 * @param string $section セクション
		 * @param array  $values 値
		 * @return void
		 */
		public function create_content( $page_name, $section, $values ) {
			$hook_name       = $this->create_hook_name( $page_name, $section );
			$current_page_id = '';
			$flag            = false;

			// var_dump($hook_name);

			if ( empty( $values['priority'] ) ) {
				$values['priority'] = 10;
			}

			// ページ別IDチェック
			if ( is_archive() ) {
				$current_page_id = get_queried_object_id();

				// WooCommercアーカイブページの場合
				if ( class_exists( 'WooCommerce' ) ) {
					if ( is_shop() ) {
						$current_page_id = wc_get_page_id( 'shop' );
					} elseif ( is_product_taxonomy() ) {
						$current_page_id = get_queried_object_id();
					}
				}
			} elseif ( is_singular() ) {
				$current_page_id = get_the_ID();
			}

			// 再利用コンテンツ管理で選択した再利用コンテンツのID
			$select_content_page_id = $values['select_content'];

			// 投稿・固定・アーカイブページ別設定チェック
			if ( ! empty( $current_page_id ) ) {
				// 　ページごとに設定した再利用コンテンツのID
				$content_page_id = $this->personal_content_check( $current_page_id, $section, $values );

				// disable の時は表示しない
				if ( 'disabled' !== $content_page_id ) {

					if ( ! empty( $content_page_id ) ) {
						if ( 'more' === $section ) {
							add_filter(
								'the_content',
								function( $content ) use ( $hook_name, $values, $current_page_id, $content_page_id ) {
									$more_tag = '<span id="more-' . $current_page_id . '"></span>';
									$class    = str_replace( '_', '-', $hook_name );
									$custom_class = '';

									if( get_post_meta( $content_page_id, '_nishiki_pro_meta_box_class_nishiki_pro_content', true ) ){
										$custom_class =' ' . get_post_meta( $content_page_id, '_nishiki_pro_meta_box_class_nishiki_pro_content', true );
									}

									// コンテンツ専用ショートコード除外
									$post_content = preg_replace( '/\[nishiki_pro_content(.*?)\]/s', '', apply_filters( 'the_content', get_post_field( 'post_content', $content_page_id ) ) );
									$post_content = str_replace( ']]>', ']]&gt;', $post_content );

									$this->remove_restore_autop_the_content();

									$add_content = $more_tag . '<div class="' . esc_attr( $class ) . esc_attr( $custom_class ) . ' nishiki-pro-content nishiki-pro-content-more nishiki-pro-content-' . $current_page_id . '">' . $post_content . '</div>';

									return str_replace( $more_tag, $add_content, $content );
								},
								$values['priority']
							);
						} else {
							// 個別設定をしていた場合
							add_action(
								$hook_name,
								function() use ( $hook_name, $values, $current_page_id, $content_page_id ) {
									$class = str_replace( '_', '-', $hook_name );
									$custom_class = '';

									if( get_post_meta( $content_page_id, '_nishiki_pro_meta_box_class_nishiki_pro_content', true ) ){
										$custom_class =' ' . get_post_meta( $content_page_id, '_nishiki_pro_meta_box_class_nishiki_pro_content', true );
									}

									// コンテンツ専用ショートコード除外
									$post_content = preg_replace( '/\[nishiki_pro_content(.*?)\]/s', '', apply_filters( 'the_content', get_post_field( 'post_content', $content_page_id ) ) );
									$post_content = str_replace( ']]>', ']]&gt;', $post_content );

									$this->remove_restore_autop_the_content();

									echo '<div class="' . esc_attr( $class ) . esc_attr( $custom_class ) . ' nishiki-pro-content nishiki-pro-content-' . esc_attr( $current_page_id ) . '">' . $post_content . '</div>'; // phpcs:ignore

								},
								$values['priority']
							);
						}
					} else {
						add_action(
							$hook_name,
							function() use ( $hook_name, $section, $values ) {
								$class = str_replace( '_', '-', $hook_name );

								// var_dump($values);
								if ( ! empty( $values['select_content'] ) ) {
									$select_content = absint( $values['select_content'] );
								} else {
									$select_content = 0;
								}

								if ( 0 !== $select_content ) {
									$post_content = apply_filters( 'the_content', get_post_field( 'post_content', $select_content ) );
									$post_content = str_replace( ']]>', ']]&gt;', $post_content );

									$this->remove_restore_autop_the_content();

									echo '<div class="' . esc_attr( $class ) . ' nishiki-pro-content nishiki-pro-content-' . esc_attr( $section ) . '">' . $post_content . '</div>'; // phpcs:ignore
								}

							},
							$values['priority']
						);
					}
				}
			} elseif ( is_404() || is_search() || ( is_front_page() && is_home() && ! is_paged() ) ) {
				add_action(
					$hook_name,
					function() use ( $hook_name, $section, $values ) {
						$class = str_replace( '_', '-', $hook_name );

						if ( ! empty( $values['select_content'] ) ) {
							$select_content = absint( $values['select_content'] );
						} else {
							$select_content = 0;
						}

						if ( 0 !== $select_content ) {
							$post_content = apply_filters( 'the_content', get_post_field( 'post_content', $select_content ) );
							$post_content = str_replace( ']]>', ']]&gt;', $post_content );

							$this->remove_restore_autop_the_content();

							echo '<div class="' . esc_attr( $class ) . ' nishiki-pro-content nishiki-pro-content-' . esc_attr( $section ) . '">' . $post_content . '</div>'; // phpcs:ignore
						}

					},
					$values['priority']
				);
			}
		}

		/**
		 * ページ別設定 チェック
		 *
		 * @param int    $page_id ページ ID
		 * @param string $section セクション
		 * @param array  $values 値
		 * @return $content_page_id
		 */
		public function personal_content_check( $page_id, $section, $values ) {
			// 個別設定をチェック
			$content_page_id     = '';
			$personal_content_id = '';

			if ( is_singular() ) {
				$personal_content_id = get_post_meta( $page_id, '_' . $section, true );
			} elseif ( is_archive() ) {
				$personal_content_id = get_term_meta( $page_id, $section, true );

				// WooCommercアーカイブページの場合
				if ( class_exists( 'WooCommerce' ) ) {
					if ( is_shop() ) {
						$personal_content_id = get_post_meta( $page_id, '_' . $section, true );
					} elseif ( is_product_taxonomy() ) {
						$personal_content_id = get_term_meta( $page_id, $section, true );
					}
				}
			}

			// var_dump($personal_content_id);

			if ( 'disabled' !== $personal_content_id ) {
				if ( ! empty( $personal_content_id ) ) {
					$content_page_id = absint( $personal_content_id );
				} elseif ( ! empty( $values['select_content'] ) ) {
					$content_page_id = absint( $values['select_content'] );
				}
				// 非表示の場合
			} else {
				$content_page_id = $personal_content_id;
			}

			return $content_page_id;
		}

		/**
		 * フック名作成
		 *
		 * @param string $page_name ページ名
		 * @param string $section セクション
		 * @return mixed
		 */
		public function create_hook_name( $page_name, $section ) {
			if ( empty( $page_name ) || empty( $section ) ) {
				return false;
			}

			$hook_name = '';
			$name      = '';

			switch ( $page_name ) {
				case 'home':
					if ( ! is_page_template() ) {
						$name = 'home';
					} else {
						$name = 'singular';
					}
					break;
				case 'post':
					if ( is_front_page() ) {
						$name = 'home';
					} else {
						$name = 'singular';
					}
					break;
				case 'page':
					if ( is_front_page() ) {
						$name = 'home';
					} else {
						$name = 'singular';
					}
					break;
				case 'archive':
					$name = 'archive';
					break;
				case 'search':
					$name = 'search';
					break;
				case '404page':
					$name = '404';
					break;
			}

			$pieces = explode( '_', $section );

			// moreの時
			if ( 'more' === $pieces[0] ) {
			} elseif ( '' === $name || 'footer' === $pieces[1] ) {
				// フッターの場合のフック
				$hook_name = 'nishiki_pro_' . $pieces[0] . '_site_' . $pieces[1];
				// } elseif( $pieces[1] === 'footer' || $pieces[1] === 'header' ){
			} elseif ( isset( $pieces[2] ) && ( 'site' === $pieces[1] || 'header' === $pieces[2] ) ) {
				// ヘッダーの場合のフック
				$hook_name = 'nishiki_pro_' . $pieces[0] . '_' . $pieces[1] . '_' . $pieces[2];
			} else {
				$hook_name = 'nishiki_pro_' . $pieces[0] . '_' . $name . '_' . $pieces[1];
			}

			return $hook_name;
		}

	}
}

$output = new NISHIKI_PRO_CONTENT();
