<?php
if ( ! class_exists( 'NISHIKI_PRO_CSS' ) ) {
	/**
	 * Create Code.
	 */
	class NISHIKI_PRO_CSS extends NISHIKI_PRO_GENERAL_UTILITY {

		/**
		 * Constructor.
		 */
		public function __construct() {
			// フォーム追加
			add_action( 'admin_init', array( $this, 'nishiki_pro_register_settings' ), 20 );

			// Codemirror 追加
			$get_page = ! empty( $_GET['page'] ) ? htmlspecialchars( $_GET['page'] ) : '';
			$get_action = ! empty( $_GET['action'] ) ? htmlspecialchars( $_GET['action'] ) : '';

			if ( 'nishiki-pro-general.php' === $get_page && 'css' === $get_action ) {
				add_action( 'admin_enqueue_scripts', array( $this, 'codemirror_enqueue_scripts' ), 10 );
			}

			// インラインで読み込む（フロント）
			add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_inline_style' ), 100 );

			// インラインで読み込む（管理画面）
//			add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_admin_inline_style' ), 100 );
			add_filter( 'block_editor_settings_all',  array( $this, 'enqueue_admin_inline_style' ), 100, 2 );

			// インラインで読み込む（両方）
			add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_front_admin_inline_style' ), 100 );
//			add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_both_admin_inline_style' ), 100 );
			add_filter( 'block_editor_settings_all',  array( $this, 'enqueue_editor_admin_inline_style' ), 100, 2 );
		}

		/**
		 * Codemirror 追加
		 *
		 * @return void
		 */
		public function codemirror_enqueue_scripts() {
			$cm_settings['codeEditor'] = wp_enqueue_code_editor( array( 'type' => 'text/css' ) );
			wp_localize_script( 'wp-theme-plugin-editor', 'cm_settings', $cm_settings );

			wp_enqueue_script( 'wp-theme-plugin-editor' );
			wp_enqueue_style( 'wp-codemirror' );

			wp_enqueue_script(
				'wp-theme-plugin-script',
				get_template_directory_uri() . '/assets/js/code-mirror.js',
				array( 'wp-theme-plugin-editor' ),
				'1.0.0',
				false
			);

		}

		/**
		 * フォームの設定(基本)
		 */
		public function nishiki_pro_register_settings() {
			$page_name = $this->plugin_name . '_css';

			register_setting(
				$page_name,
				$page_name,
				array( $this, 'sanitize' )
			);

			add_settings_section(
				$page_name,
				'',
				array( $this, 'nishiki_pro_general_cb' ),
				$page_name
			);

			add_settings_field(
				'css_front_end',
				__( '追加 CSS（フロント画面）', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_textarea_cb' ),
				$page_name,
				$page_name,
				array(
					'title'       => '',
					'label'       => 'css_front_end',
					'page_name'   => $page_name,
					'description' => 'ここに書いた CSS はフロント画面のみ反映されます。',
					'priority'    => false,
				)
			);

			add_settings_field(
				'css_back_end',
				__( '追加 CSS（管理画面）', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_textarea_cb' ),
				$page_name,
				$page_name,
				array(
					'title'       => '',
					'label'       => 'css_back_end',
					'page_name'   => $page_name,
					'description' => 'ここに書いた CSS は管理画面のみ反映されます。',
					'priority'    => false,
				)
			);

			add_settings_field(
				'css',
				__( '追加 CSS（両方）', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_textarea_cb' ),
				$page_name,
				$page_name,
				array(
					'title'       => '',
					'label'       => 'css',
					'page_name'   => $page_name,
					'description' => 'ここに書いた CSS はフロント画面と管理画面の両方に反映されます。',
					'priority'    => false,
				)
			);

		}

		/**
		 * 入力値のサニタイズ
		 *
		 * @param array $input Contains all settings fields as array keys
		 */
		public function sanitize( $input ) {
			$new_input = array();

			// チェックボックス absint
			// テキスト stripslashes

			if ( isset( $input['css_front_end'] ) ) {
				$new_input['css_front_end'] = stripslashes( $input['css_front_end'] );
			}

			if ( isset( $input['css_back_end'] ) ) {
				$new_input['css_back_end'] = stripslashes( $input['css_back_end'] );
			}

			if ( isset( $input['css'] ) ) {
				$new_input['css'] = stripslashes( $input['css'] );
			}

			// wp_die(var_dump($input));
			return $new_input;
		}


		/**
		 * スクリプト読み込み（フロントエンド）
		 *
		 * @return void
		 */
		public function enqueue_inline_style() {
			$page_name = $this->plugin_name . '_css';
			$options   = get_option( $page_name );

			if ( ! empty( $options['css_front_end'] ) ) {
				$str    = array( "\t", "\r\n", "\r", "\n" );
				$output = str_replace( $str, '', $options['css_front_end'] );

				// インラインで読み込む
				wp_add_inline_style( 'nishiki-pro-main-style', $output );
			}

		}

		/**
		 * スクリプト読み込み（管理画面）
		 *
		 * @return void
		 */
		public function enqueue_admin_inline_style( $editor_settings, $editor_context ) {
			$page_name = $this->plugin_name . '_css';
			$options   = get_option( $page_name );

			if ( ! empty( $options['css_back_end'] ) ) {
				$str    = array( "\t", "\r\n", "\r", "\n" );
				$output = str_replace( $str, '', $options['css_back_end'] );

				// インラインで読み込む
//				wp_add_inline_style( 'wp-admin', $output );
				$editor_settings["styles"][] = array( "css" => $output );
			}

			return $editor_settings;
		}

		/**
		 * スクリプト読み込み（両方：フロント）
		 */
		public function enqueue_front_admin_inline_style() {
			$page_name = $this->plugin_name . '_css';
			$options   = get_option( $page_name );

			if ( ! empty( $options['css'] ) ) {
				$str    = array( "\t", "\r\n", "\r", "\n" );
				$output = str_replace( $str, '', $options['css'] );

				// インラインで読み込む
				wp_add_inline_style( 'nishiki-pro-main-style', $output );
			}
		}

		/**
		 * スクリプト読み込み（両方：エディター）
		 */
		public function enqueue_editor_admin_inline_style( $editor_settings, $editor_context ) {
			$page_name = $this->plugin_name . '_css';
			$options   = get_option( $page_name );

			if ( ! empty( $options['css'] ) ) {
				$str    = array( "\t", "\r\n", "\r", "\n" );
				$output = str_replace( $str, '', $options['css'] );

//				wp_add_inline_style( 'wp-admin', $output );
				$editor_settings["styles"][] = array( "css" => $output );
			}

			return $editor_settings;
		}
	}
}

$output = new NISHIKI_PRO_CSS();
