<?php
if ( ! class_exists( 'NISHIKI_PRO_FONT' ) ) {
	/**
	 * Create Code.
	 */
	class NISHIKI_PRO_FONT extends NISHIKI_PRO_GENERAL_UTILITY {

		/**
		 * Constructor.
		 */
		public function __construct() {
			// フォーム追加
			add_action( 'admin_init', array( $this, 'nishiki_pro_register_settings' ), 20 );
		}

		/**
		 * フォームの設定(基本)
		 */
		public function nishiki_pro_register_settings() {
			$page_name = $this->plugin_name . '_font';

			register_setting(
				$page_name,
				$page_name,
				array( $this, 'sanitize' )
			);

			add_settings_section(
				$page_name,
				'',
				array( $this, 'nishiki_pro_general_cb' ),
				$page_name
			);

			add_settings_field(
				'font_family',
				__( 'フォント（font-family）指定', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_textarea_cb' ),
				$page_name,
				$page_name,
				array(
					'title'       => '',
					'label'       => 'font_family',
					'page_name'   => $page_name,
					'description' => '空欄の場合は「' . NISHIKI_PRO_FONT_FAMILY . '」が自動で設定されます。',
					'priority'    => false,
				)
			);

		}

		/**
		 * 入力値のサニタイズ
		 *
		 * @param array $input Contains all settings fields as array keys
		 */
		public function sanitize( $input ) {
			$new_input = array();

			// チェックボックス absint
			// テキスト stripslashes

			if ( isset( $input['font_family'] ) ) {
				$new_input['font_family'] = stripslashes( $input['font_family'] );
			}

			// wp_die(var_dump($new_input));
			return $new_input;
		}


	}
}

$output = new NISHIKI_PRO_FONT();
