<?php
if ( ! class_exists( 'NISHIKI_PRO_META_JSON_LD' ) ) {
	/**
	 * JSON-LD
	 */
	class NISHIKI_PRO_META_JSON_LD {
		/**
		 * ウェブサイト
		 *
		 * @var array
		 */
		private $data_website = array();

		/**
		 * 投稿タイプ
		 *
		 * @var array
		 */
		private $data_post_type = array();

		/**
		 * ウェブサイトのタイプ
		 *
		 * @var array
		 */
		private $data_website_type = array();

		/**
		 * Website.
		 *
		 * @link https://developers.google.com/search/docs/guides/intro-structured-data
		 */
		public function website() {
			$this->data_website = array(
				'@context' => 'http://schema.org',
				'@type'    => 'WebSite',
				'@id'      => '#website',
				'url'      => get_home_url(),
				'name'     => get_bloginfo( 'name' ),
			);

			$option = get_option( 'nishiki_pro_meta_json_ld' );
			if ( isset( $option['search'] ) && 1 === $option['search'] ) {
				$this->search_action();
			}

			return $this->data_website;
		}

		/**
		 * Searchaction.
		 */
		private function search_action() {
			$this->data_website['potentialAction'] = array(
				'@type'       => 'SearchAction',
				'target'      => get_home_url() . '?s={search_term_string}',
				'query-input' => 'required name=search_term_string',
			);
		}

		/**
		 * Website Type.
		 */
		private function website_type() {
			$website_type = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_website_type', '' );

			if ( empty( $website_type ) || 'none' === $website_type ) {
				return false;
			}

			$type = '';
			$id   = '';
			$name = '';
			$logo = '';

			if ( 'Organization' === $website_type ) {
				$type = 'Organization';
				$id   = '#organization';
				$name = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_organization_name', '' );
				$logo = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_organization_logo_url', '' );

			} elseif ( 'Person' === $website_type ) {
				$type = 'Person';
				$id   = '#person';
				$name = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_person_name', '' );
			}

			$this->data_website_type = array(
				'@context' => 'http://schema.org',
				'@type'    => $type,
				'@id'      => $id,
				'name'     => $name,
				'url'      => get_permalink(),
				'sameAs'   => $this->sameas(),
			);

			if ( ! empty( $logo ) ) {
				$this->data_website_type['logo'] = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_organization_logo_url', '' );
			}

			$option = get_option( 'nishiki_pro_meta_json_ld' );
			if ( isset( $option['address'] ) && 1 === $option['address'] ) {
				$this->address();
			}

			if ( isset( $option['contactpoint'] ) && 1 === $option['contactpoint'] ) {
				$this->contactpoint();
			}

			return $this->data_website_type;
		}

		/**
		 * Adderss.
		 */
		private function address() {
			$this->data_website_type['address'] = array(
				'@type' => 'PostalAddress',
			);

			$addresslocality = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_address_addresslocality', '' );
			if ( ! empty( $addresslocality ) ) {
				$this->data_website_type['address']['addresslocality'] = $addresslocality;
			}

			$postalcode = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_address_postalcode', '' );
			if ( ! empty( $postalcode ) ) {
				$this->data_website_type['address']['postalCode'] = $postalcode;
			}

			$addressregion = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_address_addressregion', '' );
			if ( ! empty( $addressregion ) ) {
				$this->data_website_type['address']['addressRegion'] = $addressregion;
			}

			$streetaddress = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_address_streetaddress', '' );
			if ( ! empty( $streetaddress ) ) {
				$this->data_website_type['address']['streetAddress'] = $streetaddress;
			}
		}

		/**
		 * ContactPoint.
		 *
		 * @link contactType and contactOption https://developers.google.com/search/docs/data-types/corporate-contact
		 */
		private function contactpoint() {
			$this->data_website_type['contactPoint'] = array(
				'@type' => 'ContactPoint',
			);

			$telephone = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_contactpoint_telephone', '' );
			if ( ! empty( $telephone ) ) {
				$this->data_website_type['contactPoint']['telephone'] = $telephone;
			}

			$contacttype = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_contactpoint_contacttype', '' );
			if ( ! empty( $contacttype ) ) {
				$this->data_website_type['contactPoint']['contactType'] = $contacttype;
			}

			$contactoption = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_contactpoint_contactoption', '' );
			if ( ! empty( $contactoption ) ) {
				$this->data_website_type['contactPoint']['contactOption'] = $contactoption;
			}

			$areaserved = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_contactpoint_areaserved', '' );
			if ( ! empty( $areaserved ) ) {
				$this->data_website_type['contactPoint']['areaServed'] = $areaserved;
			}
		}


		/**
		 * Social account.
		 *
		 * @link https://developers.google.com/search/docs/data-types/social-profile
		 */
		private function sameas() {
			$sameas_array = array();

			$nishiki_pro_social_button_type = array(
				'Twitter'    => 'https://twitter.com/',
				'Facebook'   => 'https://www.facebook.com/',
				'Instagram'  => 'https://www.instagram.com/',
				'YouTube'    => 'https://www.youtube.com/channel/',
				'Google+'    => 'https://plus.google.com/+',
				'Pinterest'  => 'https://www.pinterest.com/',
				'Linkdin'    => 'https://www.linkedin.com/',
				'Myspace'    => 'https://myspace.com/',
				'SoundCloud' => 'https://soundcloud.com/',
				'Tumblr'     => 'https://www.tumblr.com/',
			);

			foreach ( $nishiki_pro_social_button_type as $button => $value ) {
				if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_' . $button, '' ) ) {
					$sameas_array[] = $value . get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_' . $button, '' );
				}
			}

			return $sameas_array;
		}


		/**
		 * Post type.
		 *
		 * @link https://developers.google.com/search/docs/data-types/article
		 */
		public function post_type() {
			$logo_url       = '';
			$logo_width     = '';
			$logo_height    = '';
			$publisher_name = '';

			if ( has_post_thumbnail( get_the_ID() ) ) {
				$image_data   = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'large' );
				$image_url    = $image_data[0];
				$image_width  = $image_data[1];
				$image_height = $image_data[2];
			} else {
				$image_url = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_image', get_template_directory_uri() . '/assets/images/carp.jpg' );
				if ( ! empty( $image_url ) ) {
					$image_id     = attachment_url_to_postid( $image_url );
					$image_data   = wp_get_attachment_image_src( $image_id, 'large' );
					$image_width  = ! empty( $image_data[1] ) ? $image_data[1] : '';
					$image_height = ! empty( $image_data[2] ) ? $image_data[2] : '';
				} else {
					$image_url    = '';
					$image_width  = '';
					$image_height = '';
				}
			}

			if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_publisher_logo_url', '' ) ) {
				$logo_url  = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_publisher_logo_url', '' );
				$logo_id   = attachment_url_to_postid( $logo_url );
				$logo_data = wp_get_attachment_image_src( $logo_id, 'full' );

				if ( isset( $logo_data[1] ) ) {
					$logo_width = $logo_data[1];
				}

				if ( isset( $logo_data[2] ) ) {
					$logo_height = $logo_data[2];
				}
			}

			if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_organization_name', '' ) ) {
				$publisher_name = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_organization_name', '' );
			}

			$args = array(
				'type'            => get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_type', 'BlogPosting' ),
				'pub_date'        => get_the_date( 'c' ),
				'modify_date'     => get_the_modified_date( 'c' ),
				'title'           => get_the_title(),
				'id'              => esc_url( get_permalink() ),
				'site_name'       => get_bloginfo( 'name' ),
				'image_url'       => $image_url,
				'image_width'     => $image_width,
				'image_height'    => $image_height,
				'author_type'     => 'person',
				'author_name'     => get_the_author_meta( 'display_name' ),
				'publisher_type'  => 'Organization',
				'publisher_name'  => $publisher_name,
				'logo_url'        => $logo_url,
				'logo_url_width'  => $logo_width,
				'logo_url_height' => $logo_height,
			);

			$this->data_post_type = array(
				'@context'      => 'http://schema.org',
				'@type'         => $args['type'],
				'headline'      => $args['title'],
				'datePublished' => $args['pub_date'],
				'dateModified'  => $args['modify_date'],
			);

			$this->data_post_type['mainEntityOfPage'] = array(
				'@type' => 'WebPage',
				'@id'   => $args['id'],
			);

			if ( ! empty( $image_url ) ) {
				$this->data_post_type['image'] = array(
					'@type'  => 'ImageObject',
					'url'    => $args['image_url'],
					'width'  => $args['image_width'],
					'height' => $args['image_height'],
				);
			}

			$this->data_post_type['author'] = array(
				'@type' => $args['author_type'],
				'name'  => $args['author_name'],
			);

			$this->data_post_type['publisher'] = array(
				'@type' => $args['publisher_type'],
				'name'  => $args['publisher_name'],
			);

			if ( ! empty( $logo_url ) ) {
				$this->data_post_type['publisher']['logo'] = array(
					'@type'  => 'ImageObject',
					'url'    => $logo_url,
					'width'  => $logo_width,
					'height' => $logo_height,
				);
			}

			return $this->data_post_type;
		}

		/**
		 * 出力
		 */
		public function create() {
			$website      = $this->website();
			$website_type = $this->website_type();
			$post_type    = $this->post_type();

			$option = get_option( 'nishiki_pro_meta_json_ld' );

			/**
			 * Create JSON-LD Website
			 */
			if ( isset( $option['website'] ) && 1 === $option['website'] && ( is_home() || is_front_page() ) ) {
				if ( is_array( $website ) && ! empty( $website ) ) {
					echo "<script type='application/ld+json'>", wp_json_encode( $website ), '</script>', "\n";
				}
			}

			/**
			 * Create JSON-LD Post Type
			 */
			if ( isset( $option['post_type'] ) ) {
				if ( ! is_front_page() && ! is_home() && is_singular() && array_key_exists( get_post_type(), $option['post_type'] ) ) {
					if ( is_array( $post_type ) && ! empty( $post_type ) ) {
						echo "<script type='application/ld+json'>", wp_json_encode( $post_type ), '</script>', "\n";
					}
				}
			}

			/**
			 * Create JSON-LD Website type
			 */
			if ( isset( $option['website_type'] ) && ( is_home() || is_front_page() ) ) {
				if ( is_array( $website_type ) && ! empty( $website_type ) ) {
					echo "<script type='application/ld+json'>", wp_json_encode( $website_type ), '</script>', "\n";
				}
			}

		}


	}
}
