<?php
if ( ! class_exists( 'NISHIKI_PRO_META_OGP_FACEBOOK' ) ) {
	/**
	 * Create OGP Facebook.
	 */
	class NISHIKI_PRO_META_OGP_FACEBOOK extends NISHIKI_PRO_META_OGP_UTILITY {
		/**
		 * OGP Name.
		 *
		 * @var string
		 */
		private $ogp_name = 'facebook';

		/**
		 * Create OGP Facebook.
		 *
		 * @link https://developers.facebook.com/tools/debug/
		 */
		public function create() {
			$option = get_option( 'nishiki_pro_meta_ogp' );
			if ( ! isset( $option['active'] ) ) {
				return false;
			}

			if ( ! array_key_exists( $this->ogp_name, $option['active'] ) ) {
				return false;
			}

			$this->og( 'fb:app_id', get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_ogp_facebook_app_id', '' ) );
		}
	}
}
