<?php
if ( ! class_exists( 'NISHIKI_PRO_META_OGP_TWITTER' ) ) {
	/**
	 * Create OGP Twitter.
	 */
	class NISHIKI_PRO_META_OGP_TWITTER extends NISHIKI_PRO_META_OGP_UTILITY {
		/**
		 * OGP Name.
		 *
		 * @var string
		 */
		private $ogp_name = 'twitter';

		/**
		 * Create OGP Twitter Cards.
		 *
		 * @link https://dev.twitter.com/web/sign-in https://dev.twitter.com/ja/cards/overview
		 */
		public function create() {
			$option = get_option( 'nishiki_pro_meta_ogp' );
			if ( ! isset( $option['active'] ) ) {
				return false;
			}

			if ( ! array_key_exists( $this->ogp_name, $option['active'] ) ) {
				return false;
			}

			global $post;

			if ( is_singular() ) {
				$excerpt = apply_filters( NISHIKI_PRO_PREFIX_META . '_ogp_twitter_description', get_the_excerpt() );

				if ( is_front_page() ) {
					$title = apply_filters( NISHIKI_PRO_PREFIX_META . '_ogp_twitter_title', get_bloginfo( 'name' ) );

					if( ! has_excerpt() ){
						$excerpt = apply_filters( NISHIKI_PRO_PREFIX_META . '_ogp_twitter_description', get_bloginfo( 'description' ) );
					}

				} else {
					$singular_title = get_post_meta( $post->ID, '_nishiki_pro_meta_box_title_' . get_post_type(), true );
					if ( $singular_title ) {
						$og_title = $singular_title;
					} else {
						$og_title = get_the_title();
					}
					$title = apply_filters( NISHIKI_PRO_PREFIX_META . '_ogp_twitter_title', esc_html( $og_title ) );
				}

				if ( $this->is_custom_post_type() ) {
					$post_object = get_post( $post->ID );

					if ( post_type_supports( get_post_type(), 'excerpt' ) ) {
						$excerpt = get_the_excerpt();
					} else {
						$get_content = apply_filters( 'the_content', $post_object->post_content );
						$excerpt     = wp_trim_words( $get_content, 60, '...' );
					}
				} else {
					setup_postdata( $post );
				}

				$link = esc_url( get_permalink() );

				if ( has_post_thumbnail( $post->ID ) ) {
					$images    = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );
					$image_url = $images[0];
				} else {
					$image_url = apply_filters( NISHIKI_PRO_PREFIX_META . '_ogp_twitter_image', get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_ogp_image', '' ) );
				}
			} else {
				$title = apply_filters( NISHIKI_PRO_PREFIX_META . '_ogp_twitter_title', get_bloginfo( 'name' ) );

				$excerpt   = get_bloginfo( 'description' );
				$link      = '//' . getenv( 'HTTP_HOST' ) . getenv( 'REQUEST_URI' );
				$image_url = apply_filters( NISHIKI_PRO_PREFIX_META . '_ogp_twitter_image', get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_ogp_image', '' ) );
			}

			$this->twittercard( 'twitter:card', get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_ogp_twitter_card', 'summary' ) );
			$this->twittercard( 'twitter:site', get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_ogp_twitter_site', '' ) );
			$this->twittercard( 'twitter:creator', get_the_author_meta( 'nishiki_pro_user_profile_twitter' ) );
			$this->twittercard( 'twitter:url', $link );
			$this->twittercard( 'twitter:title', $title );
			$this->twittercard( 'twitter:description', $excerpt );
			$this->twittercard( 'twitter:image', $image_url );
		}

	}
}
