<?php
if ( ! class_exists( 'NISHIKI_PRO_META_OGP' ) ) {
	/**
	 * Create OGP.
	 */
	class NISHIKI_PRO_META_OGP extends NISHIKI_PRO_META_OGP_UTILITY {
		/**
		 * OGP Name.
		 *
		 * @var string
		 */
		private $ogp_name = 'ogp';

		/**
		 * Create OGP.
		 *
		 * @link https://developers.facebook.com/tools/debug/
		 */
		public function create() {
			$option = get_option( 'nishiki_pro_meta_ogp' );

			if ( ! isset( $option['active'] ) ) {
				return false;
			}

			if ( ! array_key_exists( $this->ogp_name, $option['active'] ) ) {
				return false;
			}

			global $post;
			$image_width  = '';
			$image_height = '';
			$section      = '';
			$tags_name    = array();

			if ( is_singular() && ! nishiki_pro_is_static_front_page() ) {
				$singular_title = get_post_meta( $post->ID, '_nishiki_pro_meta_box_title_' . get_post_type(), true );
				if ( $singular_title ) {
					$og_title = $singular_title;
				} else {
					$og_title = get_the_title();
				}
				$title = apply_filters( NISHIKI_PRO_PREFIX_META . '_ogp_title', esc_html( $og_title ) );
				setup_postdata( $post );
				$excerpt = get_the_excerpt();
				$link    = esc_url( get_permalink() );
				$type    = 'article';

				if ( has_post_thumbnail( $post->ID ) ) {
					$images       = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );
					$image_url    = $images[0];
					$image_width  = $images[1];
					$image_height = $images[2];
				} else {
					$image_url = apply_filters( NISHIKI_PRO_PREFIX_META . '_ogp_image', get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_ogp_image', '' ) );
				}
			} else {
				$title   = apply_filters( NISHIKI_PRO_PREFIX_META . '_ogp_title', get_bloginfo( 'name' ) );
				if( has_excerpt() ){
					$excerpt = apply_filters( NISHIKI_PRO_PREFIX_META . '_ogp_description', get_the_excerpt() );
				} else {
					$excerpt = apply_filters( NISHIKI_PRO_PREFIX_META . '_ogp_description', get_bloginfo( 'description' ) );
				}
				// $link = '//' . getenv( 'HTTP_HOST' ) . getenv( 'REQUEST_URI' );
				global $wp;
				$link      = home_url( $wp->request );
				$image_url = apply_filters( NISHIKI_PRO_PREFIX_META . '_ogp_image', get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_ogp_image', '' ) );
				$type      = 'website';
			}

			$this->og( 'og:type', $type );
			$this->og( 'og:title', $title );
			$this->og( 'og:description', $excerpt );
			$this->og( 'og:url', $link );
			$this->og( 'og:site_name', get_bloginfo( 'name' ) );
			$this->og( 'og:image', $image_url );
			if ( is_singular() && ! is_front_page() ) {
				$this->og( 'og:image:width', $image_width );
				$this->og( 'og:image:height', $image_height );
				$this->og( 'og:updated_time', get_the_modified_date( DATE_W3C ) );
				$this->og( 'article:published_time', get_the_date( DATE_W3C ) );
				$this->og( 'article:modified_time', get_the_modified_date( DATE_W3C ) );
				$this->og( 'article:author', get_the_author_meta( 'nishiki_pro_user_social_facebook' ) );
				// $this->og( 'article:publisher', get_the_author_meta( 'nishiki_pro_user_profile_facebook_page' ) );
				$this->og( 'article:publisher', get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_META . '_ogp_facebook_publisher', '' ) );

				$terms = get_the_category();
				if ( ! is_wp_error( $terms ) && ( is_array( $terms ) && array() !== $terms ) ) {
					$this->og( 'article:section', $terms[0]->name );
				}

				$tags = get_the_tags();
				if ( ! is_wp_error( $tags ) && ( is_array( $tags ) && array() !== $tags ) ) {
					foreach ( $tags as $tag ) {
						$this->og( 'article:tag', $tag->name );
					}
				}
			}
		}

	}
}
