<?php
if ( ! class_exists( 'NISHIKI_PRO_MULTIPLE_SEARCH_UTILITY_FORM' ) ) {
	/**
	 * 絞り込み検索（ユーティリティ フォーム作成）
	 */
	class NISHIKI_PRO_MULTIPLE_SEARCH_UTILITY_FORM {

		/**
		 * フォーム作成（チェックボックス一つ）
		 *
		 * @param string $title タイトル
		 * @param string $label ラベル
		 * @param string $page_name ページ名
		 * @return void
		 */
		public function create_form_multiple_search_checkbox( $title, $label, $page_name ) {
			$options    = get_option( $page_name );
			$label_name = $page_name . '_' . $label;

			if( isset( $options[ $title ] ) ){
				$title = $options[ $title ];
			} else {
				$title = '';
			}

			if ( isset( $options[ $label ] ) ) {
				$checked = ' checked="checked"';
			} else {
				$checked = '';
			}

			echo '<p><input type="checkbox" id="' . esc_attr( $label_name ) . '" name="' . esc_attr( $page_name ) . '[' . esc_attr( $label ) . ']" value="1"' . esc_attr( $checked ) . '><label for="' . esc_attr( $label_name ) . '">' . esc_html( $title ) . '</label></p>';

		}

		/**
		 * フォーム作成（テキスト）
		 *
		 * @param array $args 設定
		 * @return void
		 */
		public function create_form_multiple_search_text( $args = array() ) {
			$options = get_option( $args['page_name'] );

			$title       = ! empty( $args['title'] ) ? $args['title'] : '';
			$description = ! empty( $args['description'] ) ? $args['description'] : '';
			$placeholder = ! empty( $args['placeholder'] ) ? $args['placeholder'] : '';

			$label      = ! empty( $args['label'] ) ? $args['label'] : '';
			$label_name = $args['page_name'] . '_' . $args['label'];

			$page_name = $args['page_name'];

			if ( isset( $options[ $label ] ) ) {
				$data = $options[ $label ];
			} else {
				$data = '';
			}

			if ( ! empty( $title ) ) {
				echo '<p><label for="' . esc_attr( $label_name ) . '">' . esc_html( $title ) . '</label></p>';
			}
			echo '<p><input class="regular-text" placeholder="' . esc_attr( $placeholder ) . '" type="text" id="' . esc_attr( $label_name ) . '" name="' . esc_attr( $page_name ) . '[' . esc_attr( $label ) . ']" value="' . esc_attr( $data ) . '" /></p>';

			if ( ! empty( $description ) ) {
				echo '<p class="description">' . esc_html( $description ) . '</p>';
			}
		}

		/**
		 * フォーム作成（絞り込み検索）
		 *
		 * @param string $title タイトル
		 * @param string $label ラベル
		 * @param string $page_name ページ名
		 * @param string $taxonomy タクソノミー
		 * @return void
		 */
		public function create_form_multiple_search( $title, $label, $page_name, $taxonomy ) {
			$options = get_option( $page_name );

			// var_dump($options);
			// delete_option($page_name);

			if( isset( $options[ $title ] ) ){
				$title = $options[ $title ];
			} else {
				$title = '';
			}
			
			$args = array(
				'hide_empty' => false,
			);

			$taxonomy_data = get_taxonomy( $taxonomy );
			$terms         = get_terms( $taxonomy, $args );

			$display_checked = '';

			if ( ! empty( $options[ $taxonomy ]['display'] ) ) {
				$display_checked = ' checked="checked"';
			}

			if ( ! empty( $options[ $taxonomy ]['label'] ) ) {
				$taxonomy_label = $options[ $taxonomy ]['label'];
			} else {
				$taxonomy_label = $taxonomy_data->label;
			}

			if ( ! empty( $options[ $taxonomy ]['formInputType'] ) ) {
				$taxonomy_form_input_type = $options[ $taxonomy ]['formInputType'];
			} else {
				$taxonomy_form_input_type = 'checkbox';
			}

			echo '<p><input type="checkbox" id="taxonomy-' . esc_attr( $taxonomy ) . '" name="' . esc_attr( $page_name ) . '[' . esc_attr( $taxonomy ) . '][display]" value="1"' . esc_attr( $display_checked ) . '/><label for="taxonomy-' . esc_attr( $taxonomy ) . '">表示する</label></p>';

			// ラベルテキスト
			echo '<p><label for="taxonomy-' . esc_attr( $taxonomy ) . '">ラベル</label> <input type="text" id="taxonomy-' . esc_attr( $taxonomy ) . '" name="' . esc_attr( $page_name ) . '[' . esc_attr( $taxonomy ) . '][label]" value="' . esc_attr( $taxonomy_label ) . '" /></p>';

			// 表示タイプ
			$form_input_types = array(
				'checkbox' => 'チェックボックス',
				'radio' => 'ラジオボタン',
				'select' => 'セレクトボックス',
			);

			echo '<p><label for="taxonomy-form-input-type-' . esc_attr( $taxonomy ) . '">フォームの表示タイプ</label> ';
			echo '<select name="' . esc_attr( $page_name ) . '[' . esc_attr( $taxonomy ) . '][formInputType]">';
			foreach( $form_input_types as $key => $val ){
				$form_input_type_selected = '';

				if( $taxonomy_form_input_type == $key ){
					$form_input_type_selected = ' selected';
				}
				echo '<option value="' . $key . '"' . $form_input_type_selected . '>' . $val . '</option>';
			}
			echo '</select>';
			echo '</p>';

			if ( $terms ) {
				echo '<ul>';
				foreach ( $terms as $term ) {
					$term_checked = '';
					if ( isset( $options[ $taxonomy ]['terms'] ) ) {
						if ( array_key_exists( $term->term_id, $options[ $taxonomy ]['terms'] ) ) {
							$term_checked = ' checked="checked"';
						}
					}
					$label_name = $label . '_' . $taxonomy;

					echo '<li><input type="checkbox" id="term-' . esc_attr( $term->term_id ) . '" name="' . esc_attr( $page_name ) . '[' . esc_attr( $taxonomy ) . '][terms][' . absint( $term->term_id ) . ']" value="1"' . esc_attr( $term_checked ) . '><label for="term-' . esc_attr( $term->term_id ) . '">' . esc_html( $term->name ) . '(' . absint( $term->count ) . ')</label></li>';
				}
				echo '</ul>';
			}

		}
	}
}
