<?php
if ( ! class_exists( 'NISHIKI_PRO_SETUP' ) ) {
	/**
	 * セットアップ
	 */
	class NISHIKI_PRO_SETUP {

		/**
		 * Constructor.
		 */
		public function __construct() {
			// テーマ変更後に初期設定
			add_action( 'after_switch_theme', array( $this, 'initial_setting' ) );

			// テーマ変更後に実行
			add_action( 'admin_init', array( $this, 'theme_switch_redirect' ) );
		}

		/**
		 * テーマ変更後 初期設定
		 *
		 * @return void
		 */
		public function initial_setting() {

			// Profile
			if ( empty( get_option( 'nishiki_pro_general_profile' ) ) ) {
				update_option( 'nishiki_pro_general_profile', $this->profile_array );
			}

			// OGP
			if ( empty( get_option( 'nishiki_pro_meta_ogp' ) ) ) {
				update_option( 'nishiki_pro_meta_ogp', $this->ogp_array );
			}

			// JSON LD
			if ( empty( get_option( 'nishiki_pro_meta_json_ld' ) ) ) {
				update_option( 'nishiki_pro_meta_json_ld', $this->json_ld_array );
			}

			// Breadcrumbs
			if ( empty( get_option( 'nishiki_pro_general_breadcrumbs' ) ) ) {
				update_option( 'nishiki_pro_general_breadcrumbs', $this->breadcrumbs_array );
			}

			// Theme Activation
			set_transient( 'nishiki_pro_theme_activation_redirect', true, 30 );
		}

		/**
		 * Theme Switch Redirect
		 */
		public function theme_switch_redirect(){
			// フラグがなければ何もしない
			if ( ! get_transient( 'nishiki_pro_theme_activation_redirect' ) ) {
				return;
			}

			// すぐにフラグを削除（ループ防止）
			delete_transient( 'nishiki_pro_theme_activation_redirect' );

			// About Page Redirect
			if ( wp_safe_redirect( admin_url( 'themes.php?page=nishiki-pro-about' ) ) ){
				exit();
			}
		}

		/**
		 * Profile
		 *
		 * @var array
		 */
		public $profile_array = array(
			'enable' => 1,
		);

		/**
		 * OGP
		 *
		 * @var array
		 */
		public $ogp_array = array(
			'active' => array(
				'ogp'      => 1,
				'twitter'  => 1,
				'facebook' => 1,
			),
		);

		/**
		 * Schema.org（JSON LD）
		 *
		 * @var array
		 */
		public $json_ld_array = array(
			'website'      => 1,
			'website_type' => 1,
			'post_type'    => array(
				'post' => 1,
				'page' => 1,
			),
		);

		/**
		 * Breadcrumbs
		 *
		 * @var array
		 */
		public $breadcrumbs_array = array(
			'enable'    => 1,
			'display'   => array(
				'header' => 1,
			),
			'post_type' => array(
				'post' => 1,
				'page' => 1,
			),
			'archive'   => array(
				'category' => 1,
				'post_tag' => 1,
				'author'   => 1,
				'paged'    => 1,
				'year'     => 1,
				'month'    => 1,
				'day'      => 1,
			),
			'other'     => array(
				'404'    => 1,
				'search' => 1,
			),
		);

	}
}

$output = new NISHIKI_PRO_SETUP();
