<?php
if ( ! class_exists( 'NISHIKI_PRO_GENERAL_TOP' ) ) {
	/**
	 * Create Code.
	 */
	class NISHIKI_PRO_GENERAL_TOP extends NISHIKI_PRO_GENERAL_UTILITY {

		/**
		 * プレフィックス
		 *
		 * @var string
		 */
		private $prefix = '_top';

		/**
		 * Constructor.
		 */
		public function __construct() {
			// フォーム追加
			add_action( 'admin_init', array( $this, 'register' ), 20 );
		}

		/**
		 * フォームの設定(基本)
		 */
		public function register() {
			$page_name = $this->plugin_name . $this->prefix;

			register_setting(
				$page_name,
				$page_name,
				array( $this, 'sanitize' )
			);

			add_settings_section(
				$page_name,
				'',
				array( $this, 'nishiki_pro_general_cb' ),
				$page_name
			);

			add_settings_field(
				'title',
				__( 'タイトル', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_text_cb' ),
				$page_name,
				$page_name,
				array(
					'title'       => '',
					'label'       => 'title',
					'page_name'   => $page_name,
					'description' => 'トップページのタイトルを変更します。',
				)
			);

			add_settings_field(
				'description',
				__( 'ディスクリプション', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_textarea_cb' ),
				$page_name,
				$page_name,
				array(
					'title'       => '',
					'label'       => 'description',
					'page_name'   => $page_name,
					'description' => 'トップページのディスクリプションを変更します。サイトの特徴をわかりやすく書きましょう。',
				)
			);
		}


		/**
		 * 入力値のサニタイズ
		 *
		 * @param array $input Contains all settings fields as array keys
		 */
		public function sanitize( $input ) {
			$new_input = array();

			if ( isset( $input['title'] ) ) {
				$new_input['title'] = stripslashes( $input['title'] );
			}

			if ( isset( $input['description'] ) ) {
				$new_input['description'] = stripslashes( $input['description'] );
			}

			// wp_die(var_dump($new_input));
			return $new_input;
		}


	}
}

$output = new NISHIKI_PRO_GENERAL_TOP();
