<?php
if ( ! class_exists( 'NISHIKI_PRO_GENERAL_UTILITY' ) ) {
	/**
	 * 基本設定
	 */
	class NISHIKI_PRO_GENERAL_UTILITY extends NISHIKI_PRO_GENERAL_UTILITY_FORM {
		/**
		 * Holds plugin name
		 *
		 * @var 0.0.1
		 */
		public $options;

		/**
		 * 名前
		 *
		 * @var string
		 */
		public $plugin_name = 'nishiki_pro_general';

		/**
		 * フォームの出力（全ページ）
		 */
		public function nishiki_pro_general_cb() {
			$nonce = wp_create_nonce( $this->plugin_name );
			echo '<input type="hidden" name="' . esc_attr( $this->plugin_name ) . '" value="' . esc_attr( $nonce ) . '" />';
		}

		/**
		 * フォーム作成（単数チェック）
		 *
		 * @param array $args 設定
		 * @return void
		 */
		public function nishiki_pro_checkbox_cb( $args ) {

			$this->create_form_checkbox( $args['title'], $args['label'], $args['page_name'] );

			if ( ! empty( $args['description'] ) ) {
				echo '<p class="description">' . esc_html( $args['description'] ) . '</p>';
			}
		}

		/**
		 * フォーム作成（複数チェック）
		 *
		 * @param array $args 設定
		 * @return void
		 */
		public function nishiki_pro_checkbox_multiple_cb( $args ) {

			$this->create_form_checkbox_multiple( $args['title'], $args['label'], $args['page_name'], $args['script'], $args['display_key'] );

			if ( ! empty( $args['description'] ) ) {
				echo '<p class="description">' . esc_html( $args['description'] ) . '</p>';
			}
		}

		/**
		 * フォーム作成（テキスト）
		 *
		 * @param array $args 設定
		 * @return void
		 */
		public function nishiki_pro_text_cb( $args ) {
			$this->create_form_text( $args );
		}

		/**
		 * フォーム作成（テキストエリア）
		 *
		 * @param array $args 設定
		 * @return void
		 */
		public function nishiki_pro_textarea_cb( $args ) {
			$this->create_form_textarea( $args );
		}

		/**
		 * フォーム作成（ラジオボタン）
		 *
		 * @param array $args 設定
		 * @return void
		 */
		public function nishiki_pro_radio_button_cb( $args ) {
			$this->create_form_radio_button( $args );
		}

		/**
		 * フォーム作成（セレクトボックス）
		 *
		 * @param array $args 設定
		 * @return void
		 */
		public function nishiki_pro_selectbox_cb( $args ) {
			$this->create_form_selectbox( $args );
		}

		/**
		 * カスタム投稿タイプかどうかチェック
		 *
		 * @return boolean
		 */
		public function is_custom_post_type() {
			$post_obj = get_post_type_object( get_post_type() );
			if ( ! empty( $post_obj ) && false === $post_obj->_builtin ) {
				return $post_obj;
			} else {
				return false;
			}
		}
	}
}
