<?php
if ( ! class_exists( 'NISHIKI_PRO_WALKER_GLOBAL_NAV' ) ) {
	/**
	 * Create Code.
	 */
	class NISHIKI_PRO_WALKER_GLOBAL_NAV extends Walker_Nav_Menu {
		/**
		 * What the class handles.
		 *
		 * @since 3.0.0
		 * @var string
		 *
		 * @see Walker::$tree_type
		 */
		public $tree_type = array( 'post_type', 'taxonomy', 'custom' );

		/**
		 * Database fields to use.
		 *
		 * @since 3.0.0
		 * @todo Decouple this.
		 * @var array
		 *
		 * @see Walker::$db_fields
		 */
		public $db_fields = array(
			'parent' => 'menu_item_parent',
			'id'     => 'db_id',
		);

		/**
		 * Starts the element output.
		 *
		 * @since 3.0.0
		 * @since 4.4.0 The {@see 'nav_menu_item_args'} filter was added.
		 *
		 * @see Walker::start_el()
		 *
		 * @param string   $output Used to append additional content (passed by reference).
		 * @param WP_Post  $item   Menu item data object.
		 * @param int      $depth  Depth of menu item. Used for padding.
		 * @param stdClass $args   An object of wp_nav_menu() arguments.
		 * @param int      $id     Current item ID.
		 */
		public function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
			if ( isset( $args->item_spacing ) && 'discard' === $args->item_spacing ) {
				$t = '';
				$n = '';
			} else {
				$t = "\t";
				$n = "\n";
			}
			$indent = ( $depth ) ? str_repeat( $t, $depth ) : '';

			$classes   = empty( $item->classes ) ? array() : (array) $item->classes;
			$classes[] = 'menu-item-' . $item->ID;

			$overlay = ! empty( $args->overlay ) ? true : false;

			/**
			 * Filters the arguments for a single nav menu item.
			 *
			 * @since 4.4.0
			 *
			 * @param stdClass $args  An object of wp_nav_menu() arguments.
			 * @param WP_Post  $item  Menu item data object.
			 * @param int      $depth Depth of menu item. Used for padding.
			 */
			$args = apply_filters( 'nav_menu_item_args', $args, $item, $depth );

			/**
			 * Filters the CSS class(es) applied to a menu item's list item element.
			 *
			 * @since 3.0.0
			 * @since 4.1.0 The `$depth` parameter was added.
			 *
			 * @param array    $classes The CSS classes that are applied to the menu item's `<li>` element.
			 * @param WP_Post  $item    The current menu item.
			 * @param stdClass $args    An object of wp_nav_menu() arguments.
			 * @param int      $depth   Depth of menu item. Used for padding.
			 */

			$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args, $depth ) );
			$class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';

			/**
			 * Filters the ID applied to a menu item's list item element.
			 *
			 * @since 3.0.1
			 * @since 4.1.0 The `$depth` parameter was added.
			 *
			 * @param string   $menu_id The ID that is applied to the menu item's `<li>` element.
			 * @param WP_Post  $item    The current menu item.
			 * @param stdClass $args    An object of wp_nav_menu() arguments.
			 * @param int      $depth   Depth of menu item. Used for padding.
			 */
			$id = apply_filters( 'nav_menu_item_id', 'menu-item-' . $item->ID, $item, $args, $depth );
			$id = $id ? ' id="' . esc_attr( $id ) . '"' : '';

			// $collapse = ( $item->object === 'menu' && get_theme_mod( 'setting_header_menu_collapse' ) === true ) ? ' collapse' : '';

			// $class = $item->object ? ' class="' . esc_attr( $item->object ) . esc_attr( $collapse ) . '"' : '';

			$output .= $indent . '<li' . $id . $class_names . '>';

			$atts           = array();
			$atts['title']  = ! empty( $item->attr_title ) ? $item->attr_title : '';
			$atts['target'] = ! empty( $item->target ) ? $item->target : '';
			$atts['rel']    = ! empty( $item->xfn ) ? $item->xfn : '';
			$atts['href']   = ! empty( $item->url ) ? $item->url : '';

			/**
			 * Filters the HTML attributes applied to a menu item's anchor element.
			 *
			 * @since 3.6.0
			 * @since 4.1.0 The `$depth` parameter was added.
			 *
			 * @param array $atts {
			 *     The HTML attributes applied to the menu item's `<a>` element, empty strings are ignored.
			 *
			 *     @type string $title  Title attribute.
			 *     @type string $target Target attribute.
			 *     @type string $rel    The rel attribute.
			 *     @type string $href   The href attribute.
			 * }
			 * @param WP_Post  $item  The current menu item.
			 * @param stdClass $args  An object of wp_nav_menu() arguments.
			 * @param int      $depth Depth of menu item. Used for padding.
			 */
			$atts = apply_filters( 'nav_menu_link_attributes', $atts, $item, $args, $depth );

			$attributes = '';
			foreach ( $atts as $attr => $value ) {
				if ( ! empty( $value ) ) {
					$value       = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
					$attributes .= ' ' . $attr . '="' . $value . '"';
				}
			}

			/** This filter is documented in wp-includes/post-template.php */
			$title = apply_filters( 'the_title', $item->title, $item->ID );

			/**
			 * Filters a menu item's title.
			 *
			 * @since 4.4.0
			 *
			 * @param string   $title The menu item's title.
			 * @param WP_Post  $item  The current menu item.
			 * @param stdClass $args  An object of wp_nav_menu() arguments.
			 * @param int      $depth Depth of menu item. Used for padding.
			 */
			$title = '<span class="title">' . apply_filters( 'nav_menu_item_title', $title, $item, $args, $depth ) . '</span>';

			if ( ! empty( $item->description ) ) {
				$sub = '<small>' . $item->description . '</small>';
			} else {
				$sub = '';
			}

			// var_dump($item->classes);
			if ( is_array( $item->classes ) && array_search( 'menu-item-has-children', $item->classes, true ) ) {
				$arrow = '<span class="arrow"><i class="icomoon icon-arrow-down"></i></span>';
			} else {
				$arrow = '';
			}

			if ( is_array( $item->classes ) && array_search( 'menu-item-has-children', $item->classes, true ) ) {
				$detail = '<div class="menu-item-detail"><div>' . $title . $sub . '</div></div>';
			} else {
				$detail = '<div class="menu-item-detail">' . $title . $sub . '</div>';
			}

			$data_depth = ' data-depth="' . $depth . '"';

			$item_output = '';

			$custom_attribute = ' ' . get_post_meta( $item->ID, '_nishiki_pro_custom_attr', true );

			if ( ! empty( $args->before ) ) {
				$item_output .= $args->before;
			}

			$global_nav_open_type = apply_filters( 'nishiki_pro_header_global_nav_open_type', get_theme_mod( 'setting_header_global_nav_open_type', 'hover' ) );

			if ( 'click' === $global_nav_open_type || true === $overlay ) {
				$item_output .= '<a' . $attributes . $data_depth . $custom_attribute . '>';
				if ( ! empty( $args->link_before ) && ! empty( $args->link_after ) ) {
					$item_output .= $args->link_before . $detail . $arrow . $args->link_after;
				} else {
					$item_output .= $detail . $arrow;
				}
				$item_output .= '</a>';
			} elseif ( 'hover' === $global_nav_open_type ) {
				$item_output .= '<a' . $attributes . $data_depth . $custom_attribute . '>';
				if ( ! empty( $args->link_before ) && ! empty( $args->link_after ) ) {
					$item_output .= $args->link_before . $detail . $args->link_after;
				} else {
					$item_output .= $detail;
				}
				$item_output .= '</a>' . $arrow;
			}

			if ( ! empty( $args->after ) ) {
				$item_output .= $args->after;
			}

			/**
			 * Filters a menu item's starting output.
			 *
			 * The menu item's starting output only includes `$args->before`, the opening `<a>`,
			 * the menu item's title, the closing `</a>`, and `$args->after`. Currently, there is
			 * no filter for modifying the opening and closing `<li>` for a menu item.
			 *
			 * @since 3.0.0
			 *
			 * @param string   $item_output The menu item's starting HTML output.
			 * @param WP_Post  $item        Menu item data object.
			 * @param int      $depth       Depth of menu item. Used for padding.
			 * @param stdClass $args        An object of wp_nav_menu() arguments.
			 */
			$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
		}

	}
}

$output = new NISHIKI_PRO_WALKER_GLOBAL_NAV();
