<?php
require_once 'button/init.php';
require_once 'heading/init.php';
require_once 'tag/init.php';

/**
 * Add CSS
 *
 * @return $output
 */
function nishiki_pro_css() {
	$output = '';

	/*****************
	 * Profile
	 */

	$nishiki_pro_user_profile_options = get_option( 'nishiki_pro_general_profile' );
	if ( ! empty( $nishiki_pro_user_profile_options ) ) {
		$output .= '
			#nishiki-pro-user-profile-wrapper a{display:inline-block;margin: 0 0.5rem 0.5rem;}
			#nishiki-pro-user-profile-wrapper i{font-size:1.5rem;}
		';
	}

	/*****************
	 * Breadcrumbs
	 */

	$nishiki_pro_breadcrumbs = get_option( 'nishiki_pro_general_breadcrumbs' );
	if ( ! empty( $nishiki_pro_breadcrumbs['enable'] ) ) {
		$page_name = 'nishiki_pro_general_breadcrumbs';
		$options   = get_option( $page_name );
		$separator = apply_filters( 'nishiki_pro_breadcrumbs_separator', '/' );

		$output .= "
			.nishiki-pro-breadcrumbs{font-size:0.85rem;padding-top: 0.8rem;padding-bottom:0.8rem;list-style-type: none;}
			.nishiki-pro-breadcrumbs .container{white-space: nowrap;overflow: hidden;text-overflow: ellipsis;padding-left:0;}
			.nishiki-pro-breadcrumbs li{display: inline;}
			.nishiki-pro-breadcrumbs li:not(:first-child)::before{font-family:'icomoon'; content:'{$separator}';margin-left: 0.3rem;margin-right: 0.3rem;}
		";
	}

	$breadcrumbs_background_color = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_BREADCRUMBS . '_background_color', '' ) );

	// Background Color
	if ( ! empty( $breadcrumbs_background_color ) ) {
		$output .= "
			.nishiki-pro-breadcrumbs{background-color:{$breadcrumbs_background_color};}
		";
	}

	$breadcrumbs_text_color = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_BREADCRUMBS . '_text_color', '#222222' ) );

	// Text Color
	if ( ! empty( $breadcrumbs_text_color ) ) {
		$output .= "
			.nishiki-pro-breadcrumbs{color:{$breadcrumbs_text_color};}
		";
	}

	// Text Link Color
	$breadcrumbs_link_color = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_BREADCRUMBS . '_link_color', '#0a88cc' ) );

	if ( ! empty( $breadcrumbs_link_color ) ) {
		$output .= "
			.nishiki-pro-breadcrumbs a{color:{$breadcrumbs_link_color};}
		";
	}

	// Text Link Hover Color
	$breadcrumbs_link_hover_color = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_BREADCRUMBS . '_link_hover_color', '#0044a3' ) );

	if ( ! empty( $breadcrumbs_link_hover_color ) ) {
		$output .= "
			.nishiki-pro-breadcrumbs a:hover{color:{$breadcrumbs_link_hover_color};}
		";
	}

	/*****************
	 * Social Button
	 */

	if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_css', true ) ) {
		$output .= '
			#nishiki-pro-social-button-wrapper > div a{display: inline-block;margin:1.2rem 0.7rem;line-height: 0;}
			#nishiki-pro-social-button-wrapper > div a i{font-size:1.2rem;vertical-align: middle;letter-spacing: 0;}
		';

		// Text Color
		$nishiki_pro_social_text_color = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_text_color', '#fff' ) );
		$output                       .= "
		#nishiki-pro-social-button-wrapper{color:{$nishiki_pro_social_text_color};}
		";

		// Background Color
		$nishiki_pro_social_background_color = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_background_color', '#222222' ) );
		$output                             .= "
		#nishiki-pro-social-button-wrapper{background:{$nishiki_pro_social_background_color};}
		";

	}

	/*****************
	 * Footer Nav
	 */

	// Background Color
	$footer_nav_background_color       = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_nav_background_color', '#f7f7f7' ) );
	$footer_nav_background_hover_color = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_nav_background_hover_color', '#eeeeee' ) );

	// Text Color
	$footer_nav_text_color       = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_nav_text_color', '#444444' ) );
	$footer_nav_text_hover_color = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_nav_text_hover_color', '#222222' ) );

	$output .= "
			#footer-nav{background-color:{$footer_nav_background_color};}
			#footer-nav a,#footer-nav span{color:{$footer_nav_text_color};}
			#footer-nav a:hover,#footer-nav span:hover{background-color:{$footer_nav_background_hover_color};color:{$footer_nav_text_hover_color};}
		";

	/*****************
	 * TOC
	 */

	// TOC Inside Article
	if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_display', true ) || get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_display', true ) ) {
		$toc_text_color       = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_text_color', '#444444' ) );
		$toc_text_hover_color = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_text_hover_color', '#222222' ) );
		$toc_background_color = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_background_color', '#fafafa' ) );

		$output .= "
			article .entry-content .nishiki-pro-toc{background-color:{$toc_background_color};}
			article .entry-content .nishiki-pro-toc,article .entry-content .nishiki-pro-toc a{color:{$toc_text_color};}
			article .entry-content .nishiki-pro-toc a:hover{color:{$toc_text_hover_color};}
			article .entry-content .nishiki-pro-toc label .slider{border: 1px solid {$toc_text_color};}
			article .entry-content .nishiki-pro-toc label .slider:before{background-color:{$toc_text_color};}
			article .entry-content .nishiki-pro-toc input:checked + label .slider{background-color:{$toc_text_color};}
			article .entry-content .nishiki-pro-toc input:checked + label .slider:before{background-color:{$toc_background_color};}
		";

	}

	// TOC Fixed Nav
	if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_display', true ) ) {
		$toc_fixed_text_color       = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_text_color', '#ffffff' ) );
		$toc_fixed_background_color = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_background_color', '#222222' ) );

		$output .= "
			#toc-fixed-nav{background-color:{$toc_fixed_background_color}; color:{$toc_fixed_text_color};}
		";
	}

	/*****************
	 * Campaign Link
	 */

	// Background Color
	$campaign_background_color_01 = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_background_color_01', '#8b65a3' );
	$campaign_background_color_02 = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_background_color_02', '#a6a3ba' );
	$campaign_background_color_03 = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_background_color_03' );

	// Text Color
	$campaign_text_color              = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text_color', '#ffffff' );
	$campaign_text_hover_color        = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text_hover_color', '#eeeeee' );
	$campaign_button_text_color       = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_text_color', '#222222' );
	$campaign_button_text_hover_color = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_text_hover_color', '#444444' );

	// Text Animation
	$campaign_text_typewriter = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_animation_text_typewriter', false );

	if ( $campaign_text_typewriter && ! empty( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text' ) ) ) {
		$campaign_text_num = absint( mb_strlen( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text' ) ) );

		$output .= "
			.nishiki-pro-campaign .campaign-text.effect-text-typewriter p{animation: animate-campaign-typewriter 1s steps({$campaign_text_num}, end);animation-delay: 2s;animation-fill-mode: forwards;}
			@keyframes animate-campaign-typewriter{
				from{width: 0;}
				to{width: 100%;}
			}
		";
	}

	// Button Color
	$campaign_button_color       = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_color', '#ffffff' );
	$campaign_button_hover_color = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_hover_color', '#eeeeee' );

	// Button radius
	$campaign_button_radius = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_radius', '4' );

	$output .= "
		.nishiki-pro-campaign{background-color:{$campaign_background_color_01};}
		.nishiki-pro-campaign .campaign-text{color:{$campaign_text_color};}	
		.nishiki-pro-campaign .campaign-text a:hover{color:{$campaign_text_hover_color};}	
		.nishiki-pro-campaign .campaign-button{color:{$campaign_button_text_color};}
		.nishiki-pro-campaign .campaign-button a{background-color:{$campaign_button_color};border-radius:{$campaign_button_radius}px;}
		.nishiki-pro-campaign .campaign-button a:hover{color:{$campaign_button_text_hover_color};background-color:{$campaign_button_hover_color};}
		.nishiki-pro-campaign .campaign-text a,.nishiki-pro-campaign .campaign-button a{color:inherit;}
		";

	$campaign_background_before = "
		.nishiki-pro-campaign{background-color:{$campaign_background_color_01};
	";

	// Campaign Background Type
	$campaign_background_type = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_background_type', 'dot-box' );
	$campaign_background      = '';

	if ( $campaign_background_type ) {
		switch ( $campaign_background_type ) {
			case 'single-color':
				$campaign_background = '';
				break;
			case 'dot':
				$color               = rawurlencode( $campaign_background_color_02 );
				$campaign_background = "
					background-image: url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='4' height='4' viewBox='0 0 4 4'%3E%3Cpath fill='{$color}' fill-opacity='1' d='M1 3h1v1H1V3zm2-2h1v1H3V1z'%3E%3C/path%3E%3C/svg%3E\");
				";
				break;
			case 'polka-dot':
				if ( ! empty( $campaign_background_color_03 ) ) {
					$color = $campaign_background_color_03;
				} else {
					$color = '#fff';
				}
				$campaign_background = "
					{$campaign_background_color_02};
					background-image: radial-gradient({$color} 10%, transparent 20%), radial-gradient({$color} 10%, transparent 20%);
					background-size: 16px 16px;
					background-position: 0 0, 8px 8px;
				";
				break;
			case 'stripe':
				$color               = rawurlencode( $campaign_background_color_02 );
				$campaign_background = "
					{$campaign_background_color_03};
					background-image: url(\"data:image/svg+xml,%3Csvg width='20' height='20' viewBox='0 0 20 20' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='{$color}' fill-opacity='1' fill-rule='evenodd'%3E%3Cpath d='M0 20L20 0H10L0 10M20 20V10L10 20'/%3E%3C/g%3E%3C/svg%3E\");
				";
				break;
			case 'check':
				$color               = rawurlencode( $campaign_background_color_02 );
				$campaign_background = "
					{$campaign_background_color_03};
					background-image: url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8' viewBox='0 0 8 8'%3E%3Cg fill='{$color}' fill-opacity='0.5'%3E%3Cpath fill-rule='evenodd' d='M0 0h4v4H0V0zm4 4h4v4H4V4z'/%3E%3C/g%3E%3C/svg%3E\");
				";
				break;
		}
	}

	$campaign_background_after = '}';

	$output .= $campaign_background_before . $campaign_background . $campaign_background_after;

	/*****************
	 * Design
	 */

	$output .= nishiki_pro_css_button();
	$output .= nishiki_pro_css_heading();
	$output .= nishiki_pro_css_tag();

	/*****************
	 * Color Palette
	 */

	$color_palette = get_option( 'nishiki_pro_block_editor_colors' );

	if ( ! empty( $color_palette ) ) {
		foreach ( $color_palette as $color ) {
			$output .= "
			:root .has-{$color['slug']}-background-color,
			:root .has-{$color['slug']}-background-color:hover{
				background-color:{$color['color']};
			}
			:root .has-{$color['slug']}-color,
			:root .has-{$color['slug']}-color:hover{
				color:{$color['color']};
			}
			";
		}
	}

	$main_color_01 = NISHIKI_PRO_MAIN_COLOR_01;

	if ( $main_color_01 ) {
		$output .= "
		:root .has-{$main_color_01['slug']}-background-color,
		:root .has-{$main_color_01['slug']}-background-color:hover{
			background-color:{$main_color_01['color']};
		}
		:root .has-{$main_color_01['slug']}-color,
		:root .has-{$main_color_01['slug']}-color:hover{
			color:{$main_color_01['color']};
		}
		";
	}

	$main_color_02 = NISHIKI_PRO_MAIN_COLOR_02;

	if ( $main_color_02 ) {
		$output .= "
		:root .has-{$main_color_02['slug']}-background-color,
		:root .has-{$main_color_02['slug']}-background-color:hover{
			background-color:{$main_color_02['color']};
		}
		:root .has-{$main_color_02['slug']}-color,
		:root .has-{$main_color_02['slug']}-color:hover{
			color:{$main_color_02['color']};
		}
		";
	}

	$accent_color_01 = NISHIKI_PRO_ACCENT_COLOR_01;

	if ( $accent_color_01 ) {
		$output .= "
		:root .has-{$accent_color_01['slug']}-background-color,
		:root .has-{$accent_color_01['slug']}-background-color:hover{
			background-color:{$accent_color_01['color']};
		}
		:root .has-{$accent_color_01['slug']}-color,
		:root .has-{$accent_color_01['slug']}-color:hover{
			color:{$accent_color_01['color']};
		}
		";
	}

	$accent_color_02 = NISHIKI_PRO_ACCENT_COLOR_02;

	if ( $accent_color_02 ) {
		$output .= "
		:root .has-{$accent_color_02['slug']}-background-color,
		:root .has-{$accent_color_02['slug']}-background-color:hover{
			background-color:{$accent_color_02['color']};
		}
		:root .has-{$accent_color_02['slug']}-color,
		:root .has-{$accent_color_02['slug']}-color:hover{
			color:{$accent_color_02['color']};
		}
		";
	}

	// Output
	if ( '' === $output ) {
		return false;
	}
	$str    = array( "\t", "\r\n", "\r", "\n" );
	$output = str_replace( $str, '', $output );

	return $output;
}

