<?php
if ( ! function_exists( 'nishiki_pro_login_customizer' ) ) {
	add_action( 'customize_register', 'nishiki_pro_login_customizer' );
	/**
	 * カスタマイザーの設定
	 *
	 * @param instance $wp_customize インスタンス
	 * @return void
	 */
	function nishiki_pro_login_customizer( $wp_customize ) {

		// Section
		$wp_customize->add_section(
			'section_' . NISHIKI_PRO_PREFIX_LOGIN,
			array(
				'title'    => __( 'Login Page', 'nishiki_pro' ),
				'priority' => 600,
				'panel'    => 'panel_' . NISHIKI_PRO_PREFIX,
			)
		);

		// Heading
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_LOGIN . '_logo_header',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_LOGIN . '_logo_header',
				array(
					'label'    => '<p class="nishiki-pro-customizer-heading">ロゴ</p>',
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_LOGIN,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_LOGIN . '_logo_header',
				)
			)
		);

		// Logo Image
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_LOGIN . '_logo_image',
			array(
				'default'           => '',
				'sanitize_callback' => 'absint',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Media_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_LOGIN . '_logo_image',
				array(
					'label'       => __( 'Upload an Image', 'nishiki-pro' ),
					'description' => __( 'ログイン画面のロゴ画像を変更します。', 'nishiki-pro' ),
					'section'     => 'section_' . NISHIKI_PRO_PREFIX_LOGIN,
					'settings'    => 'setting_' . NISHIKI_PRO_PREFIX_LOGIN . '_logo_image',
					'mime_type'   => 'image',
				)
			)
		);

		// Heading
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_LOGIN . '_color',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_LOGIN . '_color',
				array(
					'label'    => '<p class="nishiki-pro-customizer-heading">カラー</p>',
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_LOGIN,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_LOGIN . '_color',
				)
			)
		);

		// Background color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_LOGIN . '_background_color',
			array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_LOGIN . '_background_color',
				array(
					'label'    => __( 'Background Color', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_LOGIN,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_LOGIN . '_background_color',
				)
			)
		);

		// Text color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_LOGIN . '_text_color',
			array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_LOGIN . '_text_color',
				array(
					'label'    => __( 'Text Color', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_LOGIN,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_LOGIN . '_text_color',
				)
			)
		);

	}
}
