<?php
if ( ! function_exists( 'nishiki_pro_meta_json_ld_customizer' ) ) {
	add_action( 'customize_register', 'nishiki_pro_meta_json_ld_customizer' );
	/**
	 * カスタマイザーの設定
	 *
	 * @param instance $wp_customize インスタンス
	 * @return void
	 */
	function nishiki_pro_meta_json_ld_customizer( $wp_customize ) {

		// Section
		$wp_customize->add_section(
			'section_' . NISHIKI_PRO_PREFIX_META . '_json_ld',
			array(
				'title'    => __( 'Schema.org（構造化データ）', 'nishiki_pro' ),
				'priority' => 500,
				'panel'    => 'panel_' . NISHIKI_PRO_PREFIX,
			)
		);

		// Json ld

		// Display Header
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_header',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_META . '_json_ld_header',
				array(
					'label'    => '<p><a class="nishiki-pro-customizer-button" href="' . esc_url( admin_url( 'admin.php?page=nishiki-pro-meta-json-ld.php' ) ) . '">→表示設定はこちら</a></p>',
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_META . '_json_ld',
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_header',
				)
			)
		);

		// image
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_image',
			array(
				'default'           => '',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'nishiki_pro_sanitize_image',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Image_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_META . '_json_ld_image',
				array(
					'label'       => __( 'デフォルト画像', 'nishiki_pro' ),
					'description' => 'ページにアイキャッチ画像が設定されていない場合の画像を指定します',
					'section'     => 'section_' . NISHIKI_PRO_PREFIX_META . '_json_ld',
					'settings'    => 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_image',
					'priority'    => 2000,
				)
			)
		);

		// publisher.logo.url
		// image
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_publisher_logo_url',
			array(
				'default'           => '',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'nishiki_pro_sanitize_image',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Image_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_META . '_json_ld_publisher_logo_url',
				array(
					'label'       => __( 'ロゴ画像（記事用）', 'nishiki_pro' ),
					'description' => '横幅600×縦幅60px（推奨）',
					'section'     => 'section_' . NISHIKI_PRO_PREFIX_META . '_json_ld',
					'settings'    => 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_publisher_logo_url',
					'priority'    => 3000,
				)
			)
		);

		// @type
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_type',
			array(
				'default'           => 'BlogPosting',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'nishiki_pro_sanitize_choices_meta_json_ld_type',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_META . '_json_ld_type',
			array(
				'label'    => __( '投稿するページのタイプ', 'nishiki_pro' ),
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_META . '_json_ld',
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_type',
				'priority' => 7010,
				'type'     => 'select',
				'choices'  => array(
					'BlogPosting' => __( 'ブログなど（BlogPosting）', 'nishiki_pro' ),
					'NewsArticle' => __( 'ニュース記事など（NewsArticle）', 'nishiki_pro' ),
				),
			)
		);

		// Website type
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_website_type',
			array(
				'default'           => '',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'nishiki_pro_sanitize_choices_meta_json_ld_website_type',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_META . '_json_ld_website_type',
			array(
				'label'    => __( 'ウェブサイトのタイプ', 'nishiki_pro' ),
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_META . '_json_ld',
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_website_type',
				'priority' => 7020,
				'type'     => 'select',
				'choices'  => array(
					''             => __( '未設定', 'nishiki_pro' ),
					'Organization' => __( '法人など組織のウェブサイト（Organization）', 'nishiki_pro' ),
					'Person'       => __( '個人のウェブサイト（Person）', 'nishiki_pro' ),
				),
			)
		);

		// Person name
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_person_name',
			array(
				'default'           => '',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_META . '_json_ld_person_name',
			array(
				'label'    => __( '個人名', 'nishiki_pro' ),
				'type'     => 'text',
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_META . '_json_ld',
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_person_name',
				'priority' => 7030,
			)
		);

		// Organization name
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_organization_name',
			array(
				'default'           => '',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_META . '_json_ld_organization_name',
			array(
				'label'    => __( '組織名', 'nishiki_pro' ),
				'type'     => 'text',
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_META . '_json_ld',
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_organization_name',
				'priority' => 7040,
			)
		);

		// publisher.logo.url
		// image
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_organization_logo_url',
			array(
				'default'           => '',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'nishiki_pro_sanitize_image',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Image_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_META . '_json_ld_organization_logo_url',
				array(
					'label'       => __( 'ロゴ画像（組織用）', 'nishiki_pro' ),
					'description' => '横幅112×縦幅112px 以上',
					'section'     => 'section_' . NISHIKI_PRO_PREFIX_META . '_json_ld',
					'settings'    => 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_organization_logo_url',
					'priority'    => 7050,
				)
			)
		);

		// Address postalCode
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_address_postalcode',
			array(
				'default'           => '',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_META . '_json_ld_address_postalcode',
			array(
				'label'    => __( '郵便番号', 'nishiki_pro' ),
				'type'     => 'text',
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_META . '_json_ld',
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_address_postalcode',
				'priority' => 7060,
			)
		);

		// Address addressRegion
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_address_addressregion',
			array(
				'default'           => '',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_META . '_json_ld_address_addressregion',
			array(
				'label'    => __( '都道府県名', 'nishiki_pro' ),
				'type'     => 'text',
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_META . '_json_ld',
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_address_addressregion',
				'priority' => 7070,
			)
		);

		// Address addressLocality
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_address_addresslocality',
			array(
				'default'           => '',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_META . '_json_ld_address_addresslocality',
			array(
				'label'    => __( '市区町村名', 'nishiki_pro' ),
				'type'     => 'text',
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_META . '_json_ld',
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_address_addresslocality',
				'priority' => 7080,
			)
		);

		// Address streetAddress
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_address_streetaddress',
			array(
				'default'           => '',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_META . '_json_ld_address_streetaddress',
			array(
				'label'    => __( '住所（番地・アパート名なども含める）', 'nishiki_pro' ),
				'type'     => 'text',
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_META . '_json_ld',
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_address_streetaddress',
				'priority' => 7090,
			)
		);

		// ContactPoint telephone
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_contactpoint_telephone',
			array(
				'default'           => '',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_META . '_json_ld_contactpoint_telephone',
			array(
				'label'       => __( '連絡先（電話番号）', 'nishiki_pro' ),
				'description' => '国番号＋電話番号（例：+81(111)222-3333 または +81-111-222-3333 または +81-1112223333）',
				'type'        => 'text',
				'section'     => 'section_' . NISHIKI_PRO_PREFIX_META . '_json_ld',
				'settings'    => 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_contactpoint_telephone',
				'priority'    => 7100,
			)
		);

		// ContactPoint contactType
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_contactpoint_contacttype',
			array(
				'default'           => '',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'nishiki_pro_sanitize_choices_meta_json_ld_contactpoint_contacttype',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_META . '_json_ld_contactpoint_contacttype',
			array(
				'label'    => __( '連絡先の窓口', 'nishiki_pro' ),
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_META . '_json_ld',
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_contactpoint_contacttype',
				'type'     => 'select',
				'choices'  => array(
					''                    => __( '未設定', 'nishiki_pro' ),
					'customer service'    => __( 'カスタマーサービス（customer service）', 'nishiki_pro' ),
					'technical support'   => __( 'テクニカルサポート（technical support）', 'nishiki_pro' ),
					'billing support'     => __( '支払いや請求に関するサポート（billing support）', 'nishiki_pro' ),
					'bill payment'        => __( '支払い先（bill payment）', 'nishiki_pro' ),
					'sales'               => __( '販売（sales）', 'nishiki_pro' ),
					'reservations'        => __( '予約（reservations）', 'nishiki_pro' ),
					'credit card_support' => __( 'クレジットカードサポート（credit card_support）', 'nishiki_pro' ),
					'emergency'           => __( '緊急連絡先（emergency）', 'nishiki_pro' ),
					'baggage tracking'    => __( '空港などで預ける複数の荷物などの問い合わせ（baggage tracking）', 'nishiki_pro' ),
					'roadside assistance' => __( '自動車けん引などのサービス（roadside assistance）', 'nishiki_pro' ),
					'package tracking'    => __( '宅配便など小包の問い合わせ（package tracking）', 'nishiki_pro' ),
				),
				'priority' => 7110,
			)
		);

		// ContactPoint contactOption
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_contactpoint_contactoption',
			array(
				'default'           => '',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'nishiki_pro_sanitize_choices_meta_json_ld_contactpoint_contactoption',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_META . '_json_ld_contactpoint_contactoption',
			array(
				'label'    => __( '連絡先オプション', 'nishiki_pro' ),
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_META . '_json_ld',
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_contactpoint_contactoption',
				'type'     => 'select',
				'choices'  => array(
					''                         => __( '未設定', 'nishiki_pro' ),
					'TollFree'                 => __( 'フリーダイアル（TollFree）', 'nishiki_pro' ),
					'HearingImpairedSupported' => __( '聴覚に障害のある方対応（HearingImpairedSupported）', 'nishiki_pro' ),
				),
				'priority' => 7120,
			)
		);

		// ContactPoint areaServed
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_contactpoint_areaserved',
			array(
				'default'           => '',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_META . '_json_ld_contactpoint_areaserved',
			array(
				'label'       => __( 'サービス対応エリア', 'nishiki_pro' ),
				'description' => '国コード（例：JP,US など）',
				'type'        => 'text',
				'section'     => 'section_' . NISHIKI_PRO_PREFIX_META . '_json_ld',
				'settings'    => 'setting_' . NISHIKI_PRO_PREFIX_META . '_json_ld_contactpoint_areaserved',
				'priority'    => 7130,
			)
		);

	}
}
