<?php
if ( ! function_exists( 'nishiki_pro_init_customizer_toc' ) ) {
	add_action( 'customize_register', 'nishiki_pro_init_customizer_toc' );
	/**
	 * カスタマイザーの設定
	 *
	 * @param instance $wp_customize インスタンス
	 * @return void
	 */
	function nishiki_pro_init_customizer_toc( $wp_customize ) {

		// Section
		$wp_customize->add_section(
			'section_' . NISHIKI_PRO_PREFIX_TOC,
			array(
				'title'    => __( 'Table Of Contents', 'nishiki-pro' ),
				'priority' => 600,
				'panel'    => 'panel_' . NISHIKI_PRO_PREFIX,
			)
		);

		// Heading
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_TOC . '_display_header',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_TOC . '_display_header',
				array(
					'label'    => '<p class="nishiki-pro-customizer-heading">全体</p>',
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_TOC,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_display_header',
				)
			)
		);

		// Display TOC.
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_TOC . '_display',
			array(
				'default'           => true,
				'sanitize_callback' => 'nishiki_pro_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_TOC . '_display',
			array(
				'label'    => __( 'Display TOC posts and pages', 'nishiki-pro' ),
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_TOC,
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_display',
				'type'     => 'checkbox',
			)
		);

		// TOC Min Level.
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_TOC . '_min_level',
			array(
				'default'           => '3',
				'sanitize_callback' => 'nishiki_pro_sanitize_choices_toc_min_level',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_TOC . '_min_level',
			array(
				'label'    => __( 'Display TOC Min Level', 'nishiki-pro' ),
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_TOC,
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_min_level',
				'type'     => 'select',
				'choices'  => array(
					'2' => 'h2',
					'3' => 'h3',
					'4' => 'h4',
					'5' => 'h5',
					'6' => 'h6',
				),
			)
		);

		// Level Number.
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_TOC . '_level_number',
			array(
				'default'           => 4,
				'sanitize_callback' => 'nishiki_pro_sanitize_number',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_TOC . '_level_number',
			array(
				'label'    => __( 'Level Number', 'nishiki-pro' ),
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_TOC,
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_level_number',
				'type'     => 'number',
			)
		);

		// TOC Title Text
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_TOC . '_title_text',
			array(
				'default'           => __( 'Table Of Contents', 'nishiki-pro' ),
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_TOC . '_title_text',
			array(
				'label'    => __( 'Text Label', 'nishiki-pro' ),
				'type'     => 'text',
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_TOC,
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_title_text',
			)
		);

		// TOC Text Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_TOC . '_text_color',
			array(
				'default'           => '#444444',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_TOC . '_text_color',
				array(
					'label'    => __( 'Text Color', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_TOC,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_text_color',
				)
			)
		);

		// TOC Text Hover Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_TOC . '_text_hover_color',
			array(
				'default'           => '#222222',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_TOC . '_text_hover_color',
				array(
					'label'    => __( 'Text Hover Color', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_TOC,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_text_hover_color',
				)
			)
		);

		// TOC background Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_TOC . '_background_color',
			array(
				'default'           => '#fafafa',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_TOC . '_background_color',
				array(
					'label'    => __( 'Background Color', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_TOC,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_background_color',
				)
			)
		);

		// Heading
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_header',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_header',
				array(
					'label'    => '<p class="nishiki-pro-customizer-heading">固定目次</p>',
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_TOC,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_header',
				)
			)
		);

		// Display Fixed TOC.
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_display',
			array(
				'default'           => true,
				'sanitize_callback' => 'nishiki_pro_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_display',
			array(
				'label'    => __( 'Display', 'nishiki-pro' ),
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_TOC,
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_display',
				'type'     => 'checkbox',
			)
		);

		// TOC background Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_background_color',
			array(
				'default'           => '#222222',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_background_color',
				array(
					'label'    => __( 'Background Color', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_TOC,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_background_color',
				)
			)
		);

		// TOC Fixed Text Hover Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_text_color',
			array(
				'default'           => '#ffffff',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_text_color',
				array(
					'label'    => __( 'Text Color', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_TOC,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_text_color',
				)
			)
		);

		// Heading
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_overlay_header',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_overlay_header',
				array(
					'label'    => '<p class="nishiki-pro-customizer-heading">固定目次（オープン）</p>',
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_TOC,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_overlay_header',
				)
			)
		);

		// TOC background Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_overlay_background_color',
			array(
				'default'           => '#222222',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_overlay_background_color',
				array(
					'label'    => __( 'Background Color', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_TOC,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_overlay_background_color',
				)
			)
		);

		// TOC Fixed Text Hover Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_overlay_text_color',
			array(
				'default'           => '#ffffff',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_overlay_text_color',
				array(
					'label'    => __( 'Text Color', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_TOC,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_overlay_text_color',
				)
			)
		);

		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_overlay_background_color_opacity',
			array(
				'default'           => 90,
				'sanitize_callback' => 'nishiki_pro_sanitize_number_range',
			)
		);
	
		$wp_customize->add_control(
			new Nishiki_WP_Customize_Range(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_overlay_background_color_opacity',
				array(
					'label'    => __( 'Background Opacity(%)', 'nishiki-pro' ),
					'min'      => 0,
					'max'      => 100,
					'step'     => 1,
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_TOC,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_overlay_background_color_opacity',
				)
			)
		);

		// TOC Overlay Background Blur
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_overlay_backdrop_blur',
			array(
				'default'           => '',
				'sanitize_callback' => 'nishiki_pro_sanitize_choices_background_blur',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_overlay_backdrop_blur',
			array(
				'label'    => __( 'Background blur', 'nishiki-pro' ),
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_TOC,
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_overlay_backdrop_blur',
				'type'     => 'select',
				'choices'  => array(
					''                 => __( '未設定', 'nishiki-pro' ),
					'panel-blur-sm' => __( '弱', 'nishiki-pro' ),
					'panel-blur-md' => __( '中', 'nishiki-pro' ),
					'panel-blur-lg' => __( '強', 'nishiki-pro' ),
				)
			)
		);

		// TOC Overlay Panel Open Type
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_overlay_open_type',
			array(
				'default'           => 'panel-fade',
				'sanitize_callback' => 'nishiki_pro_sanitize_choices_panel_open_type',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_overlay_open_type',
			array(
				'label'    => __( 'オープンタイプ', 'nishiki-pro' ),
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_TOC,
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_TOC . '_fixed_overlay_open_type',
				'type'     => 'select',
				'choices'  => array(
					'panel-fade'  => __( 'フェード', 'nishiki-pro' ),
					'panel-slide' => __( 'スライド', 'nishiki-pro' ),
				),
				'priority' => 200,
			)
		);
	}
}
