<?php
/**
 * 拡張機能の初期設定（いずれ整理）
 *
 * @author     AnimaGate, Inc.
 * @link       https://support.animagate.com/product/wp-nishiki-pro/
 */

// Plugin Active.
if ( ! function_exists( 'is_plugin_active_for_network' ) ) {
	require_once ABSPATH . '/wp-admin/includes/plugin.php';
}

// Plugin directory root.
if ( ! function_exists( 'nishiki_pro_plugin_dir_root' ) ) {
	/**
	 * プラグインディレクトリの URL
	 *
	 * @return string
	 */
	function nishiki_pro_plugin_dir_root() {
		return plugin_dir_url( __FILE__ );
	}
}

// Get all public post types.
if ( ! function_exists( 'nishiki_pro_get_all_post_types' ) ) {
	/**
	 * 投稿タイプ全取得
	 *
	 * @return $post_types_array
	 */
	function nishiki_pro_get_all_post_types() {

		$args = array(
			'public'   => true, // 公開している投稿タイプは表示
			'_builtin' => false, // デフォルトの投稿タイプは非表示
		);

		$output   = 'names'; // 「names」で投稿タイプ名を指定
		$operator = 'and'; // 「and」で$argsの条件にどちらも合致するものだけ指定

		$post_types = get_post_types( $args, $output, $operator ); // 条件に合った投稿タイプ名を配列で取得

		$post_types_array = array( 'post', 'page' );
		foreach ( $post_types  as $post_type ) { // 取得した配列をループさせる
			$post_types_array[] = $post_type; // 投稿タイプ名を表示
		}

		return $post_types_array;
	}
}

if ( ! function_exists( 'nishiki_pro_parse_all_blocks' ) ) {
	/**
	 * 全ブロックを取得して配列で返す
	 *
	 * @param int $post_id 投稿 ID
	 * @return $blocks
	 */
	function nishiki_pro_parse_all_blocks( $post_id ) {

		if ( empty( $post_id ) ) {
			return false;
		}

		// 投稿情報を取得
		$post_object = get_post( $post_id );

		// コンテンツが取得できない場合はfalse
		if ( empty( $post_object->post_content ) ) {
			return false;
		}

		if ( ! has_blocks( $post_object->post_content ) ) {
			return false;
		}

		$blocks = parse_blocks( $post_object->post_content );

		// var_dump($blocks);

		return $blocks;
	}
}

if ( ! function_exists( 'nishiki_pro_parse_all_block_names' ) ) {
	/**
	 * ブロック名を再帰的に取得
	 *
	 * @param object $block_object ブロックのオブジェクト
	 * @return $blockNames
	 */
	function nishiki_pro_parse_all_block_names( $block_object ) {

		if ( empty( $block_object ) ) {
			return false;
		}

		// ブロック名を入れる配列
		$block_names = array();

		// ブロックが配列になければ追加する
		if ( ! in_array( $block_object['blockName'], $block_names, true ) ) {
			$block_names[] = $block_object['blockName'];
		}

		// インナーブロックの処理
		if ( ! empty( $block_object['innerBlocks'] ) ) {

			// var_dump($blockObject );
			foreach ( $block_object['innerBlocks'] as $inner_block ) {

				// インナーブロックを再帰的にパース
				$inner_block_names = nishiki_pro_parse_all_block_names( $inner_block );

				// 配列に格納
				$block_names = array_unique( array_merge( $block_names, $inner_block_names ) );

			}
		}

		// 再利用ブロックの処理
		if ( 'core/block' === $block_object['blockName'] ) {
			if ( ! empty( $block_object['attrs']['ref'] ) ) {

				// 再利用ブロックをパースして取得
				$reusable_blocks = nishiki_pro_parse_all_blocks( $block_object['attrs']['ref'] );

				if ( ! empty( $reusable_blocks ) ) {
					foreach ( $reusable_blocks as $reusable_block ) {

						// 全ブロック名取得
						$reusable_block_names = nishiki_pro_parse_all_block_names( $reusable_block );

						// 配列に格納
						$block_names = array_unique( array_merge( $block_names, $reusable_block_names ) );
					}
				}
			}
		}

		return $block_names;
	}
}


if ( ! function_exists( 'nishiki_pro_parse_all_block_content' ) ) {
	/**
	 * ブロックのコンテンツを再帰的に取得
	 *
	 * @param object $block_object ブロックのオブジェクト
	 * @return $blockNames
	 */
	function nishiki_pro_parse_all_block_content( $block_object ) {

		if ( empty( $block_object ) ) {
			return false;
		}

		// ブロック名を入れる配列
		$block_objects = array();

		// ブロックが配列になければ追加する
		if ( ! in_array( $block_object['blockName'], array_column( $block_objects, 'blockName' ), true ) ) {
			$block_objects[] = $block_object;

			// var_dump($block_objects);
		}

		// インナーブロックの処理
		if ( ! empty( $block_object['innerBlocks'] ) ) {

			// var_dump($blockObject );
			foreach ( $block_object['innerBlocks'] as $inner_block ) {

				// インナーブロックを再帰的にパース
				$inner_block_objects = nishiki_pro_parse_all_block_content( $inner_block );

				// 配列に格納
				$block_objects = array_merge( $block_objects, $inner_block_objects );

			}
		}

		// 再利用ブロックの処理
		if ( 'core/block' === $block_object['blockName'] ) {
			if ( ! empty( $block_object['attrs']['ref'] ) ) {

				// 再利用ブロックをパースして取得
				$reusable_blocks = nishiki_pro_parse_all_blocks( $block_object['attrs']['ref'] );

				if ( ! empty( $reusable_blocks ) ) {
					foreach ( $reusable_blocks as $reusable_block ) {

						// 全ブロック名取得
						$reusable_block_objects = nishiki_pro_parse_all_block_content( $reusable_block );

						// 配列に格納
						$block_objects = array_merge( $block_objects, $reusable_block_objects );
					}
				}
			}
		}

		// var_dump($block_objects);

		return $block_objects;
	}
}

if ( ! function_exists( 'nishiki_pro_enqueue_swiper' ) ) {
	/**
	 * Swiper 読み込み
	 *
	 * @return boolean
	 */
	function nishiki_pro_enqueue_swiper() {
		$enqueue_swiper = apply_filters(
			'nishiki_pro_enqueue_swiper',
			true
		);

		if ( ! $enqueue_swiper ) {
			return false;
		}

		// Add Swiper
		wp_register_script( 'nishiki-pro-swiper', get_template_directory_uri() . '/assets/js/swiper/swiper-bundle.min.js', array(), '1.0.0', false );
		wp_enqueue_script( 'nishiki-pro-swiper' );
	}
}

// Auth
require_once 'class/auth/class-auth.php';

// Registration
require_once 'class/auth/class-auth-registration.php';

// Menu
//require_once 'menu/init.php';

// Dashboard
require_once 'dashboard/init.php';

// Widget
require_once 'widget/init.php';

// TOC
require_once 'toc/init.php';

// Customizer
require_once 'customizer/init.php';

// Class
require_once 'class/init.php';

// Block v2
require_once 'block2/init.php';

// Block
require_once 'block/init.php';

// Nav
require_once 'nav/init.php';
