<?php
/**
 * ブロックエディター 関連の設定
 *
 * @author     AnimaGate, Inc.
 * @link       https://support.animagate.com/product/wp-nishiki-pro/
 */

if ( ! function_exists( 'nishiki_pro_enqueue_block_inline_styles' ) ) {
	/**
	 * ブロックスタイルの読み込み
	 *
	 * @return boolean
	 */
	function nishiki_pro_enqueue_block_inline_styles() {
		global $post;

		if ( empty( $post->ID ) ) {
			return false;
		}

		$post_object = get_post( $post->ID );

		if ( has_blocks( $post_object->post_content ) ) {
			$blocks = parse_blocks( $post->post_content );

			$style = '';

			foreach ( $blocks as $block ) {

				// Tabs
				if ( 'nishiki-blocks-pro/tabs' === $block['blockName'] ) {
					$id = $block['attrs']['blockID'];

					$tab_title_style        = '';
					$tab_title_active_style = '';
					$tab_content_style      = '';

					// Root Id
					if ( ! empty( $id ) ) {
						$root_style = '#nishiki-blocks-pro-tabs-' . $id;
					}

					//
					// Tab Titles
					//

					// Tab Titles Button
					if ( ! empty( $block['attrs']['tabTitleBgColor'] ) ) {
						$tab_title_bg_color = $block['attrs']['tabTitleBgColor'];
						$tab_title_style   .= 'background-color:' . $tab_title_bg_color . ';';
					}

					if ( ! empty( $block['attrs']['tabTitleTextColor'] ) ) {
						$tab_title_text_color = $block['attrs']['tabTitleTextColor'];
						$tab_title_style     .= 'color:' . $tab_title_text_color . ';';
					}

					// Tab Titles Button(active)
					if ( ! empty( $block['attrs']['tabTitleActiveBgColor'] ) ) {
						$tab_title_active_bg_color = $block['attrs']['tabTitleActiveBgColor'];
						$tab_title_active_style   .= 'background-color:' . $tab_title_active_bg_color . ';';
					}

					if ( ! empty( $block['attrs']['tabTitleActiveTextColor'] ) ) {
						$tab_title_active_text_color = $block['attrs']['tabTitleActiveTextColor'];
						$tab_title_active_style     .= 'color:' . $tab_title_active_text_color . ';';
					}

					// Tab Border Color
					if ( ! empty( $block['attrs']['tabTitleBorderColor'] ) ) {
						$tab_title_border_color = $block['attrs']['tabTitleBorderColor'];
						$tab_title_style       .= 'border-color:' . $tab_title_border_color . ';';
					}

					//
					// Tab Contents
					//

					// Tab Bg Color
					if ( ! empty( $block['attrs']['tabContentBgColor'] ) ) {
						$tab_content_bg_color = $block['attrs']['tabContentBgColor'];
						$tab_content_style   .= 'background-color:' . $tab_content_bg_color . ';';
					}

					// Tab Border Color
					if ( ! empty( $block['attrs']['tabContentBorderColor'] ) ) {
						$tab_content_border_color = $block['attrs']['tabContentBorderColor'];
						$tab_content_style       .= 'border-color:' . $tab_content_border_color . ';';
					}

					// Styles

					// Tab Title
					if ( ! empty( $tab_title_bg_color ) || ! empty( $tab_title_text_color ) || ! empty( $tab_title_border_color ) ) {
						$style .= $root_style . ' .tab-titles button{' . $tab_title_style . '}';
					}

					if ( ! empty( $tab_title_active_bg_color ) || ! empty( $tab_title_active_text_color ) ) {
						$style .= $root_style . ' .tab-titles button.active{' . $tab_title_active_style . '}';
					}

					// Tab Vertical
					if ( ! empty( $block['attrs']['tabTitleWidth'] ) ) {
						$tab_title_width = $block['attrs']['tabTitleWidth'];

						$style .= '@media only screen and (min-width: 781px){' . $root_style . ' .tab-titles{flex-basis:' . $tab_title_width . 'px;}}';
					}

					// Tab Contents
					if ( $tab_content_style ) {
						$style .= $root_style . ' .tab-contents{' . $tab_content_style . '}';
					}
				}
			}

			if ( ! empty( $style ) ) {
				wp_add_inline_style( 'nishiki-pro-main-style', $style );
			}
		}
	}

	//add_action( 'wp_enqueue_scripts', 'nishiki_pro_enqueue_block_inline_styles', 20 );
}

if ( ! function_exists( 'nishiki_pro_enqueue_block_inline_styles2' ) ) {
	/**
	 * ブロックスタイルの読み込み
	 *
	 * @return boolean
	 */
	function nishiki_pro_enqueue_block_inline_styles2() {
		global $post;

		if ( empty( $post->ID ) ) {
			return false;
		}

		$post_object = get_post( $post->ID );

		$all_blocks      = nishiki_pro_parse_all_blocks( $post->ID );

		if ( ! empty( $all_blocks ) ) {

			foreach ( $all_blocks as $blocks ) {
				// 全ブロックのコンテンツ取得
				$all_block_contents = nishiki_pro_parse_all_block_content( $blocks );

				$style = '';

				foreach ( $all_block_contents as $block ) {
					if ( 'nishiki-blocks-pro/tabs' === $block['blockName'] || 'nishiki-blocks-pro/tabs2' === $block['blockName'] ) {
						$id = $block['attrs']['blockID'];

						$tab_title_style        = '';
						$tab_title_active_style = '';
						$tab_content_style      = '';

						// Root Id
						if ( ! empty( $id ) ) {
							$root_style = '#nishiki-blocks-pro-tabs-' . $id;
						}

						//
						// Tab Titles
						//

						// Tab Titles Button
						if ( ! empty( $block['attrs']['tabTitleBgColor'] ) ) {
							$tab_title_bg_color = $block['attrs']['tabTitleBgColor'];
							$tab_title_style   .= 'background-color:' . $tab_title_bg_color . ';';
						}

						if ( ! empty( $block['attrs']['tabTitleTextColor'] ) ) {
							$tab_title_text_color = $block['attrs']['tabTitleTextColor'];
							$tab_title_style     .= 'color:' . $tab_title_text_color . ';';
						}

						// Tab Titles Button(active)
						if ( ! empty( $block['attrs']['tabTitleActiveBgColor'] ) ) {
							$tab_title_active_bg_color = $block['attrs']['tabTitleActiveBgColor'];
							$tab_title_active_style   .= 'background-color:' . $tab_title_active_bg_color . ';';
						}

						if ( ! empty( $block['attrs']['tabTitleActiveTextColor'] ) ) {
							$tab_title_active_text_color = $block['attrs']['tabTitleActiveTextColor'];
							$tab_title_active_style     .= 'color:' . $tab_title_active_text_color . ';';
						}

						// Tab Border Color
						if ( ! empty( $block['attrs']['tabTitleBorderColor'] ) ) {
							$tab_title_border_color = $block['attrs']['tabTitleBorderColor'];
							$tab_title_style       .= 'border-color:' . $tab_title_border_color . ';';
						}

						//
						// Tab Contents
						//

						// Tab Bg Color
						if ( ! empty( $block['attrs']['tabContentBgColor'] ) ) {
							$tab_content_bg_color = $block['attrs']['tabContentBgColor'];
							$tab_content_style   .= 'background-color:' . $tab_content_bg_color . ';';
						}

						// Tab Border Color
						if ( ! empty( $block['attrs']['tabContentBorderColor'] ) ) {
							$tab_content_border_color = $block['attrs']['tabContentBorderColor'];
							$tab_content_style       .= 'border-color:' . $tab_content_border_color . ';';
						}

						// Styles

						// Tab Title
						if ( ! empty( $tab_title_bg_color ) || ! empty( $tab_title_text_color ) || ! empty( $tab_title_border_color ) ) {
							$style .= $root_style . ' .tab-titles button:not(.active){' . $tab_title_style . '}';
						}

						if ( ! empty( $tab_title_active_bg_color ) || ! empty( $tab_title_active_text_color ) ) {
							$style .= $root_style . ' .tab-titles button.active{' . $tab_title_active_style . '}';
						}

						// Tab Vertical
						if ( ! empty( $block['attrs']['tabTitleWidth'] ) ) {
							$tab_title_width = $block['attrs']['tabTitleWidth'];

							$style .= '@media only screen and (min-width: 781px){' . $root_style . ' .tab-titles{flex-basis:' . $tab_title_width . 'px;}}';
						}

						// Tab Contents
						if ( $tab_content_style ) {
							$style .= $root_style . ' .tab-contents{' . $tab_content_style . '}';
						}
					}
				}

				if ( ! empty( $style ) ) {
					wp_add_inline_style( 'nishiki-pro-main-style', $style );
				}
			}
		}
	}

	add_action( 'wp_enqueue_scripts', 'nishiki_pro_enqueue_block_inline_styles2', 20 );
}
