<?php
/**
 * アーカイブ一覧 パーツ
 *
 * @author     AnimaGate, Inc.
 * @link       https://support.animagate.com/product/wp-nishiki-pro/
 */

?>
<div class="archives">
<?php
do_action( 'nishiki_pro_before_archive_inner_archives' );
if ( is_home() ) {
	do_action( 'nishiki_pro_before_home_content' );
} elseif ( is_search() ) {
	do_action( 'nishiki_pro_before_search_content' );
} else {
	do_action( 'nishiki_pro_before_archive_content' );
}
?>
<?php if ( is_front_page() && get_theme_mod( 'setting_top_recently_article_main_text', __( 'Recent Articles', 'nishiki-pro' ) ) ) { ?>
	<div class="title">
		<h1><?php echo esc_html( get_theme_mod( 'setting_top_recently_article_main_text', __( 'Recent Articles', 'nishiki-pro' ) ) ); ?></h1>
		<?php
		if ( get_theme_mod( 'setting_top_recently_article_sub_text' ) ) {
			echo '<span class="sub-text">' . esc_html( get_theme_mod( 'setting_top_recently_article_sub_text', __( 'Sub Text', 'nishiki-pro' ) ) ) . '</span>';
		}
		?>
	</div>
	<?php
}
$columns      = apply_filters( 'nishiki_pro_archive_article_columns', get_theme_mod( 'setting_archive_article_columns', '3' ) );
$layout       = apply_filters( 'nishiki_pro_archive_article_layout', get_theme_mod( 'setting_archive_article_layout', 'card' ) );
$layout_class = '';
$article_design = apply_filters( 'nishiki_pro_archive_article_layout', get_theme_mod( 'setting_archive_article_design', '' ) );
$article_design_class = '';

if ( $layout ) {
	$layout_class = ' is-' . $layout;
}

if ( $article_design ) {
	$article_design_class = ' has-' . $article_design;
}

$multiple_search_options = get_option( 'nishiki_pro_multiple_search' );
$infeed_ads_options      = get_option( 'nishiki_pro_general_infeed_ads' );
$count                   = 1;

if ( have_posts() ) {
	echo '<div class="articles flex' . esc_attr( $layout_class ) . esc_attr( $article_design_class ) . ' column-' . esc_attr( $columns ) . '">';
	do_action( 'nishiki_pro_before_archive_inner_articles' );
	while ( have_posts() ) {
		the_post();
		do_action( 'nishiki_pro_before_archive_posts', $count, $infeed_ads_options );
		nishiki_pro_get_template_part( 'parts/archive/post' );
		do_action( 'nishiki_pro_after_archive_posts', $count, $infeed_ads_options );
		++$count;
	}
	do_action( 'nishiki_pro_after_archive_inner_articles' );
	echo '</div>';
} else {
	if ( is_search() ) {
		do_action( 'nishiki_pro_before_search_no_post' );
		echo '<p>' . esc_html( __( 'We could not find any results for your search. You can give it another try through the search form below.', 'nishiki-pro' ) ) . '</p>';
		do_action( 'nishiki_pro_after_search_no_post' );
	}
}

the_posts_pagination(
	array(
		'prev_text'          => '<i class="icomoon icon-arrow-left"></i><span class="screen-reader-text">' . __( 'Previous page', 'nishiki-pro' ) . '</span>',
		'next_text'          => '<span class="screen-reader-text">' . __( 'Next page', 'nishiki-pro' ) . '</span><i class="icomoon icon-arrow-right"></i>',
		'before_page_number' => '',
	)
);

if( is_search() ){
	if ( ! empty( $multiple_search_options['multiple_search_result'] ) ) {
		do_action( 'nishiki_pro_before_multiple_search_result_content' );

		if( ! empty( $multiple_search_options['replace_filter_search_block_id'] ) ){
			$replace_id = $multiple_search_options['replace_filter_search_block_id'];
		}

		if( ! empty( $replace_id ) ){
			nishiki_pro_replace_filter_search_block_form( $replace_id );
		} else {
			echo do_shortcode( '[nishiki_pro_multiple_search]' );
		}

		do_action( 'nishiki_pro_after_multiple_search_result_content' );
	} else {
		do_action( 'nishiki_pro_archive_search_form' );
	}
	do_action( 'nishiki_pro_after_search_content' );
} elseif( is_home() ) {
	do_action( 'nishiki_pro_after_home_content' );
} else {
	do_action( 'nishiki_pro_after_archive_content' );
}

do_action( 'nishiki_pro_after_archive_inner_archives' );
?>
</div>
