<?php
/**
 * メインビジュアル パーツ
 *
 * @author     AnimaGate, Inc.
 * @link       https://support.animagate.com/product/wp-nishiki-pro/
 */

$nishiki_pro_main_visual_class = '';
$image_large                   = '';
$image                         = '';

if ( nishiki_pro_has_header_video() ) {
	$nishiki_pro_main_visual_class .= ' main-video';
	if ( has_header_image() ) {
		$nishiki_pro_main_visual_class .= ' has-header-image';
		$image_large                    = ' data-src="' . get_header_image() . '"';
	}
} else {
	if ( has_header_image() ) {
		$nishiki_pro_main_visual_class .= ' has-header-image';
		$image_large                    = ' data-src="' . get_header_image() . '"';
	} else {
		$nishiki_pro_main_visual_class = ' main-default-header-image';
		$image_large                   = ' data-src="' . get_template_directory_uri() . '/assets/images/carp.jpg"';
	}
}

$nishiki_pro_main_visual_alt = ' data-alt=' . get_theme_mod( 'setting_top_main_visual_image_alt' );

echo '<section id="main-visual" class="main-visual' . esc_attr( $nishiki_pro_main_visual_class ) . '"' . wp_kses_post( $image_large ) . wp_kses_post( $nishiki_pro_main_visual_alt ) . '>';
echo '<div class="custom-header">';
if ( get_theme_mod( 'setting_top_main_visual_image_placeholder_display' ) ) {
	if ( has_header_image() && ! empty( get_custom_header()->attachment_id ) ) {
		$image_id = get_custom_header()->attachment_id;
	}
	if ( ! empty( $image_id ) ) {
		$image_data = wp_get_attachment_image_src( $image_id, 'nishiki-thumbnail' );
		if ( $image_data[3] ) {
			$custom_header_image_thumbnail = $image_data[0];
			echo '<img class="img-placeholder" src="' . esc_url( $custom_header_image_thumbnail ) . '" alt="">';
		}
	}
}
if ( has_custom_header() ) {
	the_custom_header_markup();
}
echo '</div>';

echo '<div class="main-visual-content container">';
if ( get_bloginfo( 'description' ) && get_header_textcolor() !== 'blank' ) {
	echo '<p class="description">' . esc_html( get_bloginfo( 'description' ) ) . '</p>';
}
if ( get_theme_mod( 'setting_top_main_visual_sub_text' ) ) {
	$sub_text_align = get_theme_mod( 'setting_top_main_visual_sub_text_align', 'center' );
	echo '<p class="sub-text ' . esc_attr( $sub_text_align ) . '">' . wp_kses_post( get_theme_mod( 'setting_top_main_visual_sub_text', __( 'Beautiful WordPress Theme the Nishiki.', 'nishiki-pro' ) ) ) . '</p>';
}
if ( get_theme_mod( 'setting_top_main_visual_main_button_text', __( 'テーマのページを読む', 'nishiki-pro' ) ) ) {
	if ( get_theme_mod( 'setting_top_main_visual_main_button_link', false ) === false ) {
		$main_visual_button_display = false;
		if ( current_user_can( 'edit_theme_options' ) ) {
			$main_visual_button_display = true;
			$main_visual_button_link    = get_admin_url( '', '/themes.php?page=nishiki-pro-about', '' );
		} else {
			$main_visual_button_link = get_theme_mod( 'setting_top_main_visual_main_button_link', false );
		}
	} else {
		$main_visual_button_display = true;
		$main_visual_button_link    = get_theme_mod( 'setting_top_main_visual_main_button_link', false );
	}
	if ( true === $main_visual_button_display ) {
		$main_visual_button_target = '';
		if ( get_theme_mod( 'setting_top_main_visual_main_button_link_target', false ) ) {
			$main_visual_button_target = 'target="_blank" rel="noopener noreferrer" ';
		}
		?>
		<p class="main-button">
			<a class="btn" <?php echo esc_attr( $main_visual_button_target ); ?>href="<?php echo esc_url( $main_visual_button_link ); ?>">
			<?php echo esc_html( get_theme_mod( 'setting_top_main_visual_main_button_text', __( 'Get started!', 'nishiki-pro' ) ) ); ?>
			</a>
		</p>
		<?php
	}
}
echo '</div>';
echo '</section>';
