<?php
/**
 * ヘッダーコンテンツ パーツ
 *
 * @author     AnimaGate, Inc.
 * @link       https://support.animagate.com/product/wp-nishiki-pro/
 */

// テンプレートチェック
if ( ! empty( $args['content_class'] ) ) {
	$content_class = $args['content_class'];
} else {
	$content_class = apply_filters( 'nishiki_pro_content_class', '' );
}

?>

<body <?php do_action( 'nishiki_pro_body_attributes' ); body_class(); ?>>
	<?php wp_body_open(); ?>
	<?php do_action( 'nishiki_pro_body_open' ); ?>
	<?php if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_enable' ) ) { ?>
		<script>
			let getThemeMode = localStorage.getItem('theme');
			if ( getThemeMode ) {
				document.body.setAttribute( 'data-theme', getThemeMode );
			}
		</script>
		<?php
	}
	$header_layout = ( get_theme_mod( 'setting_header_layout', 'default' ) === 'default' ) ? '' : get_theme_mod( 'setting_header_layout' ) . ' ';
	?>
	<div id="page" class="site" <?php do_action( 'nishiki_pro_page_attributes' ); ?>>
		<?php do_action( 'nishiki_pro_before_site_header' ); ?>
		<header id="masthead"<?php nishiki_pro_masthead_class(); ?> role="banner">
			<div class="<?php echo esc_attr( $header_layout ); ?>flex w-full container">
			<?php if ( get_header_textcolor() !== 'blank' || has_custom_logo() ) { ?>
				<?php
				$element = 'div';
				if ( is_home() || is_front_page() ) {
					$element = 'h1';
				}
				?>
				<<?php echo esc_html( $element ); ?> class="site-info">
				<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
				<?php
				if ( has_custom_logo() ) {
					$custom_logo_id = apply_filters( 'nishiki_pro_custom_logo_attachment_id', get_theme_mod( 'custom_logo' ) );
					$logo           = wp_get_attachment_image_src( $custom_logo_id, 'full' );

					echo '<img src="' . esc_url( $logo[0] ) . '" width="' . absint( $logo[1] ) . '" height="' . absint( $logo[2] ) . '" alt="' . esc_attr( get_bloginfo( 'name' ) ) . '">';
				} elseif ( get_header_textcolor() !== 'blank' ) {
					echo '<span class="site-title">' . esc_html( get_bloginfo( 'name' ) ) . '</span>';
				}
				?>
				</a>
				</<?php echo esc_html( $element ); ?>>
			<?php } ?>
			<?php nishiki_pro_get_template_part( 'parts/header/global-nav' ); ?>
			</div>
			<?php
			$menu_name           = 'footer';
			$display_footer_menu = false;
			$locations           = get_nav_menu_locations();
			if ( array_key_exists( $menu_name, $locations ) ) {
				$menu_id     = $locations[ $menu_name ];
				$menu_object = wp_get_nav_menu_object( $menu_id );
				if ( $menu_object ) {
					$menu_items      = wp_get_nav_menu_items( $menu_object->term_id );
					$menu_items_list = array_column( $menu_items, 'type', 'object' );

					if ( array_key_exists( 'search', $menu_items_list ) && ( 'nishiki-pro-nav-menus' === $menu_items_list['search'] || 'nishiki-pro-buttons' === $menu_items_list['search'] ) ) {
						$display_footer_menu = true;
					}
				}
			}
			?>
		</header>
		<?php 
		if ( get_theme_mod( 'setting_header_search_button', true ) || true === $display_footer_menu ) {
			$search_overlay_class = 'overlay flex fixed w-full h-full';
			if ( get_theme_mod( 'setting_header_search_overlay_open_type', 'panel-slide' ) ) {
				$search_overlay_class .= ' ' . get_theme_mod( 'setting_header_search_overlay_open_type', 'panel-slide' );
			}
			if ( get_theme_mod( 'setting_header_search_overlay_backdrop_blur' ) ) {
				$search_overlay_class .= ' ' . get_theme_mod( 'setting_header_search_overlay_backdrop_blur' );
			}
			?>
			<div id="search-overlay" class="<?php echo esc_html( $search_overlay_class ); ?>">
				<div class="overlay-inner relative w-full">
					<?php
					$multiple_search_options = get_option( 'nishiki_pro_multiple_search' );

					if ( ! empty( $multiple_search_options['multiple_search_overlay'] ) ) {						
						do_action( 'nishiki_pro_after_multiple_search_overlay_content' );

						if( ! empty( $multiple_search_options['replace_filter_search_block_id'] ) ){
							$replace_id = $multiple_search_options['replace_filter_search_block_id'];
						}

						if( ! empty( $replace_id ) ){
							nishiki_pro_replace_filter_search_block_form( $replace_id );
						} else {
							echo do_shortcode( '[nishiki_pro_multiple_search]' );
						}

						do_action( 'nishiki_pro_after_multiple_search_overlay_content' );
					} else {
						get_search_form();
					}
					?>
					<button class="close" aria-label="<?php esc_html_e( 'close', 'nishiki-pro' ); ?>"><i class="icomoon icon-close"></i></button>
				</div>
			</div>
		<?php } ?>
		<?php
		if ( has_nav_menu( 'global' ) ) {
			$menu_overlay_class = 'overlay flex fixed w-full h-full';
			if ( get_theme_mod( 'setting_header_menu_overlay_open_type', 'panel-slide' ) ) {
				$menu_overlay_class .= ' ' . get_theme_mod( 'setting_header_menu_overlay_open_type', 'panel-slide' );
			}
			if ( get_theme_mod( 'setting_header_menu_overlay_backdrop_blur' ) ) {
				$menu_overlay_class .= ' ' . get_theme_mod( 'setting_header_menu_overlay_backdrop_blur' );
			}
			if ( ! get_theme_mod( 'setting_header_menu_collapse' ) ) {
				$menu_overlay_class .= ' always-open';
			}
			?>
			<div id="menu-overlay" class="<?php echo esc_html( $menu_overlay_class ); ?>" data-nav-open-type="click">
				<div class="overlay-inner relative w-full">
					<section class="nav-items-wrapper">
						<div class="nav-items-inner">
						<?php
						if ( is_active_sidebar( 'mobile_before_nav_items' ) ) {
							?>
							<section class="mobile-nav-items-widget-area">
							<?php dynamic_sidebar( 'mobile_before_nav_items' ); ?>
							</section>
							<?php
						}

						$nav_args = array(
							'theme_location'  => 'global',
							'container_class' => '',
							'container'       => '',
							'menu_id'         => '',
							'items_wrap'      => '<ul class="menu-items">%3$s</ul>',
							'walker'          => new NISHIKI_PRO_WALKER_GLOBAL_NAV(),
							'overlay'         => true,
						);
						do_action( 'nishiki_pro_before_global_nav_menu' );
						wp_nav_menu( $nav_args );
						do_action( 'nishiki_pro_after_global_nav_menu' );

						if ( is_active_sidebar( 'mobile_after_nav_items' ) ) {
							?>
							<section class="mobile-nav-items-widget-area">
							<?php dynamic_sidebar( 'mobile_after_nav_items' ); ?>
							</section>
							<?php
						}
						?>
						</div>
					</section>
					<button class="close" aria-label="<?php esc_html_e( 'close', 'nishiki-pro' ); ?>"><i class="icomoon icon-close"></i></button>
				</div>
			</div>
		<?php } ?>		
		<?php do_action( 'nishiki_pro_after_site_header' ); ?>
		<?php do_action( 'nishiki_pro_before_content' ); ?>
		<div id="content" <?php do_action( 'nishiki_pro_content_attributes' ); ?> class="content<?php echo esc_attr( $content_class ); ?>">
			<?php do_action( 'nishiki_pro_before_inner_content' ); ?>
