<?php
/**
 * 検索結果 ページ
 *
 * @author     AnimaGate, Inc.
 * @link       https://support.animagate.com/product/wp-nishiki-pro/
 */

get_header(); ?>
	<main id="main" class="site-main" role="main" <?php do_action( 'nishiki_pro_main_attributes' ); ?>>
		<?php do_action( 'nishiki_pro_before_search_header' ); ?>
		<header<?php echo wp_kses_post( apply_filters( 'nishiki_pro_page_header_attributes', '' ) ); ?>>
			<div class="page-header-inner container">
				<?php do_action( 'nishiki_pro_before_search_title' ); ?>
				<?php the_archive_title( '<h1>', '</h1>' ); ?>
				<?php do_action( 'nishiki_pro_after_search_title' ); ?>
				<?php
					$builtin_taxonomy = array(
						'category',
						'post_tag',
					);
					$args             = array(
						'public'   => true,
						'_builtin' => false,
					);

					$output     = 'names'; // or objects
					$operator   = 'and'; // 'and' or 'or'
					$taxonomies = get_taxonomies( $args, $output, $operator ); // 全タクソノミー取得

					$all_taxonomies         = array_merge( $builtin_taxonomy, $taxonomies );
					$output                 = '';
					$separator_taxonomy     = '：';
					$separator_term         = '/';
					$multiple_search_result = '';

					if ( $all_taxonomies ) {
						foreach ( $all_taxonomies as $search_taxonomy ) {
							if ( ! empty( get_query_var( $search_taxonomy ) ) ) {
								$taxonomy_data = get_taxonomy( $search_taxonomy );
								$output        = esc_html( $taxonomy_data->label ) . $separator_taxonomy;

								foreach ( get_query_var( $search_taxonomy ) as $search_term ) {
									$term_data = get_term( $search_term, $search_taxonomy );
									$output   .= esc_html( $term_data->name ) . $separator_term;
								}

								$output                  = trim( $output, $separator_term );
								$multiple_search_result .= '<p class="search-result-taxonomy taxonomy-' . $search_taxonomy . '">' . $output . '</p>';
							}
						}
					}

					if ( get_search_query() || $multiple_search_result ) {
						?>
						<div class="taxonomy-description">
							<?php
							if ( get_search_query() ) {
								echo '<p class="search-result-word">' . esc_html( __( 'Search words:', 'nishiki-pro' ) . get_search_query() ) . '</p>';
							}
							if ( $multiple_search_result ) {
								echo wp_kses_post( $multiple_search_result );
							}
							?>
						</div>
						<?php
					}
					?>
			</div>
		</header>
		<?php do_action( 'nishiki_pro_after_search_header' ); ?>
		<?php do_action( 'nishiki_pro_before_search_container' ); ?>
		<div class="container column">
		<?php
			do_action( 'nishiki_pro_before_search_inner_container' );
			nishiki_pro_get_template_part( 'parts/archive/content' );
			do_action( 'nishiki_pro_sidebar' );
			do_action( 'nishiki_pro_after_search_inner_container' );
		?>
		</div>
		<?php do_action( 'nishiki_pro_after_search_container' ); ?>
	</main>
<?php get_footer();
