(function () {
	'use strict';

	function nishikiRegisterListener(event, func) {
	  if (window.addEventListener) {
	    window.addEventListener(event, func);
	  } else {
	    window.attachEvent('on' + event, func);
	  }
	}

	function nishikiProGetHeaderHeight() {
	  var tocFixedHeader = document.getElementById('nishiki-toc-fixed');
	  var html = document.documentElement;
	  var masthead = document.getElementById('masthead');
	  var mobileSize = 781;
	  var headerHeight = 0;

	  if (!!tocFixedHeader) {
	    headerHeight = tocFixedHeader.clientHeight;
	  } else {
	    if (!!masthead && masthead.classList.contains('sticky')) {
	      headerHeight = masthead.clientHeight;
	    }

	    if (!!masthead && html.clientWidth < mobileSize && masthead.classList.contains('fixed-mobile')) {
	      headerHeight = masthead.clientHeight;
	    }
	  }

	  return headerHeight;
	}

	function overlayOutsideClose(element, outside, func) {
	  if (element) {
	    element.addEventListener('click', function (event) {
	      if (!event.target.closest(outside)) {
	        if (element.classList.contains('panel-open')) {
	          func();
	        }
	      }
	    });
	  }
	}

	var searchButton = document.getElementById('search-button');
	var searchButtonFooter = document.getElementById('search-button-footer');
	var menuButton = document.getElementById('menu-button');
	var menuButtonFooter = document.getElementById('menu-button-footer');
	var menuCollapse = document.getElementById('menu-collapse');
	var menuCollapseButton = document.getElementById('menu-collapse-button');
	var menuCollapseButtonFooter = document.getElementById('menu-collapse-button-footer');
	var menuOverlay = document.getElementById('menu-overlay');
	var menuCollapseOverlay = document.getElementById('menu-collapse');
	var searchOverlay = document.getElementById('search-overlay');
	var menuTimer = null;
	var menuSpeed = 300;

	if (!!searchButton) {
	  searchButton.addEventListener('click', function () {
	    nishikiSearchOverlayOpen();
	  }, false);
	}

	if (!!searchButtonFooter) {
	  searchButtonFooter.addEventListener('click', function () {
	    nishikiSearchOverlayOpen();
	  }, false);
	}

	function nishikiSearchOverlayOpen() {
	  searchOverlay.classList.add('panel-open');

	  if (!!document.getElementById('s')) {
	    document.getElementById('s').focus();
	  } else if (!!document.querySelectorAll('#page .nishiki-pro-filter-search form #keywords')[0]) {
	    var form = document.querySelectorAll('#page .nishiki-pro-filter-search form #keywords')[0];
	    form.focus();
	  }
	}

	function nishikiSearchOverlayClose() {
	  searchOverlay.classList.remove('panel-open');
	  searchOverlay.classList.add('panel-close');
	  clearTimeout(menuTimer);
	  menuTimer = setTimeout(function () {
	    setTimeout(function () {
	      searchOverlay.classList.remove('panel-close');
	    }, 200);
	  }, menuSpeed / 3);
	}

	if (!!menuButton) {
	  menuButton.addEventListener('click', function () {
	    nishikiMenuOverlayOpen();
	  }, false);
	}

	if (!!menuButtonFooter) {
	  menuButtonFooter.addEventListener('click', function () {
	    nishikiMenuOverlayOpen();
	  }, false);
	}

	if (!!menuCollapseButton) {
	  menuCollapseButton.addEventListener('click', function () {
	    nishikiMenuCollapseOverlayOpen();
	  }, false);
	}

	if (!!menuCollapseButtonFooter) {
	  menuCollapseButtonFooter.addEventListener('click', function () {
	    nishikiMenuCollapseOverlayOpen();
	  }, false);
	}

	function nishikiMenuCollapseOverlayOpen() {
	  menuCollapse.classList.add('panel-open');
	}

	function nishikiMenuCollapseOverlayClose() {
	  menuCollapse.classList.remove('panel-open');
	  menuCollapse.classList.add('panel-close');
	  clearTimeout(menuTimer);
	  menuTimer = setTimeout(function () {
	    setTimeout(function () {
	      menuCollapse.classList.remove('panel-close');
	    }, 200);
	  }, menuSpeed / 3);
	}

	overlayOutsideClose(menuOverlay, '#menu-overlay.panel-open ul', nishikiMenuOverlayClose);
	overlayOutsideClose(menuCollapseOverlay, '#menu-collapse.panel-open ul', nishikiMenuCollapseOverlayClose);
	overlayOutsideClose(searchOverlay, '#search-overlay.panel-open form', nishikiSearchOverlayClose);

	function nishikiProMenu() {
	  var menuItems = document.querySelectorAll('.menu-items');

	  if (!!menuItems) {
	    menuItems.forEach(function (menu, i) {
	      var menuItemsAnchor = menu.querySelectorAll('a[href^="#"]');
	      menuItemsAnchor.forEach(function (anchor, j) {
	        anchor.addEventListener('click', function () {
	          var parent = anchor.parentNode;
	          var panel = menu.parentNode.parentNode;

	          if (!!panel.classList.contains('panel-open')) {
	            if (!!parent.classList.contains('anchor')) {
	              panel.classList.remove('panel-open');
	              panel.classList.add('panel-close');
	              var menuAnchorTimer = null;
	              clearTimeout(menuAnchorTimer);
	              menuAnchorTimer = setTimeout(function () {
	                setTimeout(function () {
	                  panel.classList.remove('panel-close');
	                }, 200);
	              }, menuSpeed / 3);
	            }
	          }
	        });
	      });
	    });
	  }
	}

	function nishikiProMenuOverlayClick() {
	  if (!!menuOverlay) {
	    var menuLink = menuOverlay.querySelectorAll('a');

	    if (!!menuLink) {
	      menuLink.forEach(function (link, i) {
	        link.addEventListener('click', function (event) {
	          var parent = this.parentElement;
	          var sibling = this.nextElementSibling;
	          menuOverlay.querySelectorAll('ul li').forEach(function (li, j) {
	            li.classList.remove('animation-flash');
	          });
	          setTimeout(function () {
	            parent.classList.add('animation-flash');
	          }, 10);

	          if (parent.classList.contains('menu-item-has-children')) {
	            event.preventDefault();
	            sibling.classList.toggle('show');
	          }

	          clearTimeout(menuTimer);
	          menuTimer = setTimeout(function () {
	            setTimeout(function () {
	              parent.classList.toggle('menu-item-selected');
	            }, 10);
	          }, 10);
	        });
	      });
	    }
	  }
	}

	function nishikiMenuOverlayOpen() {
	  if (!!menuOverlay) {
	    menuOverlay.classList.add('panel-open');
	  }
	}

	function nishikiMenuOverlayClose() {
	  if (!!menuOverlay) {
	    menuOverlay.classList.remove('panel-open');
	    menuOverlay.classList.add('panel-close');
	    clearTimeout(menuTimer);
	    menuTimer = setTimeout(function () {
	      setTimeout(function () {
	        menuOverlay.classList.remove('panel-close');
	      }, 200);
	    }, menuSpeed / 3);
	  }
	}

	function nishikiProMenuCollapse() {
	  if (!!menuCollapse) {
	    var menuCollapseLink = menuCollapse.querySelectorAll('a');

	    if (!!menuCollapseLink && menuCollapse.dataset.navOpenType === 'click') {
	      menuCollapseLink.forEach(function (link, i) {
	        link.addEventListener('click', function (event) {
	          var parent = this.parentElement;
	          var sibling = this.nextElementSibling;
	          menuCollapse.querySelectorAll('ul li').forEach(function (li, j) {
	            li.classList.remove('animation-flash');
	          });
	          setTimeout(function () {
	            parent.classList.add('animation-flash');
	          }, 10);

	          if (parent.classList.contains('menu-item-has-children')) {
	            event.preventDefault();

	            if (this.dataset.depth === '0' && !menuCollapse.classList.contains('mobile')) {
	              if (parent.classList.contains('menu-item-selected') === false) {
	                menuCollapse.querySelectorAll('ul li').forEach(function (li, k) {
	                  li.classList.remove('menu-item-selected');
	                });
	                menuCollapse.querySelectorAll('.sub-menu').forEach(function (subMenu, l) {
	                  subMenu.classList.remove('show');
	                });
	              }
	            }

	            sibling.classList.toggle('show');
	          }

	          clearTimeout(menuTimer);
	          menuTimer = setTimeout(function () {
	            setTimeout(function () {
	              parent.classList.toggle('menu-item-selected');
	            }, 10);
	          }, 10);
	        });
	      });
	    }

	    if (!!menuCollapseLink && menuCollapse.dataset.navOpenType === 'hover') {
	      var menuCollapseArrow = menuCollapse.querySelectorAll('.arrow');
	      menuCollapseArrow.forEach(function (link, i) {
	        link.addEventListener('click', function (event) {
	          var parent = this.parentElement;
	          var sibling = this.nextElementSibling;
	          menuCollapse.querySelectorAll('ul li').forEach(function (li, j) {
	            li.classList.remove('animation-flash');
	          });
	          setTimeout(function () {
	            parent.classList.add('animation-flash');
	          }, 10);

	          if (parent.classList.contains('menu-item-has-children')) {
	            event.preventDefault();

	            if (this.dataset.depth === '0' && !menuCollapse.classList.contains('mobile')) {
	              if (parent.classList.contains('menu-item-selected') === false) {
	                menuCollapse.querySelectorAll('ul li').forEach(function (li, k) {
	                  li.classList.remove('menu-item-selected');
	                });
	                menuCollapse.querySelectorAll('.sub-menu').forEach(function (subMenu, l) {
	                  subMenu.classList.remove('show');
	                });
	              }
	            }

	            sibling.classList.toggle('show');
	          }

	          clearTimeout(menuTimer);
	          menuTimer = setTimeout(function () {
	            setTimeout(function () {
	              parent.classList.toggle('menu-item-selected');
	            }, 10);
	          }, 10);
	        });
	      });
	    }
	  }
	}

	function nishikiProResizeX() {
	  return window.innerWidth;
	}

	var mobileSize = 781;

	if (!!menuCollapse) {
	  mobileSize = menuCollapse.dataset.drawerWidth;
	}

	function nishikiProMenuAddClass() {
	  if (!!menuCollapse) {
	    var resizeX = nishikiProResizeX();

	    if (resizeX > mobileSize) {
	      if (menuCollapse.classList.contains('mobile')) {
	        var allSubMenuItems = document.querySelectorAll('.menu-items .sub-menu');
	        allSubMenuItems.forEach(function (subMenu, i) {
	          subMenu.classList.remove('show');
	          subMenu.parentNode.classList.remove('menu-item-selected');
	        });
	        menuCollapse.classList.remove('mobile');
	      }

	      if (menuCollapse.classList.contains('panel-open')) {
	        menuCollapse.classList.remove('panel-open');
	      }
	    } else {
	      if (menuCollapse.classList.contains('mobile') === false) {
	        menuCollapse.classList.add('mobile');
	      }
	    }
	  }
	}

	function nishikiProMenuResize() {
	  if (!!menuCollapse) {
	    clearTimeout(menuTimer);
	    menuTimer = setTimeout(function () {
	      setTimeout(function () {
	        nishikiProMenuAddClass();
	      }, 200);
	    }, menuSpeed / 5);
	  }
	}

	function nishikiProGetScrollHeight(scrollHeight) {
	  var e = window.pageYOffset || document.documentElement.scrollTop;

	  if (e > scrollHeight) {
	    document.body.classList.add('scrolled');
	  } else {
	    document.body.classList.remove('scrolled');
	  }
	}

	function nishikiProHeaderOverlayScrolled() {
	  var html = document.documentElement;
	  var masthead = document.getElementById('masthead');
	  var resizeSpeed = 50;
	  var scrollHeight = 100;

	  if (!!masthead) {
	    if (masthead.classList.contains('header-overlay-sticky') || html.clientWidth < mobileSize && masthead.classList.contains('sticky-mobile')) {
	      clearTimeout(menuTimer);
	      menuTimer = setTimeout(function () {
	        nishikiProGetScrollHeight(scrollHeight);
	      }, resizeSpeed);
	    }
	  }
	}

	function _typeof(obj) {
	  "@babel/helpers - typeof";

	  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
	    _typeof = function (obj) {
	      return typeof obj;
	    };
	  } else {
	    _typeof = function (obj) {
	      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
	    };
	  }

	  return _typeof(obj);
	}

	function _classCallCheck(instance, Constructor) {
	  if (!(instance instanceof Constructor)) {
	    throw new TypeError("Cannot call a class as a function");
	  }
	}

	function _defineProperties(target, props) {
	  for (var i = 0; i < props.length; i++) {
	    var descriptor = props[i];
	    descriptor.enumerable = descriptor.enumerable || false;
	    descriptor.configurable = true;
	    if ("value" in descriptor) descriptor.writable = true;
	    Object.defineProperty(target, descriptor.key, descriptor);
	  }
	}

	function _createClass(Constructor, protoProps, staticProps) {
	  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
	  if (staticProps) _defineProperties(Constructor, staticProps);
	  return Constructor;
	}

	var getHeaderHeight = nishikiProGetHeaderHeight();

	function nishikiProSmoothScroll() {
	  (function (window, undefined$1, getHeaderHeight) {

	    var heightFixedHeader = getHeaderHeight,
	        href;
	    var speed = 300,
	        movingFrequency = 10,
	        links = document.querySelectorAll('a:not(.noscroll)');
	    var getUrl = window.location;
	    var baseUrl = getUrl.protocol + '//' + getUrl.host + '/' + getUrl.pathname.split('/')[1] + '/';

	    for (var i = 0; i < links.length; i++) {
	      href = links[i].attributes.href === undefined$1 ? null : links[i].attributes.href.nodeValue.toString();
	      var scrollFlag = false;

	      if (href !== null) {
	        var targetUrl = href.substring(0, href.indexOf('#'));

	        if (baseUrl === targetUrl || !targetUrl) {
	          scrollFlag = true;
	        }
	      }

	      if (href !== null && href.length > 1 && href.indexOf('#') !== -1 && scrollFlag === true) {
	        links[i].onclick = function () {
	          var element,
	              href = this.attributes.href.nodeValue.toString(),
	              url = href.substring(0, href.indexOf('#')),
	              id = href.substring(href.indexOf('#') + 1);

	          if (element = document.getElementById(id)) {
	            var _ret = function () {
	              var hopCount = (speed - speed % movingFrequency) / movingFrequency,
	                  getScrollTopDocumentAtBegin = getScrollTopDocument(),
	                  gap = (getScrollTopElement(element) - getScrollTopDocumentAtBegin) / hopCount;
	              if (window.history && typeof window.history.pushState === 'function') window.history.pushState({}, undefined$1, url + '#' + id);

	              var _loop = function _loop(j) {
	                (function () {
	                  var hopTopPosition = gap * j;
	                  setTimeout(function () {
	                    window.scrollTo(0, hopTopPosition + getScrollTopDocumentAtBegin);
	                  }, movingFrequency * j);
	                })();
	              };

	              for (var j = 1; j <= hopCount; j++) {
	                _loop(j);
	              }

	              return {
	                v: false
	              };
	            }();

	            if (_typeof(_ret) === "object") return _ret.v;
	          }
	        };
	      }
	    }

	    var getScrollTopElement = function getScrollTopElement(e) {
	      var top = heightFixedHeader * -1;

	      while (e.offsetParent !== undefined$1 && e.offsetParent !== null) {
	        top += e.offsetTop + (e.clientTop !== null ? e.clientTop : 0);
	        e = e.offsetParent;
	      }

	      return top;
	    };

	    var getScrollTopDocument = function getScrollTopDocument() {
	      return window.pageYOffset !== undefined$1 ? window.pageYOffset : document.documentElement.scrollTop !== undefined$1 ? document.documentElement.scrollTop : document.body.scrollTop;
	    };
	  })(window, undefined, getHeaderHeight);
	}

	function nishikiProSidebar() {
	  var content = document.getElementsByClassName('content')[0];
	  var sidebars = document.querySelectorAll('.sidebar');
	  var headerHeight = nishikiProGetHeaderHeight();
	  sidebars.forEach(function (sidebar, i) {
	    if (sidebar.classList.contains('sidebar-sticky')) {
	      var sidebarSticky = document.querySelector('.sidebar-sticky');
	      var stickyMargin = 3;

	      if (!!masthead && masthead.classList.contains('sticky')) {
	        headerHeight = masthead.clientHeight;
	      }

	      if (content.classList.contains('sidebar-left') || content.classList.contains('sidebar-right')) {
	        sidebarSticky.style.top = 'calc(' + headerHeight + 'px + ' + stickyMargin + 'rem' + ')';
	      }
	    }
	  });
	}

	function nishikiBlocksProAnimation() {
	  var selector = '.wp-block-nishiki-blocks-pro-animation';
	  var animations = [].slice.call(document.querySelectorAll(selector));

	  if ('IntersectionObserver' in window) {
	    var lazyImageObserver = new IntersectionObserver(function (entries, observer) {
	      entries.forEach(function (entry) {
	        if (entry.isIntersecting) {
	          entry.target.classList.add('animation-loaded');

	          if (entry.target.classList.contains('animation-loop') === false) {
	            lazyImageObserver.unobserve(entry.target);
	          }
	        }
	      });
	    });
	    animations.forEach(function (animation) {
	      lazyImageObserver.observe(animation);
	    });
	  }
	}

	function nishikiBlocksProTabs() {
	  var tabs = document.querySelectorAll('[class^="wp-block-nishiki-blocks-pro-tabs"]');

	  if (!!tabs) {
	    tabs.forEach(function (tab, i) {
	      var tabButtons = tab.querySelectorAll('button');
	      var tabNum = i + 1;
	      tabButtons.forEach(function (tabButton, tabButtonIndex) {
	        var tabId = 'nishiki-blocks-pro-tab-' + tabNum + '-' + (tabButtonIndex + 1);
	        tabButton.setAttribute('id', tabId);
	        var tabContents = tab.querySelectorAll('.tab-content');

	        if (!!tabContents) {
	          tabContents.forEach(function (tabContent, j) {
	            tabContent.setAttribute('id', 'tab-content-' + (j + 1));
	            tabContent.setAttribute('aria-labelledby', 'nishiki-blocks-pro-tab-' + tabNum + '-' + (j + 1));
	          });
	        }

	        tabButton.addEventListener('click', function (e) {
	          e.preventDefault();
	          tabButtons.forEach(function (tabButton, k) {
	            if (tabButton.classList.contains('active')) {
	              tabButton.classList.remove('active');
	              tabButton.setAttribute('aria-selected', 'false');
	              tabButton.setAttribute('tabindex', -1);
	            }
	          });
	          var index = [].slice.call(tabButtons).indexOf(tabButton);
	          tabButton.classList.add('active');
	          tabButton.setAttribute('aria-selected', 'true');
	          tabButton.setAttribute('tabindex', 0);
	          var tabContents = this.parentNode.nextElementSibling.querySelectorAll('.tab-content');

	          if (!!tabContents) {
	            tabContents.forEach(function (tabContent, l) {
	              if (tabContent.classList.contains('active')) {
	                tabContent.classList.remove('active');
	                tabContent.setAttribute('hidden', true);
	              }
	            });
	            tabContents[index].classList.add('active');
	            tabContents[index].removeAttribute('hidden');
	          }
	        }, false);
	      });
	    });
	  }
	}

	function nishikiProScrollTopButton() {
	  var button = document.getElementById('scroll-page-top');

	  if (!!button) {
	    window.addEventListener('scroll', function () {
	      var e = window.pageYOffset || document.documentElement.scrollTop;
	      setTimeout(function () {
	        if (e > 100) {
	          button.classList.add('show');
	        } else {
	          button.classList.remove('show');
	        }
	      }, 100);
	    }, false);
	  }
	}

	function nishikiBlocksProCountDown() {
	  var selector = document.querySelectorAll('.wp-block-nishiki-blocks-pro-countdown');

	  if (!!selector) {
	    selector.forEach(function (data, i) {
	      startCountdown(data);
	    });
	  }
	}

	function startCountdown(data) {
	  var countDownDate = data.dataset.nishikiBlocksProCountdownDate;
	  var countDownDayRemain = data.dataset.nishikiBlocksProCountdownDayRemain;
	  var daysData = data.querySelector('.days');
	  var hoursData = data.querySelector('.hours');
	  var minutesData = data.querySelector('.minutes');
	  var secondsData = data.querySelector('.seconds');
	  var countTo = new Date(countDownDate).getTime();
	  setInterval(function () {
	    var now = new Date().getTime();
	    var distance = countTo - now;
	    var days = '--';
	    var hours = '--';
	    var minutes = '--';
	    var seconds = '--';

	    if (distance > 0) {
	      days = zeroPadding(Math.floor(distance / (1000 * 60 * 60 * 24)));
	      hours = zeroPadding(Math.floor(distance % (1000 * 60 * 60 * 24) / (1000 * 60 * 60)));
	      minutes = zeroPadding(Math.floor(distance % (1000 * 60 * 60) / (1000 * 60)));
	      seconds = zeroPadding(Math.floor(distance % (1000 * 60) / 1000));
	    }

	    if (!!daysData) {
	      daysData.querySelector('.num').innerText = days;

	      if (!!daysData.querySelector('.timer__path-remaining')) {
	        var strokeDays = (days / countDownDayRemain * 283).toFixed(0);
	        daysData.querySelector('.timer__path-remaining').setAttribute('stroke-dasharray', strokeDays + ' 283');
	      }
	    }

	    if (!!hoursData) {
	      hoursData.querySelector('.num').innerText = hours;

	      if (!!hoursData.querySelector('.timer__path-remaining')) {
	        var strokeHours = (hours / 60 * 283).toFixed(0);
	        hoursData.querySelector('.timer__path-remaining').setAttribute('stroke-dasharray', strokeHours + ' 283');
	      }
	    }

	    if (!!minutesData) {
	      minutesData.querySelector('.num').innerText = minutes;

	      if (!!minutesData.querySelector('.timer__path-remaining')) {
	        var strokeMinutes = (minutes / 60 * 283).toFixed(0);
	        minutesData.querySelector('.timer__path-remaining').setAttribute('stroke-dasharray', strokeMinutes + ' 283');
	      }
	    }

	    if (!!secondsData) {
	      secondsData.querySelector('.num').innerText = seconds;
	      var strokeSeconds = (seconds / 60 * 283).toFixed(0);

	      if (secondsData.querySelector('.timer__path-remaining')) {
	        secondsData.querySelector('.timer__path-remaining').setAttribute('stroke-dasharray', strokeSeconds + ' 283');
	      }
	    }
	  }, 1000);
	}

	function zeroPadding(data) {
	  var len = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 2;

	  if (String(data).length < 3) {
	    return (Array(len).join('0') + data).slice(-len);
	  }

	  return data;
	}

	function nishikiProCopyURL() {
	  var copyButton = document.querySelectorAll('[data-copy-button]');

	  if (!!copyButton) {
	    copyButton.forEach(function (button, i) {
	      button.onclick = function () {
	        navigator.clipboard.writeText(window.location.href);

	        if (this.classList.contains !== 'disabled') {
	          this.classList.add('disabled');
	          setTimeout(function () {
	            button.classList.remove('disabled');
	          }, 2000, button);
	        }
	      };
	    });
	  }
	}

	function nishikiProInit() {
	  nishikiProMenuAddClass();
	  nishikiProHeaderOverlayScrolled();
	  nishikiRegisterListener('load', nishikiProMenu);
	  nishikiRegisterListener('load', nishikiProMenuCollapse);
	  nishikiRegisterListener('load', nishikiProMenuOverlayClick);
	  nishikiProSmoothScroll();
	  nishikiProSidebar();
	  nishikiBlocksProAnimation();
	  nishikiBlocksProTabs();
	  nishikiBlocksProCountDown();
	  nishikiProScrollTopButton();
	  nishikiProCopyURL();
	}

	var ResizeTimer;
	var interval = Math.floor(1000 / 60 * 10);
	var deviceSize = {
	  desktop: 1000,
	  tablet: 781,
	  smartphone: 480
	};

	function nishikiBlocksProSectionDivider() {
	  if (ResizeTimer !== false) {
	    clearTimeout(ResizeTimer);
	  }

	  ResizeTimer = setTimeout(function () {
	    var dividers = document.querySelectorAll('.wp-block-nishiki-blocks-pro-section .divider');

	    if (!!dividers) {
	      for (var i = 0; dividers.length - 1 >= i; ++i) {
	        if (dividers[i].dataset.responsive) {
	          var dividerArray = JSON.parse(dividers[i].dataset.responsive);
	          var resizeX = document.documentElement.clientWidth;

	          if (resizeX >= deviceSize.tablet) {
	            dividers[i].style.height = dividerArray.desktop + 'px';
	          }

	          if (resizeX < deviceSize.tablet && resizeX >= deviceSize.smartphone) {
	            dividers[i].style.height = dividerArray.tablet + 'px';
	          }

	          if (resizeX < deviceSize.smartphone) {
	            dividers[i].style.height = dividerArray.smartphone + 'px';
	          }
	        }
	      }
	    }
	  }, interval);
	}

	function nishikiProInView(el) {
	  var rect = el.getBoundingClientRect();
	  return rect.bottom >= 0 && rect.right >= 0 && rect.top <= (window.innerHeight || document.documentElement.clientHeight) && rect.left <= (window.innerWidth || document.documentElement.clientWidth);
	}

	function nishikiProImgLoader(parent, img) {
	  parent.appendChild(img);
	  img.classList.add('imgloaded');
	}

	var lazySpeed = 1000;
	var lazyTimer = null;

	function nishikiProLazyLoad() {
	  clearTimeout(lazyTimer);
	  lazyTimer = setTimeout(function () {
	    setTimeout(function () {
	      var getcontent = document.getElementById('main');

	      if (getcontent) {
	        var lazy = getcontent.getElementsByTagName('section');

	        for (var i = 0; i < lazy.length; i++) {
	          if (nishikiProInView(lazy[i]) && lazy[i].classList.contains('imgloaded') === false) {
	            if (lazy[i].classList.contains('has-header-image') || lazy[i].classList.contains('main-video')) {
	              var mainImg = lazy[i].querySelector('.header-image');

	              if (mainImg) {
	                if (mainImg.hasAttribute('data-src') === true) {
	                  mainImg.src = mainImg.getAttribute('data-src');
	                  mainImg.removeAttribute('data-src');
	                }

	                if (lazy[i].hasAttribute('data-srcset') === true) {
	                  mainImg.srcset = lazy[i].getAttribute('data-srcset');
	                  mainImg.removeAttribute('data-srcset');
	                }

	                mainImg.classList.add('imgloaded');
	              }
	            } else if (lazy[i].hasAttribute('data-src') === true) {
	              lazy[i].classList.add('imgloaded');
	              var imglarge = new Image();
	              imglarge.src = lazy[i].getAttribute('data-src');
	              imglarge.alt = lazy[i].getAttribute('data-alt');
	              imglarge.onload = nishikiProImgLoader(lazy[i], imglarge);
	            }
	          }
	        }
	      }
	    }, 100);
	  }, lazySpeed / 3);
	}

	function nishikiProDarkMode() {
	  var toggleSwitch = document.querySelector('.theme-switch input[type="checkbox"]');
	  var currentTheme = localStorage.getItem('theme');

	  if (toggleSwitch) {
	    var switchTheme = function switchTheme(e) {
	      if (e.target.checked) {
	        document.body.setAttribute('data-theme', 'dark');
	        localStorage.setItem('theme', 'dark');
	      } else {
	        document.body.setAttribute('data-theme', 'light');
	        localStorage.setItem('theme', 'light');
	      }
	    };

	    if (currentTheme) {
	      document.body.setAttribute('data-theme', currentTheme);

	      if (currentTheme === 'dark') {
	        toggleSwitch.checked = true;
	      }
	    }

	    toggleSwitch.addEventListener('change', switchTheme, false);
	  }
	}

	var tocContent = document.getElementById('nishiki-pro-toc-content');
	var tocFixedButton = document.getElementById('toc-fixed-button');
	var tocTimer = null;
	var tocSpeed = 300;

	function nishikiProTOC() {
	  var selectedArray = [];
	  selectedArray.length = 0;
	  var bodyRect = document.body.getBoundingClientRect();
	  var articlechapters = document.querySelectorAll('article [data-nishiki-pro-toc-anchor]');
	  articlechapters.forEach(function (value, i) {
	    var valueRect = value.getBoundingClientRect();
	    var chapterHeight = valueRect.top - bodyRect.top;
	    selectedArray[i] = chapterHeight;
	  });

	  if (document.getElementById('nishiki-toc-fixed')) {
	    var nishikiProTocFixedInterval = null;
	    var tocFixedNav = document.getElementById('nishiki-toc-fixed');
	    var tocFixedNavHeight = tocFixedNav.offsetHeight;
	    var tocFixedOverlay = document.getElementById('toc-fixed-overlay');
	    var tocCurrent = document.getElementById('toc-current');
	    window.addEventListener('scroll', function () {
	      if (tocCurrent) {
	        if (nishikiProTocFixedInterval) {
	          clearTimeout(nishikiProTocFixedInterval);
	        }

	        nishikiProTocFixedInterval = setTimeout(function () {
	          chapterbg(tocCurrent, selectedArray, tocFixedNav, tocFixedOverlay, tocFixedNavHeight);
	          nishikiProTocFixedInterval = null;
	        }, 100);
	      }
	    }, false);
	  }

	  var tocToggle = document.getElementById('nishiki-pro-toc-close-toggle');

	  if (!!tocContent) {
	    var tocTogglePanel = tocContent.querySelectorAll('ul')[0];
	  }

	  var tocEntryContent = document.getElementById('nishiki-pro-toc-content');

	  if (!!tocToggle && !!tocTogglePanel) {
	    tocToggle.addEventListener('click', function () {
	      tocEntryContent.classList.toggle('toc-hidden');
	    }, false);
	  }
	}

	function chapterbg(element, selectedArray, tocFixedNav, tocFixedOverlay, tocFixedNavHeight) {
	  var scrolly = window.pageYOffset || document.body.scrollTop;
	  var fixedFlag = false;
	  var getToc = document.querySelector('article > .entry-content') !== null;
	  var anchorMargin = 5;
	  var tocInterval = 3;

	  if (getToc) {
	    var inviewButton = document.querySelector('article > .entry-content');
	    var inviewEnd = inviewButton.getBoundingClientRect().bottom;

	    for (var i = selectedArray.length - 1; i >= 0; --i) {
	      if (scrolly > selectedArray[i] - tocFixedNavHeight - anchorMargin) {
	        fixedFlag = true;
	        chapters = document.querySelectorAll('#toc-fixed-list li a');

	        if (element.innerHTML !== chapters[i].text) {
	          element.innerHTML = chapters[i].text;
	        }

	        break;
	      } else {
	        fixedFlag = false;
	      }
	    }

	    if (fixedFlag && inviewEnd - tocFixedNavHeight - anchorMargin > 0) {
	      tocFixedNav.classList.add('show');
	    } else if (tocFixedNav.classList.contains('show')) {
	      tocFixedNav.classList.remove('show');
	      tocFixedOverlay.classList.remove('panel-open');
	      tocFixedNav.classList.add('closing');
	      clearTimeout(tocTimer);
	      tocTimer = setTimeout(function () {
	        setTimeout(function () {
	          tocFixedNav.classList.remove('closing');
	        }, 200);
	      }, tocSpeed / tocInterval);
	    }
	  }

	  if (!!tocFixedButton) {
	    tocFixedButton.addEventListener('click', function () {
	      nishikiTocFixedOverlayOpen();
	    }, false);
	  }

	  function nishikiTocFixedOverlayOpen() {
	    tocFixedOverlay.classList.add('panel-open');
	  }

	  function nishikiTocFixedOverlayClose() {
	    tocFixedOverlay.classList.remove('panel-open');
	    tocFixedOverlay.classList.add('panel-close');
	    clearTimeout(tocTimer);
	    tocTimer = setTimeout(function () {
	      setTimeout(function () {
	        tocFixedOverlay.classList.remove('panel-close');
	      }, 200);
	    }, tocSpeed / tocInterval);
	  }

	  var chapters = document.querySelectorAll('#toc-fixed-list li a');

	  if (chapters) {
	    for (var j = 0; chapters.length - 1 >= j; ++j) {
	      chapters[j].addEventListener('click', function () {
	        nishikiTocFixedOverlayClose();
	      }, false);
	    }
	  }

	  overlayOutsideClose(tocFixedOverlay, '#toc-fixed-list', nishikiTocFixedOverlayClose);
	}

	function nishikiBlocksProSlider() {
	  var slides = document.querySelectorAll('[class*=wp-block-nishiki-blocks-pro-slider], .wp-block-nishiki-blocks-pro-posts.is-slider');

	  if (!!slides) {
	    for (var i = 0; slides.length - 1 >= i; ++i) {
	      if (slides[i].dataset.nishikiBlocksProSlider) {
	        (function () {
	          var data = JSON.parse(slides[i].dataset.nishikiBlocksProSlider);
	          var args = {
	            direction: data.direction,
	            overflow: 'auto',
	            lazy: true
	          };

	          if (typeof data.allowTouchMove !== "undefined") {
	            args.allowTouchMove = false;
	          }

	          if (!!data.speed) {
	            args.speed = data.speed;
	          }

	          if (!!data.pagination) {
	            args.pagination = data.pagination;
	          }

	          if (!!data.spaceBetween) {
	            args.spaceBetween = data.spaceBetween;
	          }

	          if (!!data.autoplay) {
	            args.autoplay = data.autoplay;
	          }

	          if (!!data.effect) {
	            args.effect = data.effect;
	          }

	          if (!!data.cubeEffect) {
	            args.cubeEffect = data.cubeEffect;
	          }

	          if (!!data.flipEffect) {
	            args.flipEffect = data.flipEffect;
	          }

	          if (!!data.fadeEffect) {
	            args.fadeEffect = data.fadeEffect;
	          }

	          if (!!data.coverflowEffect) {
	            args.coverflowEffect = data.coverflowEffect;
	          }

	          if (!!data.scrollbar) {
	            args.scrollbar = data.scrollbar;
	          }

	          if (!!data.slidesPerView) {
	            args.slidesPerView = data.slidesPerView;
	          }

	          if (!!data.slidesPerGroup) {
	            args.slidesPerGroup = data.slidesPerGroup;
	          }

	          if (!!data.loop) {
	            args.loop = data.loop;
	          }

	          if (!!data.navigation) {
	            args.navigation = data.navigation;
	          }

	          if (!!data.centeredSlides) {
	            args.centeredSlides = data.centeredSlides;
	          }

	          if (!!data.breakpoints) {
	            args.breakpoints = data.breakpoints;
	          }

	          var swiperInstance = new Swiper('#' + slides[i].id, args);

	          if (!!data.autoplay && !!data.autoplay.autoplayStopButton) {
	            var autoPlayStopButton = slides[i].querySelector('.swiper-autoplay-stop-button button');
	            var isAutoplayRunning = true;
	            autoPlayStopButton.addEventListener('touchstart', function (e) {
	              e.stopPropagation();
	            }, {
	              passive: false
	            });
	            autoPlayStopButton.addEventListener('touchmove', function (e) {
	              e.stopPropagation();
	            }, {
	              passive: false
	            });
	            autoPlayStopButton.addEventListener('touchend', function (e) {
	              e.stopPropagation();
	            }, {
	              passive: false
	            });
	            autoPlayStopButton.addEventListener('mousedown', function (e) {
	              e.stopPropagation();
	            });
	            autoPlayStopButton.addEventListener('mousemove', function (e) {
	              e.stopPropagation();
	            });
	            autoPlayStopButton.addEventListener('mouseup', function (e) {
	              e.stopPropagation();
	            });
	            autoPlayStopButton.innerHTML = '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="512" height="512" viewBox="0 0 512 512"><path d="M64 64h160v384h-160zM288 64h160v384h-160z"></path></svg>';
	            autoPlayStopButton.classList.add('is-playing');
	            autoPlayStopButton.classList.remove('is-stopped');
	            autoPlayStopButton.addEventListener("click", function (e) {
	              e.stopPropagation();

	              if (isAutoplayRunning) {
	                swiperInstance.autoplay.stop();
	                isAutoplayRunning = false;
	                autoPlayStopButton.innerHTML = '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="512" height="512" viewBox="0 0 512 512"><path d="M96 64l320 192-320 192z"></path></svg>';
	                autoPlayStopButton.classList.add('is-stopped');
	                autoPlayStopButton.classList.remove('is-playing');
	                autoPlayStopButton.setAttribute('aria-label', 'スライダーの自動再生を開始');
	              } else {
	                swiperInstance.autoplay.start();
	                isAutoplayRunning = true;
	                autoPlayStopButton.innerHTML = '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="512" height="512" viewBox="0 0 512 512"><path d="M64 64h160v384h-160zM288 64h160v384h-160z"></path></svg>';
	                autoPlayStopButton.classList.add('is-playing');
	                autoPlayStopButton.classList.remove('is-stopped');
	                autoPlayStopButton.setAttribute('aria-label', 'スライダーの自動再生を停止');
	              }
	            });
	          }

	          var paginationColor = slides[i].querySelector('.swiper-pagination');

	          if (!!paginationColor) {
	            if (!!paginationColor.getAttribute('data-nishiki-blocks-pro-slider-pagination-color')) {
	              var dataPaginationColor = paginationColor.dataset.nishikiBlocksProSliderPaginationColor;

	              if (!!dataPaginationColor) {
	                if (data.pagination.type === 'progressbar') {
	                  var progressbar = paginationColor.querySelectorAll('.swiper-pagination-progressbar-fill');
	                  paginationColor.style.background = 'rgba(' + hex2rgb(dataPaginationColor) + ', 0.25 )';

	                  if (!!progressbar) {
	                    for (var k = 0; progressbar.length - 1 >= k; ++k) {
	                      progressbar[k].style.background = dataPaginationColor;
	                    }
	                  }
	                }

	                if (data.pagination.type === 'fraction') {
	                  paginationColor.style.color = dataPaginationColor;
	                }
	              }
	            }
	          }

	          var scrollbarColor = slides[i].querySelector('.swiper-scrollbar');

	          if (!!scrollbarColor) {
	            var dataScrollbarColor = scrollbarColor.dataset.nishikiBlocksProSliderScrollbarColor;

	            if (!!dataScrollbarColor) {
	              scrollbarColor.style.background = 'rgba(' + hex2rgb(dataScrollbarColor) + ', 0.25 )';
	              var scrollbar = scrollbarColor.querySelector('div');

	              if (!!scrollbar) {
	                scrollbar.style.background = dataScrollbarColor;
	              }
	            }
	          }

	          var navigationColor = slides[i].querySelector('.swiper-navigation');

	          if (!!navigationColor) {
	            var dataNavigationColor = navigationColor.dataset.nishikiBlocksProSliderNavigationColor;

	            if (!!dataNavigationColor) {
	              navigationColor.style.color = dataNavigationColor;
	            }
	          }
	        })();
	      }
	    }
	  }
	}

	function hex2rgb(hex) {
	  if (hex.slice(0, 1) === '#') hex = hex.slice(1);
	  if (hex.length === 3) hex = hex.slice(0, 1) + hex.slice(0, 1) + hex.slice(1, 2) + hex.slice(1, 2) + hex.slice(2, 3) + hex.slice(2, 3);
	  return [hex.slice(0, 2), hex.slice(2, 4), hex.slice(4, 6)].map(function (str) {
	    return parseInt(str, 16);
	  });
	}

	var nishikiBlocksProAccordion = function () {
	  function nishikiBlocksProAccordion(el) {
	    var _this = this;

	    _classCallCheck(this, nishikiBlocksProAccordion);

	    this.el = el;
	    this.summary = el.querySelector('summary');
	    this.content = el.querySelector('.wp-block-nishiki-blocks-pro-accordion-content');
	    this.animation = false;
	    this.isClosing = false;
	    this.isExpanding = false;
	    this.summary.addEventListener('click', function (e) {
	      return _this.onClick(e);
	    });
	  }

	  _createClass(nishikiBlocksProAccordion, [{
	    key: "onClick",
	    value: function onClick(e) {
	      e.preventDefault();
	      this.el.style.overflow = 'hidden';

	      if (this.isClosing || !this.el.open) {
	        this.open();
	      } else if (this.isExpanding || this.el.open) {
	        this.shrink();
	      }
	    }
	  }, {
	    key: "shrink",
	    value: function shrink() {
	      var _this2 = this;

	      this.isClosing = true;
	      var startHeight = "".concat(this.el.offsetHeight, "px");
	      var endHeight = "".concat(this.summary.offsetHeight, "px");

	      if (this.animation) {
	        this.animation.cancel();
	      }

	      this.animation = this.el.animate({
	        height: [startHeight, endHeight]
	      }, {
	        duration: 400,
	        easing: 'ease-out'
	      });

	      this.animation.onfinish = function () {
	        return _this2.onAnimationFinish(false);
	      };

	      this.animation.oncancel = function () {
	        return _this2.isClosing = false;
	      };
	    }
	  }, {
	    key: "open",
	    value: function open() {
	      var _this3 = this;

	      this.el.style.height = "".concat(this.el.offsetHeight, "px");
	      this.el.open = true;
	      window.requestAnimationFrame(function () {
	        return _this3.expand();
	      });
	    }
	  }, {
	    key: "expand",
	    value: function expand() {
	      var _this4 = this;

	      this.isExpanding = true;
	      var startHeight = "".concat(this.el.offsetHeight, "px");
	      var endHeight = "".concat(this.summary.offsetHeight + this.content.offsetHeight, "px");

	      if (this.animation) {
	        this.animation.cancel();
	      }

	      this.animation = this.el.animate({
	        height: [startHeight, endHeight]
	      }, {
	        duration: 400,
	        easing: 'ease-out'
	      });

	      this.animation.onfinish = function () {
	        return _this4.onAnimationFinish(true);
	      };

	      this.animation.oncancel = function () {
	        return _this4.isExpanding = false;
	      };
	    }
	  }, {
	    key: "onAnimationFinish",
	    value: function onAnimationFinish(open) {
	      this.el.open = open;
	      this.animation = null;
	      this.isClosing = false;
	      this.isExpanding = false;
	      this.el.style.height = this.el.style.overflow = '';
	    }
	  }]);

	  return nishikiBlocksProAccordion;
	}();

	nishikiProInit();
	nishikiProDarkMode();
	nishikiProTOC();
	nishikiRegisterListener('resize', nishikiProMenuResize);
	nishikiRegisterListener('scroll', nishikiProHeaderOverlayScrolled);
	nishikiProLazyLoad();
	nishikiRegisterListener('scroll', nishikiProLazyLoad);
	nishikiBlocksProSectionDivider();
	nishikiRegisterListener('resize', nishikiBlocksProSectionDivider);
	nishikiBlocksProSlider();
	document.querySelectorAll('.wp-block-nishiki-blocks-pro-accordion').forEach(function (el) {
	  new nishikiBlocksProAccordion(el);
	});

}());
