<?php
/**
 * コメントの出力
 *
 * @author     AnimaGate, Inc.
 * @link       https://support.animagate.com/product/wp-nishiki-pro/
 */

if ( post_password_required() ) {
	return;
}
?>

<div id="comments" class="comments-area">

	<?php
	// You can start editing here -- including this comment!
	if ( have_comments() ) :
		?>
		<h2 class="comments-title">
			<?php
			$comments_number = get_comments_number();
			if ( '1' === $comments_number ) {
				/* translators: %s: post title */
				printf( esc_html_x( '%s Comment', 'comments title', 'nishiki-pro' ), wp_kses_post( get_the_title() ) );
			} else {
				printf( // WPCS: XSS OK.
					/* translators: 1: number of comments, 2: post title */
					esc_html(
						_nx(
							'%1$s Comment', // single
							'%1$s Comments', // plural
							$comments_number, // number
							'comments title', // context
							'nishiki-pro'
						)
					),
					esc_html( number_format_i18n( $comments_number ) ),
					wp_kses_post( get_the_title() )
				);
			}
			?>
		</h2>

		<ol class="comment-list">
			<?php
				wp_list_comments(
					array(
						'avatar_size' => 55,
						'style'       => 'ol',
						'short_ping'  => false,
						'reply_text'  => __( 'Reply', 'nishiki-pro' ),
						'callback'    => 'nishiki_pro_comment_template',
					)
				);
			?>
		</ol>

		<?php
		the_comments_pagination(
			array(
				'prev_text' => '<span class="screen-reader-text">' . __( 'Previous', 'nishiki-pro' ) . '</span>',
				'next_text' => '<span class="screen-reader-text">' . __( 'Next', 'nishiki-pro' ) . '</span>',
			)
		);

	endif; // Check for have_comments().

	// If comments are closed and there are comments, let's leave a little note, shall we?
	if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
		?>

		<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'nishiki-pro' ); ?></p>
		<?php
	endif;

	$comment_form_args = array(
		'title_reply_before' => '<p id="reply-title" class="comment-reply-title">',
		'title_reply_after' => '</p>'
	);

	comment_form( $comment_form_args );
	?>

</div><!-- #comments -->
