<?php
/**
 * Block editor init
 *
 * @author     AnimaGate, Inc.
 * @link       https://support.animagate.com/product/wp-nishiki-pro/
 */

/**
 * Assets
 *
 * @return void
 */
function nishiki_blocks_pro_editor_assets() {
	global $pagenow;

	// Scripts.
	$block_dependencies = array(
		'wp-blocks',
		'wp-i18n',
		'wp-element',
		'wp-components',
		'wp-editor',
		'wp-compose',
		'wp-rich-text',
		'wp-data',
		'wp-plugins',
		'wp-hooks',
		'lodash',
	);

	wp_register_script(
		'nishiki-blocks-pro-back-end',
		get_template_directory_uri() . '/extension/block/build/index.js',
		$block_dependencies,
		true, // Enqueue the script in the footer.
		'1.0.0'
	);

	// Back End Only Styles.
	/*
	wp_register_style(
		'nishiki-blocks-pro-back-end',
		get_template_directory_uri() . '/extension/block/build/index.css',
		array(),
		'1.0.0'
	);
	*/

	if ( function_exists( 'register_block_type' ) ) {
		register_block_type(
			'nishiki-blocks-pro/blocks',
			array(
				'editor_script' => 'nishiki-blocks-pro-back-end',
				'editor_style'  => 'nishiki-blocks-pro-back-end',
			)
		);
	}

}

// Hook: Frontend and Editor assets.
add_action( 'init', 'nishiki_blocks_pro_editor_assets' );

// Add Block Category.
if ( ! function_exists( 'nishiki_blocks_pro_categories' ) ) {
	/**
	 * ブロックカテゴリー追加
	 *
	 * @param array $categories Array of categories for block types.
	 */
	function nishiki_blocks_pro_categories( $categories ) {
		array_unshift( $categories, array(
			'slug'  => 'nishiki-blocks-pro-deplecated',
			'title' => __( '非推奨', 'nishiki-pro' )
		) );

		array_unshift( $categories, array(
			'slug'  => 'nishiki-blocks-pro',
			'title' => __( 'Nishiki Blocks Pro', 'nishiki-pro' )
		) );

		return $categories;
		
		/*
		return array_merge(
			$categories,
			array(
				array(
					'slug'  => 'nishiki-blocks-pro',
					'title' => __( 'Nishiki Blocks Pro', 'nishiki' ),
					// 'icon'  => 'grid-view',
				),
			)
		);
		*/
	}
	if ( function_exists( 'get_default_block_categories' ) && function_exists( 'get_block_editor_settings' ) ) {
		add_filter( 'block_categories_all', 'nishiki_blocks_pro_categories', 10, 1 );
	} else {
		add_filter( 'block_categories', 'nishiki_blocks_pro_categories', 10, 1 );
	}
}

/**
 * Remove  "Displays a _doing_it_wrong() message for conflicting widget editor scripts."
 * WordPress5.8
 */
remove_action( 'admin_head', 'wp_check_widget_editor_deps' );
