jQuery(function($) {
	$(function () {
		// Add
		$('.nishiki-pro-add-color').click(function() {
			if( ! confirm( '新しいカラーを追加しますか？' ) ) {
				return false;
			}

			$.ajax({
				url: nishiki_pro_add_color_ajax.ajax_url,
				data: {
					'action': nishiki_pro_add_color_ajax.action,
					'nonce': nishiki_pro_add_color_ajax.nonce
				}
			}).done(function (data) {
				window.location.reload();
			}).fail(function () {
			}).always(function () {
			});
		});

		// Delete
		$('.nishiki-pro-delete-color').click(function() {
			if( ! confirm( 'このカラーを削除しますか？一度削除すると元に戻せません。' ) ) {
				return false;
			}

			$.ajax({
				url: nishiki_pro_delete_color_ajax.ajax_url,
				type: 'post',
				data: {
					'action': nishiki_pro_delete_color_ajax.action,
					'nonce': nishiki_pro_delete_color_ajax.nonce,
					'num': this.getAttribute('data-color-num')
				},
				context: this.getAttribute('data-color-num')
			}).done(function (data) {
				window.location.reload();
			}).fail(function () {
			}).always(function () {
			});
		});

		// Reset
		$('.nishiki-pro-reset-color').click(function() {
			if( ! confirm( 'カラーをリセットしますか？この操作は元に戻せません。' ) ) {
				return false;
			}

			$.ajax({
				url: nishiki_pro_reset_color_ajax.ajax_url,
				data: {
					'action': nishiki_pro_reset_color_ajax.action,
					'nonce': nishiki_pro_reset_color_ajax.nonce
				}
			}).done(function (data) {
				window.location.reload();
			}).fail(function () {
			}).always(function () {
			});
		});


	});
});
