<?php
if ( ! class_exists( 'NISHIKI_PRO_BLOCK_PATTERN_ADMIN' ) ) {
	/**
	 * ブロックパターン管理
	 */
	class NISHIKI_PRO_BLOCK_PATTERN_ADMIN {

		/**
		 * NISHIKI_PRO_BLOCK_PATTERN_ADMIN constructor.
		 */
		public function __construct() {
			// 投稿タイプ追加
			add_action( 'init', array( $this, 'add_post_type' ), 30 );

			// パターン追加
			add_action( 'after_setup_theme', array( $this, 'add_block_patterns' ), 10 );
		}

		/**
		 * 投稿タイプ追加
		 */
		public function add_post_type() {
			register_post_type(
				'nishiki_pro_patterns',
				array(
					'labels'                => array(
						'name'               => 'ブロックパターン',
						'add_new_item'       => 'ブロックパターンを追加',
						'edit_item'          => '編集',
						'new_item'           => '新規作成',
						'attributes'         => '',
						'view_item'          => 'ブロックパターンを表示',
						'search_items'       => '検索',
						'not_found'          => '見つかりませんでした',
						'not_found_in_trash' => 'ゴミ箱にはありません',
						'parent_item_colon'  => '',
					),
					'public'                => false,
					'exclude_from_search'   => true,
					'hierarchical'          => false,
					'publicly_queryable'    => false,
					'show_ui'               => true,
					'show_in_nav_menus'     => false,
					'show_in_menu'          => true,
					'menu_icon'             => 'dashicons-flag',
					'description'           => '',
					'has_archive'           => false,
					'show_in_rest'          => true,
					'rest_base'             => 'nishiki_pro_patterns',
					'rest_controller_class' => 'WP_REST_Posts_Controller',
					'supports'              => array(
						'title',
						'editor',
						'revisions',
					),
				)
			);
		}

		/**
		 * パターン追加
		 *
		 * @return void
		 */
		public function add_block_patterns() {
			// ブロックパターンカテゴリー タクソノミー追加
			register_taxonomy(
				'nishiki_pro_pattern_categories',
				'nishiki_pro_patterns',
				array(
					'labels'                => array(
						'name'         => 'カテゴリー',
						'add_new_item' => 'カテゴリーを追加',
						'edit_item'    => 'カテゴリーの編集',
						'separate_items_with_commas' => 'カテゴリーを複数指定する場合はコンマで区切ってください',
					),
					'hierarchical'          => false,
					'update_count_callback' => '_update_post_term_count',
					'label'                 => 'カテゴリー',
					'singular_label'        => 'カテゴリー',
					'public'                => false,
					'show_ui'               => true,
					'show_in_rest'          => true,
				)
			);

			// ブロックパターン追加
			$args = array(
				'post_type'      => array( 'nishiki_pro_patterns' ),
				'post_status'    => array( 'publish' ),
				'posts_per_page' => -1,
			);

			$the_query = new WP_Query( $args );

			if ( $the_query->have_posts() ) {

				while ( $the_query->have_posts() ) {
					$the_query->the_post();

					// タイトル
					$pattern_title = get_the_title();
					if ( ! $pattern_title ) {
						$pattern_title = '無題';
					}

					// コンテンツ
					$pattern_content = get_the_content();

					// ブロックパターンカテゴリー
					$pattern_categories = array();
					$terms              = get_the_terms( $the_query->post->ID, 'nishiki_pro_pattern_categories' );
					if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
						foreach ( $terms as $term ) {
							$pattern_categories[] = $term->slug;
						}
					} else {
						$pattern_categories[] = 'no-category';
					}

					// ブロックパターン追加
					if ( $pattern_content ) {
						if ( function_exists( 'register_block_pattern' ) ) {
							register_block_pattern(
								'nishiki-blocks-pro/block-pattern-' . $the_query->post->ID,
								array(
									'title'      => $pattern_title,
									'content'    => $pattern_content,
									'categories' => $pattern_categories,
								)
							);
						}
					}
				}
				wp_reset_postdata();
			}

			// ブロックパターンカテゴリー追加
			$builtin_pattern_category = array( 'header', 'text', 'columns', 'buttons', 'gallery' );
			$terms                    = get_terms( array( 'nishiki_pro_pattern_categories' ), array( 'get' => 'all' ) );

			if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
				foreach ( $terms as $term ) {
					// コアのブロックパターンカテゴリと同じ場合は登録をスキップする
					if ( ! in_array( $term->slug, $builtin_pattern_category, true ) ) {
						// ブロックパターンカテゴリー追加
						if ( function_exists( 'register_block_pattern_category' ) ) {
							register_block_pattern_category(
								$term->slug,
								array( 'label' => $term->name . ' - Nishiki Pro' )
							);
						}
					}
				}
			}

			// カテゴリーなしの追加
			if ( function_exists( 'register_block_pattern_category' ) ) {
				register_block_pattern_category(
					'no-category',
					array( 'label' => '未分類 - Nishiki Pro' )
				);
			}

		}
	}

	$output = new NISHIKI_PRO_BLOCK_PATTERN_ADMIN();
}
