<?php
if ( ! class_exists( 'NISHIKI_PRO_NOTIFICATION' ) ) {
	/**
	 * Create NOTIFICATION.
	 */
	class NISHIKI_PRO_NOTIFICATION {

		/**
		 * Constructor.
		 *
		 * 初期設定
		 */
		public function __construct() {
			add_action( 'admin_notices', array( $this, 'nishiki_pro_notification' ) );
			add_action( 'admin_notices', array( $this, 'nishiki_pro_deprecated' ) );
		}

		/**
		 * Check Nishiki Setting.
		 *
		 * 設定チェック
		 */
		public function nishiki_pro_setting_notification() {
			$transient = 'nishiki_pro_info';
			$url       = 'https://support.animagate.com/wp/nishiki-pro-info.json';
			$response  = get_transient( $transient );

			if ( false === $response ) {
				$request = wp_remote_get( $url );
				if ( isset( $request ) && ! empty( $request ) && ! is_wp_error( $request ) && 200 === $request['response']['code'] ) {
					$response = json_decode( wp_remote_retrieve_body( $request ), true );
					set_transient( $transient, $response, 3600 );
				}
			}

			echo '<div class="notice notice-warning nishiki-pro-info">';

			if ( $response ) {

				echo '<h3>' . esc_html( $response['title'] ) . '</h3>';

				if ( ! empty( $response['messages'] ) ) {
					foreach ( $response['messages'] as $message ) {
						echo '<p>' . esc_html( $message['text'] ) . '</p>';
					}
				}
				if ( ! empty( $response['function_links'] ) ) {
					echo '<ul>';
					foreach ( $response['function_links'] as $link ) {
						echo '<li><a class="button ' . esc_attr( $link['status'] ) . '" href="' . esc_url( $link['url'] ) . '" target="_blank" rel="noopener noreferrer">' . esc_html( $link['name'] ) . '</a></li>';
					}
					echo '</ul>';
				}
				echo '<p><a class="button button-primary" target="_blank" rel="noopener noreferrer" href="' . esc_url( $response['product_url'] ) . '">ライセンスを購入する</a></p>';

			} else {
				echo '<h3>[Nishiki Pro]テーマを製品登録する</h3>';
				echo '<p>製品登録を行うと、管理画面（ダッシュボード）でテーマのアップデートがワンクリックで可能になります（製品登録後、このメッセージは消えます）。</p>';
				echo '<p>気に入っていただけましたら、ぜひ製品版のご利用を検討ください！</p>';
				echo '<h3>製品版で使用できる機能（一部）</h3>';
				echo '<ul>';
				echo '<li><a class="button" href="https://support.animagate.com/manual/wp-nishiki-heading-style/" target="_blank" rel="noopener noreferrer">見出しデザイン</a></li>';
				echo '<li><a class="button" href="https://support.animagate.com/manual/wp-nishiki-pro-gutenberg-marker/" target="_blank" rel="noopener noreferrer">マーカー</a></li>';
				echo '<li><a class="button" href="https://support.animagate.com/manual/wp-nishiki-page-template/" target="_blank" rel="noopener noreferrer">LP 作成用テンプレート</a></li>';
				echo '<li><a class="button" href="https://support.animagate.com/manual/wp-nishiki-header-layout/" target="_blank" rel="noopener noreferrer">ヘッダーレイアウト</a></li>';
				echo '<li><a class="button" href="https://support.animagate.com/manual/wp-nishiki-filter-search/" target="_blank" rel="noopener noreferrer">絞り込み検索</a></li>';
				echo '<li><a class="button" href="https://support.animagate.com/manual/wp-nishiki-table-of-contents/" target="_blank" rel="noopener noreferrer">目次</a></li>';
				echo '<li><a class="button" href="https://support.animagate.com/manual/wp-nishiki-campaign-link/" target="_blank" rel="noopener noreferrer">キャンペーンリンク</a></li>';
				echo '</ul>';
				echo '<p><a href="https://support.animagate.com/product/wp-nishiki-pro/" target="_blank" class="button button-primary" rel="noopener noreferrer">製品版を購入する</a></p>';
			}

			echo '</div>';
		}

		/**
		 * 通知
		 *
		 * @return string
		 */
		public function nishiki_pro_notification() {
			$reg_key_data = get_option( 'nishiki_pro' );
			$reg_key      = isset( $reg_key_data['reg_key'] ) ? $reg_key_data['reg_key'] : '';
			if ( isset( $reg_key ) && ! empty( $reg_key ) ) {
				return false;
			}

			$this->nishiki_pro_setting_notification();
		}


		/**
		 * Check Nishiki Setting.
		 *
		 * 設定チェック
		 */
		public function nishiki_pro_deprecated() {

			$this->hide_notices();
			$output = '';

			// delete_option( 'nishiki_pro_hide_customizer_front_page_notice' );

			if ( ! get_option( 'nishiki_pro_hide_customizer_front_page_notice' ) ) {
				$notice_type = 'customizer_front_page';
				$nonce_url   = wp_nonce_url( add_query_arg( 'nishiki-pro-hide-notice', $notice_type ), 'nishiki_pro_hide_notices_nonce', '_nishiki_pro_notice_nonce' );

//				echo '<div class="notice nishiki-pro-info">';
//				echo '<h3>※ Nishiki Pro ご利用の方へ大切なお知らせ</h3>';
//				echo '<p>バージョン 1.0.185 より、カスタマイザーの「フロントページ設定」の機能を廃止しました。</p>';
//				echo '<p>これまでフロントページ設定で作成したセクションは、しばらくのあいだ表示可能です。<a class="button button-primary" href="' . esc_url( admin_url( 'customize.php' ) ) . '">カスタマイザー</a> の「トップページ」→「フロントページ設定」で、表示・非表示が選択できます。</p>';

//				echo '<p style="text-align: right;"><a href="' . esc_url( $nonce_url ) . '" onclick="return nishikiProConfirm()">このメッセージを非表示にする</a></p>';
//				echo '</div>';
			}

			// ビルダーの通知
			$text  = '<h3>[Nishiki Pro]新しい無料ビルダーツール（Beta）のお知らせ</h3>';
			$text .= '<p>ボタン一つでコンテンツが作成できる「ブロックパターン」を搭載した <strong>Nishiki Pro スピードビルダー（Beta）</strong> プラグインをリリースしました。ぜひ使ってみてください！</p>';
			$text .= '<a class="button button-primary" target="_blank" rel="noopener noreferrer" href="https://support.animagate.com/manual/wp-nishiki-pro-speed-builder">プラグインをダウンロードする</a>';
//			$this->notify( 'speed_builder', $text );

			// デモデータインポートの通知
			$demo_text  = '<h3>デモデータまるごと【無料】インポート</h3>';
			$demo_text .= '<div class="import-demo-wrapper">';
			$demo_text .= '<div class="import-demo-text"><p>ワンクリックでデモサイトのデータをまるごとインポート。<strong>「デモデータ インポート」</strong>機能が Nishiki Pro Speed Builder プラグインに登場！</p>';
			$demo_text .= '<a class="button button-primary" target="_blank" rel="noopener noreferrer" href="https://support.animagate.com/manual/wp-nishiki-pro-speed-builder">プラグインをダウンロードする</a>';
			$demo_text .= '</div>';
			$demo_text .= '<div class="import-demo-images">';
			$demo_text .= '<img src="' . esc_url( get_template_directory_uri() ) . '/assets/images/wp-nishiki-pro-07.webp" alt="Nishiki Pro Speed Builder import demo 01">';
			$demo_text .= '<img src="' . esc_url( get_template_directory_uri() ) . '/assets/images/wp-nishiki-pro-08.webp" alt="Nishiki Pro Speed Builder import demo 02">';
			$demo_text .= '<img src="' . esc_url( get_template_directory_uri() ) . '/assets/images/wp-nishiki-pro-09.webp" alt="Nishiki Pro Speed Builder import demo 03">';
			$demo_text .= '</div>';
			$demo_text .= '</div>';
			$this->notify( 'speed_builder_import_demo', $demo_text, ' import-demo' );
		}

		/**
		 * 通知削除関連
		 *
		 * @return void
		 */
		public function hide_notices() {
			if ( isset( $_GET['nishiki-pro-hide-notice'] ) && isset( $_GET['_nishiki_pro_notice_nonce'] ) ) {
				if ( ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_GET['_nishiki_pro_notice_nonce'] ) ), 'nishiki_pro_hide_notices_nonce' ) ) {
					wp_die( '有効期限切れ：ページを更新してから操作してください。' );
				}

				$notice = sanitize_text_field( wp_unslash( $_GET['nishiki-pro-hide-notice'] ) );

				switch ( $notice ) {
					case 'customizer_front_page':
						update_option( 'nishiki_pro_hide_customizer_front_page_notice', true );
						break;
				}
			}
		}

		/**
		 * 通知
		 *
		 * @param string $name 名前
		 * @param string $text 文字列
		 * @return mixed
		 */
		public function notify( $name, $text, $class = '' ) {
			if ( empty( $name ) || empty( $text ) ) {
				echo 'name か text が設定されていません。';
				return false;
			}

			$option_name = 'nishiki_pro_' . $name . '_notice';
			$action_url  = add_query_arg( 'nishiki_pro_notification', $option_name );
			$action      = 'nishiki_pro_' . $name;
			$nonce_name  = '_' . $name . '_nonce';

			// delete_option($option_name);

			if ( isset( $_GET['nishiki_pro_notification'] ) && isset( $_GET[ $nonce_name ] ) ) {
				if ( ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_GET[ $nonce_name ] ) ), $action ) ) {
					wp_die( '有効期限切れ：ページを更新してから操作してください。' );
				}

				$notice = sanitize_text_field( wp_unslash( $_GET['nishiki_pro_notification'] ) );

				if ( $notice === $option_name ) {
					update_option( $option_name, true );
				} else {
					wp_die( 'データが正しくありません。' );
				}
			}

			if ( ! get_option( $option_name ) ) {
				$nonce_url = wp_nonce_url( $action_url, $action, $nonce_name );

				echo '<div class="notice notice-success nishiki-pro-info' . $class . '">';
				echo wp_kses_post( $text );
				echo '<p style="text-align: right;"><a href="' . esc_url( $nonce_url ) . '" onclick="return nishikiProConfirm()">このメッセージを非表示にする</a></p>';
				echo '</div>';
			}
		}


	}
}

$output = new NISHIKI_PRO_NOTIFICATION();
