<?php
/**
 * 初期設定
 *
 * @author     AnimaGate, Inc.
 * @link       https://support.animagate.com/product/wp-nishiki-pro/
 */

/*
 * Rest API.
 */
require_once 'restapi/class-rest-api.php';

/*
 * General.
 */
require_once 'class-general.php';

/*
 * Setup.
 */
require_once 'setup/class-setup.php';

/*
 * Notification.
 */
require_once 'class-notification.php';

/*
 * Breadcrumbs.
 */
require_once 'breadcrumbs/class-breadcrumbs.php';

/*
 * Meta.
 */

// OGP Admin Page.
require_once 'meta/class-ogp-admin.php';

// OGP Output.
require_once 'meta/class-ogp-utility.php';
require_once 'meta/class-ogp.php';
require_once 'meta/class-ogp-twitter.php';
require_once 'meta/class-ogp-facebook.php';

// JSON-LD Admin Page.
require_once 'meta/class-json-ld-admin.php';

// JSON-LD Output.
require_once 'meta/class-json-ld.php';

/*
 * Content
 */

// Load Utility
require_once 'content/class-content-utility.php';

// Post Type
require_once 'content/class-content-post-type.php';

// Term
require_once 'content/class-content-term.php';

// Admin Page
require_once 'content/class-content-admin.php';

// MCE
require_once 'content/class-content-mce.php';

// Shortcode
require_once 'content/class-content-shortcode.php';

// Content Output
require_once 'content/class-content.php';

/*
 * Top
 */
require_once 'top/class-top.php';

/*
 * Optimize
 */
require_once 'optimize/class-optimize.php';

/*
 * Profile
 */
require_once 'profile/class-profile.php';

/*
 * Script
 */
require_once 'script/class-script.php';

/*
 * Font
 */
require_once 'font/class-font.php';

/*
 * Walker
 */
require_once 'walker/class-walker-global-nav.php';
require_once 'walker/class-walker-footer-nav.php';

/*
 * Multiple Search
 */

// Load Utility
require_once 'multiple-search/class-multiple-search-utility-form.php';
require_once 'multiple-search/class-multiple-search-utility.php';

// Admin Page
require_once 'multiple-search/class-multiple-search-admin.php';

// Shortcode
require_once 'multiple-search/class-multiple-search-shortcode.php';

// Output
require_once 'multiple-search/class-multiple-search.php';

/*
 * Meta Box
 */
require_once 'meta-box/class-meta-box-breadcrumbs.php';
require_once 'meta-box/class-meta-box-title.php';
require_once 'meta-box/class-meta-box-content-width.php';
require_once 'meta-box/class-meta-box-noindex.php';
require_once 'meta-box/class-meta-box-nofollow.php';
require_once 'meta-box/class-meta-box-eye-catch-layout.php';
require_once 'meta-box/class-meta-box-campaign.php';
require_once 'meta-box/class-meta-box-header.php';
require_once 'meta-box/class-meta-box-pr.php';
require_once 'meta-box/class-meta-box-class.php';

/*
 * Term Meta
 */
require_once 'term-meta/class-term-meta-image.php';

/*
 * Block Editor
 */
require_once 'block-editor/class-block-editor-utility.php';
require_once 'block-editor/class-block-editor-admin.php';

/*
 * Block Styles
 */
require_once 'block-styles/class-block-styles.php';

/*
 * Color
 */
require_once 'block-editor/color/class-block-editor-color.php';

/*
 * Heading
 */
require_once 'block-editor/heading/class-block-editor-heading.php';

/*
 * Block Pattern
 */
require_once 'block-pattern/class-block-pattern-admin.php';

/*
 * Indeed Ads
 */
require_once 'infeed-ads/class-infeed-ads.php';

/*
 * Shortcode
 */
require_once 'shortcode/class-shortcode-br.php';

/*
 * Redirect
 */
require_once 'redirect/class-redirect.php';

/*
 * CSS
 */
require_once 'css/class-css.php';
