<?php
if ( ! class_exists( 'NISHIKI_PRO_META_BOX_HEADER' ) ) {
	/**
	 * Meta box 追加(ヘッダーレイアウト)
	 *
	 * @author     AnimaGate, Inc.
	 * @link       https://support.animagate.com/product/wp-nishiki-pro/
	 */
	class NISHIKI_PRO_META_BOX_HEADER {
		/**
		 * 名前
		 *
		 * @var string
		 */
		private $meta_box_name = 'nishiki_pro_meta_box_header';

		/**
		 *
		 * Constructor.
		 */
		public function __construct() {
			add_action( 'add_meta_boxes', array( $this, 'add_meta_box' ), 10 );
			add_action( 'save_post', array( $this, 'save_meta_box' ), 10 );
		}

		/**
		 * Adds a box to the main column on the Post and Page edit screens.
		 */
		public function add_meta_box() {

			$screens = nishiki_pro_get_all_post_types();
			foreach ( $screens as $screen ) {
				add_meta_box(
					$this->meta_box_name . '_' . $screen,
					__( 'ヘッダー設定（上級者向け）', 'nishiki_pro' ),
					array( $this, 'meta_box_callback' ),
					$screen
				);
			}
		}

		/**
		 * Prints the box content.
		 *
		 * @param WP_Post $post The object for the current post/page.
		 */
		public function meta_box_callback( $post ) {

			// Add a nonce field so we can check for it later.
			wp_nonce_field( $this->meta_box_name . '_save', $this->meta_box_name . '_nonce' );

			/*
			 * Use get_post_meta() to retrieve an existing value
			 * from the database and use the value for the form.
			 */
			$header_sticky_disable        = false;
			$header_sticky_mobile_disable = false;
			$header_sticky_style          = '';
			$header_sticky_mobile_style   = '';
			$header_layout                = '横';

			if ( get_theme_mod( 'setting_header_layout', 'default' ) === 'default' ) {
				$header_sticky_mobile_disable = true;
				$header_sticky_mobile_style   = ' style=display:none';
			} elseif ( get_theme_mod( 'setting_header_layout', 'default' ) === 'center' ) {
				$header_sticky_disable = true;
				$header_sticky_style   = ' style=display:none';
				$header_layout         = '縦';
			}

			echo '<h4>レイアウト（選択中：' . esc_html( $header_layout ) . '）</h4>';

			echo '<h4>固定する</h4>';

			$value_sticky  = get_post_meta( get_the_ID(), '_' . $this->meta_box_name . '_sticky_' . get_post_type(), true );
			$default_value = '';

			$select_array = array(
				''    => '未設定',
				true  => '有効',
				false => '無効',
			);

			if ( get_theme_mod( 'setting_header_fixed', true ) ) {
				$default_value = true;
			} else {
				$default_value = false;
			}

			echo '<p' . esc_attr( $header_sticky_style ) . '>';
			echo '<label for="' . esc_attr( $this->meta_box_name ) . '_sticky">';

			echo '<select ' . disabled( $header_sticky_disable, true, false ) . ' name="' . esc_attr( $this->meta_box_name ) . '_sticky_new_field" id="' . esc_attr( $this->meta_box_name ) . '_sticky">';

			foreach ( $select_array as $key => $val ) {
				echo '<option value="' . esc_attr( $key ) . '" ' . selected( $value_sticky, $key ) . '">' . esc_html( $val ) . '</option>';
			}

			echo '</select>';

			if ( isset( $default_value ) ) {
				echo '<small> デフォルト：' . esc_html( $select_array[ $default_value ] ) . '</small>';
			}
			echo '</label>';
			echo '</p>';

			$value_sticky_mobile = get_post_meta( get_the_ID(), '_' . $this->meta_box_name . '_sticky_mobile_' . get_post_type(), true );

			$select_array = array(
				''    => '未設定',
				true  => '有効',
				false => '無効',
			);

			if ( get_theme_mod( 'setting_header_fixed_mobile' ) ) {
				$default_value = true;
			} else {
				$default_value = false;
			}

			echo '<p' . esc_attr( $header_sticky_mobile_style ) . '>';
			echo '<label for="' . esc_attr( $this->meta_box_name ) . '_sticky_mobile">';
			echo '<select ' . disabled( $header_sticky_mobile_disable, true, false ) . ' name="' . esc_attr( $this->meta_box_name ) . '_sticky_mobile_new_field" id="' . esc_attr( $this->meta_box_name ) . '_sticky_mobile">';

			foreach ( $select_array as $key => $val ) {
				echo '<option value="' . esc_attr( $key ) . '" ' . selected( $value_sticky_mobile, $key ) . '">' . esc_html( $val ) . '</option>';
			}

			echo '</select>';

			if ( isset( $default_value ) ) {
				echo '<small> デフォルト：' . esc_html( $select_array[ $default_value ] ) . '</small>';
			}
			echo '</label>';
			echo '</p>';

			echo '<br>';

			$value_overlay = get_post_meta( get_the_ID(), '_' . $this->meta_box_name . '_overlay_' . get_post_type(), true );

			if ( get_theme_mod( 'setting_header_overlay', false ) ) {
				$default_value = true;
			} else {
				$default_value = false;
			}

			echo '<div>';
			echo '<label for="' . esc_attr( $this->meta_box_name ) . '_overlay">';
			echo '<h4>オーバーレイにする</h4>';
			echo '<select name="' . esc_attr( $this->meta_box_name ) . '_overlay_new_field" id="' . esc_attr( $this->meta_box_name ) . '_overlay">';

			foreach ( $select_array as $key => $val ) {
				echo '<option value="' . esc_attr( $key ) . '" ' . selected( $value_overlay, $key ) . '">' . esc_html( $val ) . '</option>';
			}

			echo '</select>';

			if ( isset( $default_value ) ) {
				echo '<small> デフォルト：' . esc_html( $select_array[ $default_value ] ) . '</small>';
			}
			echo '</label>';
			echo '</div>';

		}

		/**
		 * When the post is saved, saves our custom data.
		 *
		 * @param int $post_id The ID of the post being saved.
		 */
		public function save_meta_box( $post_id ) {

			// Check if our nonce is set.
			if ( ! isset( $_POST[ $this->meta_box_name . '_nonce' ] ) ) {
				return;
			}

			// Verify that the nonce is valid.
			if ( ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST[ $this->meta_box_name . '_nonce' ] ) ), $this->meta_box_name . '_save' ) ) {
				return;
			}

			// If this is an autosave, our form has not been submitted, so we don't want to do anything.
			if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
				return;
			}

			// Check the user's permissions.
			if ( isset( $_POST['post_type'] ) && 'page' === $_POST['post_type'] ) {

				if ( ! current_user_can( 'edit_page', $post_id ) ) {
					return;
				}
			} else {

				if ( ! current_user_can( 'edit_post', $post_id ) ) {
					return;
				}
			}

			/* OK, it's safe for us to save the data now. */

			/*
			 * Sticky
			 */
			$value = get_post_meta( $post_id, '_' . $this->meta_box_name . '_sticky_' . get_post_type(), true );

			// 値がポストされていなかったら
			if ( ! isset( $_POST[ $this->meta_box_name . '_sticky_new_field' ] ) ) {
				if ( $value ) {
					delete_post_meta( $post_id, '_' . $this->meta_box_name . '_sticky_' . get_post_type(), 1 );
				}
			} else {
				// Sanitize user input.
				$my_data = sanitize_text_field( wp_unslash( $_POST[ $this->meta_box_name . '_sticky_new_field' ] ) );

				// Update the meta field in the database.
				update_post_meta( $post_id, '_' . $this->meta_box_name . '_sticky_' . get_post_type(), $my_data );
			}

			/*
			 * Sticky Mobile
			 */
			$value = get_post_meta( $post_id, '_' . $this->meta_box_name . '_sticky_mobile_' . get_post_type(), true );

			// 値がポストされていなかったら
			if ( ! isset( $_POST[ $this->meta_box_name . '_sticky_mobile_new_field' ] ) ) {
				if ( $value ) {
					delete_post_meta( $post_id, '_' . $this->meta_box_name . '_sticky_mobile_' . get_post_type(), 1 );
				}
			} else {
				// Sanitize user input.
				$my_data = sanitize_text_field( wp_unslash( $_POST[ $this->meta_box_name . '_sticky_mobile_new_field' ] ) );

				// Update the meta field in the database.
				update_post_meta( $post_id, '_' . $this->meta_box_name . '_sticky_mobile_' . get_post_type(), $my_data );
			}

			/*
			 * Overlay
			 */
			$value = get_post_meta( $post_id, '_' . $this->meta_box_name . '_overlay_' . get_post_type(), true );

			// 値がポストされていなかったら
			if ( ! isset( $_POST[ $this->meta_box_name . '_overlay_new_field' ] ) ) {
				if ( $value ) {
					delete_post_meta( $post_id, '_' . $this->meta_box_name . '_overlay_' . get_post_type(), 1 );
				}
			} else {
				// Sanitize user input.
				$my_data = sanitize_text_field( wp_unslash( $_POST[ $this->meta_box_name . '_overlay_new_field' ] ) );

				// Update the meta field in the database.
				update_post_meta( $post_id, '_' . $this->meta_box_name . '_overlay_' . get_post_type(), $my_data );
			}
		}

	}
}

$output = new NISHIKI_PRO_META_BOX_HEADER();
