<?php
if ( ! class_exists( 'NISHIKI_PRO_META_JSON_LD_ADMIN' ) ) {
	/**
	 * JSON-LD
	 */
	class NISHIKI_PRO_META_JSON_LD_ADMIN {

		/**
		 * Holds the options to be used in the fields callbacks
		 *
		 * @var 0.0.1
		 */
		private $options;

		/**
		 * Holds plugin name
		 *
		 * @var 0.0.1
		 */
		private $plugin_name = 'nishiki_pro_meta_json_ld';

		/**
		 * 初期設定
		 */
		public function __construct() {
			// オプションページ追加フック
			add_action( 'admin_menu', array( $this, 'nishiki_pro_meta_json_ld_admin_menu' ), 30 );

			// フォーム追加
			add_action( 'admin_init', array( $this, 'nishiki_pro_meta_json_ld_register_settings' ), 30 );
		}

		/**
		 * サブメニュー追加
		 */
		public function nishiki_pro_meta_json_ld_admin_menu() {
			add_submenu_page(
				'nishiki-pro-general.php',
				'Schema.org（構造化データ）',
				'Schema.org（構造化データ）',
				'manage_options',
				'nishiki-pro-meta-json-ld.php',
				array( $this, 'nishiki_pro_meta_json_ld_admin_page' )
			);
		}

		/**
		 * フォームの設定
		 *
		 * @return void
		 */
		public function nishiki_pro_meta_json_ld_register_settings() {

			register_setting(
				$this->plugin_name,
				'nishiki_pro_meta_json_ld',
				array( $this, 'sanitize' )
			);

			add_settings_section(
				'nishiki_pro_meta_json_ld_general',
				__( '出力設定', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_meta_json_ld_general_cb' ),
				$this->plugin_name
			);

			add_settings_field(
				'post_type',
				__( '投稿タイプ', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_meta_json_ld_post_type_cb' ),
				$this->plugin_name,
				'nishiki_pro_meta_json_ld_general',
				array( 'label_for' => 'post_type' )
			);

			add_settings_field(
				'website',
				__( 'ウェブサイトの情報', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_meta_json_ld_website_cb' ),
				$this->plugin_name,
				'nishiki_pro_meta_json_ld_general',
				array( 'label_for' => 'website' )
			);

			add_settings_field(
				'website_type',
				__( 'ウェブサイトのタイプ（組織/個人）', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_meta_json_ld_website_type_cb' ),
				$this->plugin_name,
				'nishiki_pro_meta_json_ld_general',
				array( 'label_for' => 'website_type' )
			);

			add_settings_field(
				'search',
				__( '検索', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_meta_json_ld_search_cb' ),
				$this->plugin_name,
				'nishiki_pro_meta_json_ld_general',
				array( 'label_for' => 'search' )
			);

			add_settings_field(
				'address',
				__( '所在地', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_meta_json_ld_address_cb' ),
				$this->plugin_name,
				'nishiki_pro_meta_json_ld_general',
				array( 'label_for' => 'address' )
			);

			add_settings_field(
				'contactpoint',
				__( '連絡先', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_meta_json_ld_contactpoint_cb' ),
				$this->plugin_name,
				'nishiki_pro_meta_json_ld_general',
				array( 'label_for' => 'contactpoint' )
			);

		}

		/**
		 * 入力値のサニタイズ
		 *
		 * @param array $input Contains all settings fields as array keys
		 */
		public function sanitize( $input ) {
			$new_input = array();
			if ( isset( $input['website'] ) ) {
				$new_input['website'] = absint( $input['website'] );
			}

			if ( isset( $input['website_type'] ) ) {
				$new_input['website_type'] = absint( $input['website_type'] );
			}

			if ( isset( $input['search'] ) ) {
				$new_input['search'] = absint( $input['search'] );
			}

			if ( isset( $input['address'] ) ) {
				$new_input['address'] = absint( $input['address'] );
			}

			if ( isset( $input['contactpoint'] ) ) {
				$new_input['contactpoint'] = absint( $input['contactpoint'] );
			}

			if ( isset( $input['post_type'] ) ) {
				$new_input['post_type'] = array_map( 'strip_tags', $input['post_type'] );
			}

			// wp_die(var_dump($new_input));
			return $new_input;
		}


		/**
		 * フォームの出力
		 */
		public function nishiki_pro_meta_json_ld_general_cb() {
			$nonce = wp_create_nonce( 'nishiki_pro_meta_json_ld' );
			echo '<input type="hidden" name="nishiki_pro_meta_json_ld" value="' . esc_attr( $nonce ) . '" />';
		}

		/**
		 * 投稿タイプ
		 */
		public function nishiki_pro_meta_json_ld_post_type_cb() {
			$args     = array(
				'public' => true,
			);
			$output   = 'objects';
			$operator = 'and';
			$pts      = get_post_types( $args, $output, $operator );

			echo '<ul>';
			foreach ( $pts as $pt ) {
				if ( 'attachment' !== $pt->name ) {
					$pt_checked = '';
					if ( isset( $this->options['post_type'] ) ) {
						if ( array_key_exists( $pt->name, $this->options['post_type'] ) ) {
							$pt_checked = ' checked="checked"';
						}
					}

					echo '<li><input type="checkbox" id="' . esc_attr( $pt->name ) . '" name="nishiki_pro_meta_json_ld[post_type][' . esc_attr( $pt->name ) . ']" value="1"' . esc_attr( $pt_checked ) . '><label for="' . esc_attr( $pt->name ) . '">' . esc_html( $pt->label ) . '</label></li>';
				}
			}
			echo '</ul>';
			echo '<p class="description">出力する投稿タイプにチェックを入れてください。</p>';

		}

		/**
		 * ウェブサイト
		 */
		public function nishiki_pro_meta_json_ld_website_cb() {
			if ( isset( $this->options['website'] ) ) {
				$checked = ' checked="checked"';
			} else {
				$checked = '';
			}

			echo '<input type="checkbox" id="website" name="nishiki_pro_meta_json_ld[website]" value="1"' . esc_attr( $checked ) . '><label for="website">出力（トップページ）</label>';

		}

		/**
		 * ウェブサイトタイプ
		 */
		public function nishiki_pro_meta_json_ld_website_type_cb() {
			if ( isset( $this->options['website_type'] ) ) {
				$checked = ' checked="checked"';
			} else {
				$checked = '';
			}

			echo '<input type="checkbox" id="website_type" name="nishiki_pro_meta_json_ld[website_type]" value="1"' . esc_attr( $checked ) . '><label for="website_type">出力（トップページ）</label>';

		}

		/**
		 * 所在地
		 */
		public function nishiki_pro_meta_json_ld_address_cb() {
			if ( isset( $this->options['address'] ) ) {
				$checked = ' checked="checked"';
			} else {
				$checked = '';
			}
			echo '<input type="checkbox" id="address" name="nishiki_pro_meta_json_ld[address]" value="1"' . esc_attr( $checked ) . '><label for="address">出力（トップページ）</label>';
		}

		/**
		 * 連絡先
		 */
		public function nishiki_pro_meta_json_ld_contactpoint_cb() {
			if ( isset( $this->options['contactpoint'] ) ) {
				$checked = ' checked="checked"';
			} else {
				$checked = '';
			}
			echo '<input type="checkbox" id="contactpoint" name="nishiki_pro_meta_json_ld[contactpoint]" value="1"' . esc_attr( $checked ) . '><label for="contactpoint">出力（トップページ）</label>';
		}

		/**
		 * 検索
		 */
		public function nishiki_pro_meta_json_ld_search_cb() {
			if ( isset( $this->options['search'] ) ) {
				$checked = ' checked="checked"';
			} else {
				$checked = '';
			}
			echo '<input type="checkbox" id="search" name="nishiki_pro_meta_json_ld[search]" value="1"' . esc_attr( $checked ) . '><label for="search">出力（トップページ）</label>';
		}


		/**
		 * オプションページの内容
		 */
		public function nishiki_pro_meta_json_ld_admin_page() {
			$this->options = get_option( 'nishiki_pro_meta_json_ld' );
			if ( ! current_user_can( 'manage_options' ) ) {
				wp_die( 'このページを表示する権限がありません。' );
			}
			?>
				<div class="wrap">
					<h1>Schema.org（構造化データ） 設定</h1>
					<p>Schema.orgの構造化データをJSON-LDで出力するための設定をします。</p>
					<p>詳細設定は「外観」→「カスタマイズ」→「[Nishiki Pro] オプション」→「構造化データ」で設定してください。</p>
					<hr>
					<form method="post" action="options.php" name="nishiki_pro_meta_json_ld">
				<?php
				settings_fields( $this->plugin_name );
				do_settings_sections( $this->plugin_name );
				?>
						<p>
							<input type="button" class="button button-secondary" value="全てにチェック" onclick="allcheck(true);">
							<input type="button" class="button button-secondary" value="全てのチェックを外す" onclick="allcheck(false);">
						</p>
						<script>
							function allcheck( flag ) {
								var ElementsCount = document.nishiki_pro_meta_json_ld.elements.length;
								for( i=0 ; i < ElementsCount ; i++ ) {
									document.nishiki_pro_meta_json_ld.elements[i].checked = flag;
								}
							}
						</script>
				<?php
				submit_button();
				?>
					</form>
					<hr>
					<h3>マニュアルを見る</h3>
					<p><a target="_blank" rel="noopener noreferrer" class="button" href="https://support.animagate.com/manual/wp-nishiki-meta-function/">操作マニュアル</a></p>
				</div>
			<?php
		}
	}

	if ( is_admin() ) {
		$nishiki_pro_meta_json_ld_page = new NISHIKI_PRO_META_JSON_LD_ADMIN();
	}
}
