<?php
if ( ! class_exists( 'NISHIKI_PRO_META_OGP_UTILITY' ) ) {
	/**
	 * OGP UTILITY.
	 */
	class NISHIKI_PRO_META_OGP_UTILITY {
		/**
		 * Output OGP Tag.
		 *
		 * @var string OGP Content.
		 *
		 * @param string $property OGP value.
		 * @param string $content OGP value.
		 *
		 * @link https://developers.facebook.com/tools/debug
		 * @return string
		 */
		public function og( $property, $content ) {
			$og_property = str_replace( ':', '_', $property );

			$content = apply_filters( NISHIKI_PRO_PREFIX_META . '_ogp_' . $og_property, $content );
			if ( empty( $content ) ) {
				return false;
			}

			echo '<meta property="' . esc_attr( $property ) . '" content="' . esc_attr( $content ) . '" />' . "\n";

			return true;
		}

		/**
		 * Output OGP Tag.
		 *
		 * @var string OGP Content.
		 *
		 * @param string $property OGP value.
		 * @param string $content OGP value.
		 *
		 * @link https://developers.facebook.com/tools/debug
		 * @return string
		 */
		public function twittercard( $property, $content ) {
			$og_property = str_replace( ':', '_', $property );

			$content = apply_filters( NISHIKI_PRO_PREFIX_META . '_ogp_' . $og_property, $content );
			if ( empty( $content ) ) {
				return false;
			}

			if ( 'twitter:creator' === $property ) {
				preg_match( '/twitter\.com\/(\w+)/', $content, $match );
				$content = $match[1];
			}

			echo '<meta name="' . esc_attr( $property ) . '" content="' . esc_attr( $content ) . '" />' . "\n";

			return true;
		}

		/**
		 * Output OGP Tag.
		 *
		 * @var string OGP Content.
		 *
		 * @param string $property OGP value.
		 * @param string $content OGP value.
		 *
		 * @link https://developers.facebook.com/tools/debug
		 * @return string
		 */
		public function itemprop( $property, $content ) {
			$og_property = str_replace( ':', '_', $property );

			$content = apply_filters( NISHIKI_PRO_PREFIX_META . '_ogp_' . $og_property, $content );
			if ( empty( $content ) ) {
				return false;
			}

			echo '<meta itemprop="' . esc_attr( $property ) . '" content="' . esc_attr( $content ) . '" />' . "\n";

			return true;
		}



		/**
		 *
		 * カスタム投稿タイプかどうかチェック
		 */
		public function is_custom_post_type() {
			$post_obj = get_post_type_object( get_post_type() );
			if ( ! empty( $post_obj ) && false === $post_obj->_builtin ) {
				return $post_obj;
			} else {
				return false;
			}
		}

	}
}
