<?php
if ( ! class_exists( 'NISHIKI_PRO_OPTIMIZE' ) ) {
	/**
	 * Create OPTIMIZE.
	 */
	class NISHIKI_PRO_OPTIMIZE extends NISHIKI_PRO_GENERAL_UTILITY {

		/**
		 * 初期設定
		 */
		public function __construct() {
			// フォーム追加
			add_action( 'admin_init', array( $this, 'nishiki_pro_register_settings' ), 20 );

			// スクリプトを読み込む
			$this->is_nishiki_pro_optimize_script();
		}

		/**
		 * フォームの登録
		 */
		public function nishiki_pro_register_settings() {
			$page_name = $this->plugin_name . '_optimize';

			register_setting(
				$page_name,
				$page_name,
				array( $this, 'sanitize' )
			);

			add_settings_section(
				$page_name,
				'',
				array( $this, 'nishiki_pro_general_cb' ),
				$page_name
			);

			/*
			//add_settings_field(
				'front_end_jquery',
				__( 'jQuery（jquery.min.js）', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_checkbox_multiple_cb' ),
				$page_name,
				$page_name,
				array(
					'title' => '',
					'label' => 'front_end_jquery',
					'page_name' => $page_name,
					'description' => '',
					'script' => array(
						'disable' => '読み込まない',
						'footer' => 'フッター付近（ページの最後あたり）で読み込む',
					),
					'display_key' => false,
				)
			);
			*/

			add_settings_field(
				'front_end_jquery',
				__( 'jQuery（jquery.min.js）', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_radio_button_cb' ),
				$page_name,
				$page_name,
				array(
					'title'       => '',
					'label'       => 'front_end_jquery',
					'page_name'   => $page_name,
					'description' => '重要：使用しているプラグインによって設定が反映されない場合があります。',
					'script'      => array(
						'default' => '',
						'data'    => array(
							''        => '読み込む',
							'footer'  => 'フッター付近（ページの最後あたり）で読み込む',
							'disable' => '読み込まない',
						),
					),
					'display_key' => false,
				)
			);

			add_settings_field(
				'front_end_css',
				__( 'CSS（front-end.css）', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_checkbox_multiple_cb' ),
				$page_name,
				$page_name,
				array(
					'title'       => '',
					'label'       => 'front_end_css',
					'page_name'   => $page_name,
					'description' => '',
					'script'      => array(
						'minify' => 'minify（最小化）してファイル容量を減らす',
					),
					'display_key' => false,
				)
			);

			add_settings_field(
				'front_end_js',
				__( 'JavaScript（front-end.js）', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_checkbox_multiple_cb' ),
				$page_name,
				$page_name,
				array(
					'title'       => '',
					'label'       => 'front_end_js',
					'page_name'   => $page_name,
					'description' => '',
					'script'      => array(
						'minify' => 'minify（最小化）してファイル容量を減らす',
					),
					'display_key' => false,
				)
			);

			add_settings_field(
				'front_end_oembed',
				__( 'oembed（wp-embed.min.js）', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_checkbox_multiple_cb' ),
				$page_name,
				$page_name,
				array(
					'title'       => '',
					'label'       => 'front_end_oembed',
					'page_name'   => $page_name,
					'description' => '',
					'script'      => array(
						'disable' => '読み込まない',
					),
					'display_key' => false,
				)
			);

			/*
			//add_settings_field(
				'WordPress',
				__( 'WordPress の設定', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_checkbox_multiple_cb' ),
				$page_name,
				$page_name,
				array(
					'title' => '',
					'label' => 'WordPress',
					'page_name' => $page_name,
					'description' => '',
					'script' => array(
						'disable_version' => 'バージョンを削除',
					),
					'display_key' => false,
				)
			);
			*/
		}

		/**
		 *
		 * 表示設定チェック
		 */
		public function is_nishiki_pro_optimize_script() {
			$page_name = $this->plugin_name . '_optimize';

			$options = get_option( $page_name );

			if ( empty( $options ) ) {
				return false;
			}

			// Front end jQuery
			if ( ! empty( $options['front_end_jquery'] ) ) {
				if ( 'disable' === $options['front_end_jquery'] ) {
					add_action( 'wp_enqueue_scripts', array( $this, 'nishiki_pro_disable_jquery_frontend' ), 100 );
				}

				if ( 'footer' === $options['front_end_jquery'] || ! empty( $options['enable'] ) ) {
					add_action( 'wp_enqueue_scripts', array( $this, 'nishiki_pro_optimize_scripts' ), 100 );
				}
			}

			// Front end CSS
			if ( ! empty( $options['front_end_css'] ) ) {
				if ( ! empty( $options['front_end_css']['minify'] ) ) {
					add_filter( 'nishiki_pro_enqueue_front_end_css', array( $this, 'front_end_css' ), 100 );
				}
			}

			// Front end JS
			if ( ! empty( $options['front_end_js'] ) ) {
				if ( ! empty( $options['front_end_js']['minify'] ) ) {
					add_filter( 'nishiki_pro_enqueue_front_end_js', array( $this, 'front_end_js' ), 100 );
				}
			}

			// Front end Oembed
			if ( ! empty( $options['front_end_oembed'] ) ) {
				add_action( 'init', array( $this, 'nishiki_pro_disable_oembed' ), 100 );
				add_action( 'wp_enqueue_scripts', array( $this, 'nishiki_pro_deregister_oembed' ), 100 );
			}

			// get_optionでenableがある場合はコンバートさせる
		}


		/**
		 * 最適化実行
		 */
		public function nishiki_pro_optimize_scripts() {
			if ( ! is_admin() ) {
				wp_deregister_script( 'jquery' );
				wp_register_script( 'jquery', '/wp-includes/js/jquery/jquery.js', array(), '1.0.0', true );

				wp_enqueue_script( 'jquery' );
			}
		}

		/**
		 * フロントエンドの jQuery をオフにする
		 *
		 * @return void
		 */
		public function nishiki_pro_disable_jquery_frontend() {
			if ( ! is_admin() ) {
				wp_deregister_script( 'jquery' );
			}
		}

		/**
		 * フロントエンドの Oembed をオフにする
		 *
		 * @return void
		 */
		public function nishiki_pro_disable_oembed() {
			remove_action( 'wp_head', 'rest_output_link_wp_head' );

			// Remove the REST API endpoint.
			remove_action( 'rest_api_init', 'wp_oembed_register_route' );

			// Turn off oEmbed auto discovery.
			add_filter( 'embed_oembed_discover', '__return_false' );

			// Don't filter oEmbed results.
			remove_filter( 'oembed_dataparse', 'wp_filter_oembed_result', 10 );

			// Remove oEmbed discovery links.
			remove_action( 'wp_head', 'wp_oembed_add_discovery_links' );

			// Remove oEmbed-specific JavaScript from the front-end and back-end.
			remove_action( 'wp_head', 'wp_oembed_add_host_js' );

			if ( has_filter( 'tiny_mce_plugins', 'disable_embeds_tiny_mce_plugin' ) ) {
				add_filter( 'tiny_mce_plugins', 'disable_embeds_tiny_mce_plugin' );
			}

			// Remove all embeds rewrite rules.
			if ( has_filter( 'rewrite_rules_array', 'disable_embeds_rewrites' ) ) {
				add_filter( 'rewrite_rules_array', 'disable_embeds_rewrites' );
			}

			// Remove filter of the oEmbed result before any HTTP requests are made.
			remove_filter( 'pre_oembed_result', 'wp_filter_pre_oembed_result', 10 );

		}

		/**
		 * フロントエンドの Oembed をオフにする
		 *
		 * @return void
		 */
		public function nishiki_pro_deregister_oembed() {
			wp_dequeue_script( 'wp-embed' );
		}

		/**
		 * フロントエンド CSS
		 *
		 * @param string $url URL
		 * @return $url
		 */
		public function front_end_css( $url ) {
			$url = get_template_directory_uri() . '/assets/css/front-end.min.css';

			return $url;
		}

		/**
		 * フロントエンド JS
		 *
		 * @param string $url URL
		 * @return $url
		 */
		public function front_end_js( $url ) {
			$url = get_template_directory_uri() . '/assets/js/front-end.min.js';

			return $url;
		}

		/**
		 * 入力値のサニタイズ
		 *
		 * @param array $input Contains all settings fields as array keys
		 */
		public function sanitize( $input ) {
			$new_input = array();

			// wp_die(var_dump($input) );

			if ( isset( $input ) ) {
				foreach ( $input as $key => $val ) {
					// 配列の場合
					if ( is_array( $input[ $key ] ) ) {
						$new_input[ $key ] = array_map( 'absint', $input[ $key ] );
					} else {
						// 通常の場合
						$new_input[ $key ] = stripslashes( $input[ $key ] );
					}
				}
			}

			return $new_input;
		}

	}
}

$output = new NISHIKI_PRO_OPTIMIZE();
