<?php
if ( ! class_exists( 'NISHIKI_PRO_REST_API' ) ) {
	/**
	 * Create Code.
	 */
	class NISHIKI_PRO_REST_API {

		/**
		 * Constructor.
		 */
		public function __construct() {
			add_action( 'rest_api_init', array( $this, 'register_field' ) );
		}

		/**
		 * フィールドの登録
		 *
		 * @return void
		 */
		public function register_field() {
			// Add field.
			register_rest_field(
				nishiki_pro_get_all_post_types(),
				'nishiki_blocks_pro',
				array(
					'get_callback'    => array( $this, 'nishiki_blocks_rest_api' ),
					'update_callback' => null,
					'schema'          => null,
				)
			);

			// Add rest route.
			register_rest_route(
				'nishiki-pro',
				'/get_template_directory_uri',
				array(
					'methods'             => 'GET',
					'callback'            => array( $this, 'get_template_directory_uri' ),
					'permission_callback' => function () {
						return current_user_can( 'edit_others_posts' );
					},
				)
			);
		}

		/**
		 * Rest API
		 *
		 * @param array $object 配列
		 * @return $rest
		 */
		public function nishiki_blocks_rest_api( $object ) {
			$rest['display_name'] = '';
			$rest['author_link']  = '';

			if ( ! empty( $object['author'] ) ) {
				// Get the author name.
				$rest['display_name'] = get_the_author_meta( 'display_name', $object['author'] );

				// Get the author link.
				$rest['author_link'] = get_author_posts_url( $object['author'] );
			}

			// Featured image.
			$featured_img = wp_get_attachment_image_src( $object['featured_media'], array( 640, 360 ), false );
			if ( $featured_img ) {
				$rest['featured_image'] = $featured_img[0];
			} elseif ( get_theme_mod( 'setting_archive_default_image', '' ) ) {
				$image      = get_theme_mod( 'setting_archive_default_image' );
				$image_id   = attachment_url_to_postid( $image );
				$image_data = wp_get_attachment_image_src(
					$image_id,
					'thumbnail'
				);
				if ( ! empty( $image_data[3] ) ) {
					if ( true === $image_data[3] ) {
						$rest['featured_image'] = $image_data[0];
					}
				}
			} else {
				$rest['featured_image'] = '';
			}

			// Category.
			if ( ! empty( $object['categories'] ) ) {
				foreach ( $object['categories'] as $category ) {
					$rest['category'][] = array(
						'name' => get_cat_name( $category ),
						'link' => get_category_link( $category ),
						'id'   => $category,
					);
				}
			}

			// Excerpt.
			$rest['excerpt'] = get_the_excerpt( $object['id'] );

			// Term.
			$taxonomies = get_post_taxonomies( $object['id'] );
			if ( $taxonomies ) {
				foreach ( $taxonomies as $post_taxonomy ) {
					$terms = wp_get_post_terms( $object['id'], $post_taxonomy, array( 'fields' => 'ids' ) );

					if ( $terms ) {
						foreach ( $terms as $term ) {
							$get_term_by = get_term_by( 'id', $term, $post_taxonomy );

							if ( $get_term_by ) {
								$rest['terms'][] = $get_term_by;
								//break;
							}
						}
					}
				}
			}

			// Return REST API Data.
			return $rest;
		}

		/**
		 * テンプレートディレクトリの URI
		 *
		 * @param string $object 文字列
		 * @return string
		 */
		public function get_template_directory_uri( $object ) {
			return get_template_directory_uri();
		}

	}
}

$output = new NISHIKI_PRO_REST_API();
