<?php
if ( ! class_exists( 'NISHIKI_PRO_SCRIPT' ) ) {
	/**
	 * Create Code.
	 */
	class NISHIKI_PRO_SCRIPT extends NISHIKI_PRO_GENERAL_UTILITY {

		/**
		 * Constructor.
		 */
		public function __construct() {
			// フォーム追加
			add_action( 'admin_init', array( $this, 'nishiki_pro_register_settings' ), 20 );

			// スクリプト追加
			$page_name = $this->plugin_name . '_script';
			$this->script( $page_name );
		}

		/**
		 * フォームの設定(基本)
		 */
		public function nishiki_pro_register_settings() {
			$page_name = $this->plugin_name . '_script';

			register_setting(
				$page_name,
				$page_name,
				array( $this, 'sanitize' )
			);

			add_settings_section(
				$page_name,
				'',
				array( $this, 'nishiki_pro_general_cb' ),
				$page_name
			);

			add_settings_field(
				'enable',
				__( '出力を有効にする', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_checkbox_cb' ),
				$page_name,
				$page_name,
				array(
					'title'       => '有効化',
					'label'       => 'enable',
					'page_name'   => $page_name,
					'description' => '',
				)
			);

			add_settings_field(
				'header',
				__( 'ヘッダーにスクリプトを追加', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_textarea_cb' ),
				$page_name,
				$page_name,
				array(
					'title'       => '',
					'label'       => 'header',
					'page_name'   => $page_name,
					'description' => '出力の優先順位（デフォルト：10）1 〜 999 の範囲で設定。数字が小さいほど実行の優先度が高いです',
					'priority'    => true,
				)
			);

			add_settings_field(
				'body_open',
				__( '&lt;body&gt;タグの直後にスクリプトを追加', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_textarea_cb' ),
				$page_name,
				$page_name,
				array(
					'title'       => '',
					'label'       => 'body_open',
					'page_name'   => $page_name,
					'description' => '出力の優先順位（デフォルト：10）1 〜 999 の範囲で設定。数字が小さいほど実行の優先度が高いです',
					'priority'    => true,
				)
			);

			add_settings_field(
				'footer',
				__( 'フッターにスクリプトを追加', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_textarea_cb' ),
				$page_name,
				$page_name,
				array(
					'title'       => '',
					'label'       => 'footer',
					'page_name'   => $page_name,
					'description' => '出力の優先順位（デフォルト：10）1 〜 999 の範囲で設定。数字が小さいほど実行の優先度が高いです',
					'priority'    => true,
				)
			);
		}

		/**
		 * スクリプト出力
		 *
		 * @param string $page_name ページ名
		 * @return void
		 */
		public function script( $page_name ) {
			$options = get_option( $page_name );

			if ( ! empty( $options ) && ! empty( $options['enable'] ) ) {
				if ( ! empty( $options['header'] ) ) {
					add_action(
						'wp_head',
						function() use ( $options ) {
							echo nishiki_pro_sanitize_textarea_script( $options['header'] );
						},
						$options['header_priority']
					);
				}

				if ( ! empty( $options['body_open'] ) ) {
					add_action(
						'wp_body_open',
						function() use ( $options ) {
							echo nishiki_pro_sanitize_textarea_script( $options['body_open'] );
						},
						$options['body_open_priority']
					);
				}

				if ( ! empty( $options['footer'] ) ) {
					add_action(
						'wp_footer',
						function() use ( $options ) {
							echo nishiki_pro_sanitize_textarea_script( $options['footer'] );
						},
						$options['footer_priority']
					);
				}
			}
		}

		/**
		 * 入力値のサニタイズ
		 *
		 * @param array $input Contains all settings fields as array keys
		 */
		public function sanitize( $input ) {
			$new_input = array();

			// チェックボックス absint
			// テキスト stripslashes

			if ( isset( $input['enable'] ) ) {
				$new_input['enable'] = absint( $input['enable'] );
			}

			if ( isset( $input['header'] ) ) {
				$new_input['header'] = stripslashes( $input['header'] );
			}

			if ( isset( $input['header_priority'] ) ) {
				$new_input['header_priority'] = absint( $input['header_priority'] );
			}

			if ( isset( $input['body_open'] ) ) {
				$new_input['body_open'] = stripslashes( $input['body_open'] );
			}

			if ( isset( $input['body_open_priority'] ) ) {
				$new_input['body_open_priority'] = absint( $input['body_open_priority'] );
			}

			if ( isset( $input['footer'] ) ) {
				$new_input['footer'] = stripslashes( $input['footer'] );
			}

			if ( isset( $input['footer_priority'] ) ) {
				$new_input['footer_priority'] = absint( $input['footer_priority'] );
			}

			// wp_die(var_dump($new_input));
			return $new_input;
		}
	}
}

$output = new NISHIKI_PRO_SCRIPT();
