<?php
if ( ! class_exists( 'NISHIKI_PRO_GENERAL_UTILITY_FORM' ) ) {
	/**
	 * フォーム作成
	 */
	class NISHIKI_PRO_GENERAL_UTILITY_FORM {
		/**
		 * フォーム作成（チェックボックス一つ）
		 *
		 * @param string $title タイトル
		 * @param string $label ラベル
		 * @param string $page_name ページ名
		 * @return void
		 */
		public function create_form_checkbox( $title, $label, $page_name ) {
			$options    = get_option( $page_name );
			$label_name = $page_name . '_' . $label;

			if( isset( $options[ $title ] ) ){
				$title = $options[ $title ];
			} else {
				$title = '';
			}

			if ( isset( $options[ $label ] ) ) {
				$checked = ' checked="checked"';
			} else {
				$checked = '';
			}

			echo '<p><input type="checkbox" id="' . esc_attr( $label_name ) . '" name="' . esc_attr( $page_name ) . '[' . esc_attr( $label ) . ']" value="1"' . esc_attr( $checked ) . '><label for="' . esc_attr( $label_name ) . '">' . esc_html( $title ) . '</label></p>';
		}

		/**
		 * フォーム作成（チェックボックス複数）
		 *
		 * @param string $title タイトル
		 * @param string $label ラベル
		 * @param string $page_name ページ名
		 * @param string $script スクリプト
		 * @param string $display_key キー
		 * @return void
		 */
		public function create_form_checkbox_multiple( $title, $label, $page_name, $script, $display_key ) {
			$options = get_option( $page_name );

			if( isset( $options[ $title ] ) ){
				$title = $options[ $title ];
			} else {
				$title = '';
			}

			echo '<ul>';
			foreach ( $script as $key => $title ) {
				$checked = '';
				if ( isset( $options[ $label ] ) ) {
					if ( array_key_exists( $key, $options[ $label ] ) ) {
						$checked = ' checked="checked"';
					}
				}
				$label_name = $label . '_' . $key;

				if ( true === $display_key ) {
					$key_name = ' (' . esc_html( $key ) . ')';
				} else {
					$key_name = '';
				}

				echo '<li><input type="checkbox" id="' . esc_attr( $label_name ) . '" name="' . esc_attr( $page_name ) . '[' . esc_attr( $label ) . '][' . esc_attr( $key ) . ']" value="1"' . esc_attr( $checked ) . '><label for="' . esc_attr( $label_name ) . '">' . esc_html( $title . $key_name ) . '</label></li>';
			}
			echo '</ul>';
		}

		/**
		 * フォーム作成（テキスト）
		 *
		 * @param array $args 設定
		 * @return void
		 */
		public function create_form_text( $args = array() ) {
			$options = get_option( $args['page_name'] );

			$title       = ! empty( $args['title'] ) ? $args['title'] : '';
			$description = ! empty( $args['description'] ) ? $args['description'] : '';
			$placeholder = ! empty( $args['placeholder'] ) ? $args['placeholder'] : '';

			$label      = ! empty( $args['label'] ) ? $args['label'] : '';
			$label_name = $args['page_name'] . '_' . $args['label'];

			$page_name = $args['page_name'];

			if ( isset( $options[ $label ] ) ) {
				$data = $options[ $label ];
			} else {
				$data = '';
			}

			if ( ! empty( $title ) ) {
				echo '<h4><label for="' . esc_attr( $label_name ) . '">' . esc_html( $title ) . '</label></h4>';
			}
			echo '<p><input class="regular-text" placeholder="' . esc_attr( $placeholder ) . '" type="text" id="' . esc_attr( $label_name ) . '" name="' . esc_attr( $page_name ) . '[' . esc_attr( $label ) . ']" value="' . esc_attr( $data ) . '" /></p>';

			if ( ! empty( $description ) ) {
				echo '<p class="description">' . esc_html( $description ) . '</p>';
			}
		}

		/**
		 * フォーム作成（テキストエリア）
		 *
		 * @param array $args 設定
		 * @return void
		 */
		public function create_form_textarea( $args = array() ) {
			$options = get_option( $args['page_name'] );

			$data = '';

			$title       = ! empty( $args['title'] ) ? $args['title'] : '';
			$description = ! empty( $args['description'] ) ? $args['description'] : '';

			$priority_name = $args['label'] . '_priority';
			$priority      = ( ! empty( $options[ $priority_name ] ) && true === $args['priority'] ) ? $options[ $priority_name ] : 10;

			$label      = ! empty( $args['label'] ) ? $args['label'] : '';
			$label_name = $args['page_name'] . '_' . $args['label'];

			$page_name = $args['page_name'];

			if ( ! empty( $label ) ) {
				$data = ( ! empty( $options[ $args['label'] ] ) ) ? $options[ $args['label'] ] : '';
			}

			if ( ! empty( $title ) ) {
				echo '<h4><label for="' . esc_attr( $label_name ) . '">' . esc_html( $title ) . '</label></h4>';
			}

			echo '<p><textarea rows="10" cols="10" class="large-text code" id="' . esc_attr( $label ) . '" name="' . esc_attr( $page_name ) . '[' . esc_attr( $label ) . ']" value="' . esc_attr( $data ) . '" />' . esc_textarea( $data ) . '</textarea></p>';

			if ( ! empty( $args['priority'] ) && true === $args['priority'] ) {
				echo '<input type="number" name="' . esc_attr( $page_name ) . '[' . esc_attr( $priority_name ) . ']" value="' . absint( $priority ) . '">';
			}

			if ( ! empty( $description ) ) {
				echo '<p class="description">' . esc_html( $description ) . '</p>';
			}
		}

		/**
		 * フォーム作成（ラジオボタン）
		 *
		 * @param array $args 設定
		 * @return void
		 */
		public function create_form_radio_button( $args = array() ) {
			$options = get_option( $args['page_name'] );

			// データがない場合、初期値設定
			if ( ! isset( $options[ $args['label'] ] ) ) {
				$options[ $args['label'] ] = $args['script']['default'];
			}

			// 互換性維持（いずれ削除）
			if ( 'nishiki_pro_general_optimize' === $args['page_name'] && ! empty( $options['enable'] ) ) {
				$options[ $args['label'] ] = 'footer';
			}

			if ( ! empty( $args['script'] ) ) {
				echo '<ul>';
				foreach ( $args['script']['data'] as $key => $title ) {
					$checked = '';

					if ( $options[ $args['label'] ] === $key ) {
						$checked = ' checked="checked"';
					}

					if ( true === $args['display_key'] ) {
						$key_name = ' (' . esc_html( $key ) . ')';
					} else {
						$key_name = '';
					}

					$label_name = $args['page_name'] . '_' . $args['label'] . '_' . $key;

					echo '<li><input type="radio" id="' . esc_attr( $label_name ) . '" name="' . esc_attr( $args['page_name'] ) . '[' . esc_attr( $args['label'] ) . ']" value="' . esc_attr( $key ) . '"' . esc_attr( $checked ) . '><label for="' . esc_attr( $label_name ) . '">' . esc_html( $title . $key_name ) . '</label></li>';
				}
				echo '</ul>';
			}

			$description = ! empty( $args['description'] ) ? $args['description'] : '';

			if ( ! empty( $description ) ) {
				echo '<p class="description">' . esc_html( $description ) . '</p>';
			}
		}

		/**
		 * フォーム作成（セレクトボックス）
		 *
		 * @param array $args 設定
		 * @return void
		 */
		public function create_form_selectbox( $args = array() ) {
			$options = get_option( $args['page_name'] );

			// データがない場合、初期値設定
			if ( ! isset( $options[ $args['label'] ] ) ) {
				$options[ $args['label'] ] = $args['script']['default'];
			}

			if ( ! empty( $args['script'] ) ) {

				echo '<select name="' . esc_attr( $args['page_name'] ) . '[' . esc_attr( $args['label'] ) . ']">';
				foreach ( $args['script']['data'] as $key => $title ) {
					$selected = '';

					if ( $options[ $args['label'] ] === $key ) {
						$selected = ' selected="selected"';
					}

					$label_name = $args['page_name'] . '_' . $args['label'] . '_' . $key;

					echo '<option value="' . esc_attr( $key ) . '"' . esc_attr( $selected ) . '">' . esc_html( $title ) . '</option>';
				}
				echo '</select>';
			}

			$description = ! empty( $args['description'] ) ? $args['description'] : '';

			if ( ! empty( $description ) ) {
				echo '<p class="description">' . esc_html( $description ) . '</p>';
			}
		}
	}
}
