<?php
if ( ! function_exists( 'nishiki_pro_breadcrumbs_customizer' ) ) {
	add_action( 'customize_register', 'nishiki_pro_breadcrumbs_customizer' );
	/**
	 * カスタマイザーの設定
	 *
	 * @param instance $wp_customize インスタンス
	 * @return void
	 */
	function nishiki_pro_breadcrumbs_customizer( $wp_customize ) {

		// Section
		$wp_customize->add_section(
			'section_' . NISHIKI_PRO_PREFIX_BREADCRUMBS,
			array(
				'title'    => __( 'パンくずリスト', 'nishiki-pro' ),
				'priority' => 600,
				'panel'    => 'panel_' . NISHIKI_PRO_PREFIX,
			)
		);

		// Display Header
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_BREADCRUMBS . '_header',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_BREADCRUMBS . '_header',
				array(
					'label'    => '<p><a class="nishiki-pro-customizer-button" href="' . esc_url( admin_url( 'admin.php?page=nishiki-pro-general.php&action=breadcrumbs' ) ) . '">→表示設定はこちら</a></p>',
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_BREADCRUMBS,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_BREADCRUMBS . '_header',
				)
			)
		);

		// Text Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_BREADCRUMBS . '_text_color',
			array(
				'default'           => '#222222',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_BREADCRUMBS . '_text_color',
				array(
					'label'    => __( 'Text Color', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_BREADCRUMBS,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_BREADCRUMBS . '_text_color',
					'priority' => 1040,
				)
			)
		);

		// Text Link Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_BREADCRUMBS . '_link_color',
			array(
				'default'           => '#0a88cc',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_BREADCRUMBS . '_link_color',
				array(
					'label'    => __( 'Link Color', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_BREADCRUMBS,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_BREADCRUMBS . '_link_color',
					'priority' => 1040,
				)
			)
		);

		// Text Link Hover Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_BREADCRUMBS . '_link_hover_color',
			array(
				'default'           => '#0044a3',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_BREADCRUMBS . '_link_hover_color',
				array(
					'label'    => __( 'Link Hover Color', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_BREADCRUMBS,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_BREADCRUMBS . '_link_hover_color',
					'priority' => 1040,
				)
			)
		);

		// Background Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_BREADCRUMBS . '_background_color',
			array(
				'default'           => '',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_BREADCRUMBS . '_background_color',
				array(
					'label'    => __( 'Background Color', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_BREADCRUMBS,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_BREADCRUMBS . '_background_color',
					'priority' => 1030,
				)
			)
		);
	}
}


