<?php
/**
 * Add CSS
 *
 * @return $output
 */
function nishiki_pro_css_heading_h3() {
	$output  = '';
	$heading = 'h3';

	// Heading
	$heading_type     = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_type_' . $heading, 'none' ) );
	$heading_color_01 = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_color_' . $heading . '_01' ) );
	$heading_color_02 = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_color_' . $heading . '_02' ) );
	$heading_color_03 = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_color_' . $heading . '_03' ) );
	$heading_radius   = absint( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_radius_' . $heading ) );

	$heading_padding_style = array(
		'desktop' => 'padding-left:1.4rem;padding-right:1.4rem;',
		'tablet'  => 'padding:0.7rem;',
	);

	if ( $heading_color_01 ) {
		$heading_color_01_style = "color: {$heading_color_01}";
	} else {
		$heading_color_01_style = '';
	}

	if ( $heading_color_02 ) {
		$heading_color_02_style     = "background: {$heading_color_02}";
		$heading_border_color_style = "border-color: {$heading_color_02}";
	} else {
		$heading_color_02_style     = '';
		$heading_border_color_style = '';
	}

	if ( $heading_color_03 ) {
		$heading_color_03_style = "background: {$heading_color_03}";
	} else {
		$heading_color_03_style = '';
	}

	if ( $heading_radius ) {
		$heading_radius_style = "border-radius: {$heading_radius}px";
	} else {
		$heading_radius_style = '';
	}

	if ( $heading_type ) {
		$design_heading_pc     = nishiki_pro_heading_style_elements( $heading );
		$design_heading_pc    .= "
				{$heading_color_01_style};
				{$heading_radius_style};
				";
		$design_heading_tablet = '@media only screen and (max-width:' . NISHIKI_PRO_BREAK_POINT_TABLET . '){' . nishiki_pro_heading_style_elements( $heading );
		$design_heading_sp     = '@media only screen and (max-width:' . NISHIKI_PRO_BREAK_POINT_SP . '){' . nishiki_pro_heading_style_elements( $heading );
		switch ( $heading_type ) {
			case 'baloon':
				if ( $heading_color_02_style ) {
					$baloon_border_style = '
						border: 15px solid transparent;
					    border-top-color: inherit;
					    border-bottom: 0;
					';
				} else {
					$baloon_border_style = '';
				}
				$design_heading_pc     .= "
						{$heading_color_02_style};
	                    {$heading_border_color_style};
						{$heading_padding_style['desktop']}
					}";
				$design_heading_pc     .= nishiki_pro_heading_style_elements( $heading, '', true, false );
				$design_heading_pc     .= '
						position: relative;
						}
				';
				$design_heading_pc     .= nishiki_pro_heading_style_elements( $heading, 'after' );
				$design_heading_pc     .= "
					content: '';
				    position: absolute;
					top:auto;
				    bottom: 0;
				    left: 2.9rem;
				    width: 0;
				    height: 0;
				    {$baloon_border_style}
				    margin-left: -20px;
				    margin-bottom: -15px;
				";
				$design_heading_tablet .= "
					{$heading_padding_style['tablet']}
				";
				$design_heading_sp     .= '';
				break;
			case 'box':
				$design_heading_pc     .= "
					{$heading_color_02_style};
					{$heading_padding_style['desktop']}
				";
				$design_heading_tablet .= "
					{$heading_padding_style['tablet']}
				";
				$design_heading_sp     .= '';
				break;
			case 'stitch-box':
				if ( $heading_color_01_style ) {
					$stitch_text_color_style = "
						border: dashed 1px {$heading_color_01};
					";
				} else {
					$stitch_text_color_style = '';
				}
				if ( $heading_color_02_style ) {
					$stitch_background_color_style = "
						box-shadow: 0 0 0 6px {$heading_color_02};
					";
				} else {
					$stitch_background_color_style = '';
				}
				$design_heading_pc     .= "
					{$heading_color_02_style};
					{$stitch_text_color_style}
					{$stitch_background_color_style}
					{$heading_padding_style['desktop']}
				";
				$design_heading_tablet .= "
					{$heading_padding_style['tablet']}
				";
				$design_heading_sp     .= '';
				break;
			case 'dot-box':
				$color                  = rawurlencode( $heading_color_02 );
				$design_heading_pc     .= "
					{$heading_padding_style['desktop']}
					background-image: url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='4' height='4' viewBox='0 0 4 4'%3E%3Cpath fill='{$color}' fill-opacity='1' d='M1 3h1v1H1V3zm2-2h1v1H3V1z'%3E%3C/path%3E%3C/svg%3E\");
				";
				$design_heading_tablet .= "
					{$heading_padding_style['tablet']}
				";
				$design_heading_sp     .= '';
				break;
			case 'polka-dot-box':
				if ( ! empty( $nishiki_pro_heading_type_color_03 ) ) {
					$color = $nishiki_pro_heading_type_color_03;
				} else {
					$color = '#fff';
				}
				$design_heading_pc     .= "
					{$heading_color_02_style};
					{$heading_padding_style['desktop']}
					background-image: radial-gradient({$color} 10%, transparent 20%), radial-gradient({$color} 10%, transparent 20%);
					background-size: 20px 20px;
					background-position: 0 0, 10px 10px;
				";
				$design_heading_tablet .= "
					{$heading_padding_style['tablet']}
				";
				$design_heading_sp     .= '';
				break;
			case 'stripe-box':
				$color                  = rawurlencode( $heading_color_02 );
				$design_heading_pc     .= "
					{$heading_color_03_style};
					{$heading_padding_style['desktop']}
					background-image: url(\"data:image/svg+xml,%3Csvg width='40' height='40' viewBox='0 0 40 40' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='{$color}' fill-opacity='0.5' fill-rule='evenodd'%3E%3Cpath d='M0 40L40 0H20L0 20M40 40V20L20 40'/%3E%3C/g%3E%3C/svg%3E\");
				";
				$design_heading_tablet .= "
					{$heading_padding_style['tablet']}
				";
				$design_heading_sp     .= '';
				break;
			case 'houndstooth-box':
				$color                  = rawurlencode( $heading_color_02 );
				$design_heading_pc     .= "
					{$heading_color_03_style};
					{$heading_padding_style['desktop']}
					background-image: url(\"data:image/svg+xml,%3Csvg width='24' height='24' viewBox='0 0 24 24' xmlns='http://www.w3.org/2000/svg'%3E%3Ctitle%3Ehoundstooth%3C/title%3E%3Cg fill='{$color}' fill-opacity='0.34' fill-rule='evenodd'%3E%3Cpath d='M0 18h6l6-6v6h6l-6 6H0M24 18v6h-6M24 0l-6 6h-6l6-6M12 0v6L0 18v-6l6-6H0V0'/%3E%3C/g%3E%3C/svg%3E\");
				";
				$design_heading_tablet .= "
					{$heading_padding_style['tablet']}
				";
				$design_heading_sp     .= '';
				break;
			case 'jigsaw-puzzle-box':
				$color                  = rawurlencode( $heading_color_02 );
				$design_heading_pc     .= "
					{$heading_color_03_style};
					{$heading_padding_style['desktop']}
					background-image: url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='192' height='192' viewBox='0 0 192 192'%3E%3Cpath fill='{$color}' fill-opacity='0.5' d='M192 15v2a11 11 0 0 0-11 11c0 1.94 1.16 4.75 2.53 6.11l2.36 2.36a6.93 6.93 0 0 1 1.22 7.56l-.43.84a8.08 8.08 0 0 1-6.66 4.13H145v35.02a6.1 6.1 0 0 0 3.03 4.87l.84.43c1.58.79 4 .4 5.24-.85l2.36-2.36a12.04 12.04 0 0 1 7.51-3.11 13 13 0 1 1 .02 26 12 12 0 0 1-7.53-3.11l-2.36-2.36a4.93 4.93 0 0 0-5.24-.85l-.84.43a6.1 6.1 0 0 0-3.03 4.87V143h35.02a8.08 8.08 0 0 1 6.66 4.13l.43.84a6.91 6.91 0 0 1-1.22 7.56l-2.36 2.36A10.06 10.06 0 0 0 181 164a11 11 0 0 0 11 11v2a13 13 0 0 1-13-13 12 12 0 0 1 3.11-7.53l2.36-2.36a4.93 4.93 0 0 0 .85-5.24l-.43-.84a6.1 6.1 0 0 0-4.87-3.03H145v35.02a8.08 8.08 0 0 1-4.13 6.66l-.84.43a6.91 6.91 0 0 1-7.56-1.22l-2.36-2.36A10.06 10.06 0 0 0 124 181a11 11 0 0 0-11 11h-2a13 13 0 0 1 13-13c2.47 0 5.79 1.37 7.53 3.11l2.36 2.36a4.94 4.94 0 0 0 5.24.85l.84-.43a6.1 6.1 0 0 0 3.03-4.87V145h-35.02a8.08 8.08 0 0 1-6.66-4.13l-.43-.84a6.91 6.91 0 0 1 1.22-7.56l2.36-2.36A10.06 10.06 0 0 0 107 124a11 11 0 0 0-22 0c0 1.94 1.16 4.75 2.53 6.11l2.36 2.36a6.93 6.93 0 0 1 1.22 7.56l-.43.84a8.08 8.08 0 0 1-6.66 4.13H49v35.02a6.1 6.1 0 0 0 3.03 4.87l.84.43c1.58.79 4 .4 5.24-.85l2.36-2.36a12.04 12.04 0 0 1 7.51-3.11A13 13 0 0 1 81 192h-2a11 11 0 0 0-11-11c-1.94 0-4.75 1.16-6.11 2.53l-2.36 2.36a6.93 6.93 0 0 1-7.56 1.22l-.84-.43a8.08 8.08 0 0 1-4.13-6.66V145H11.98a6.1 6.1 0 0 0-4.87 3.03l-.43.84c-.79 1.58-.4 4 .85 5.24l2.36 2.36a12.04 12.04 0 0 1 3.11 7.51A13 13 0 0 1 0 177v-2a11 11 0 0 0 11-11c0-1.94-1.16-4.75-2.53-6.11l-2.36-2.36a6.93 6.93 0 0 1-1.22-7.56l.43-.84a8.08 8.08 0 0 1 6.66-4.13H47v-35.02a6.1 6.1 0 0 0-3.03-4.87l-.84-.43c-1.59-.8-4-.4-5.24.85l-2.36 2.36A12 12 0 0 1 28 109a13 13 0 1 1 0-26c2.47 0 5.79 1.37 7.53 3.11l2.36 2.36a4.94 4.94 0 0 0 5.24.85l.84-.43A6.1 6.1 0 0 0 47 84.02V49H11.98a8.08 8.08 0 0 1-6.66-4.13l-.43-.84a6.91 6.91 0 0 1 1.22-7.56l2.36-2.36A10.06 10.06 0 0 0 11 28 11 11 0 0 0 0 17v-2a13 13 0 0 1 13 13c0 2.47-1.37 5.79-3.11 7.53l-2.36 2.36a4.94 4.94 0 0 0-.85 5.24l.43.84A6.1 6.1 0 0 0 11.98 47H47V11.98a8.08 8.08 0 0 1 4.13-6.66l.84-.43a6.91 6.91 0 0 1 7.56 1.22l2.36 2.36A10.06 10.06 0 0 0 68 11 11 11 0 0 0 79 0h2a13 13 0 0 1-13 13 12 12 0 0 1-7.53-3.11l-2.36-2.36a4.93 4.93 0 0 0-5.24-.85l-.84.43A6.1 6.1 0 0 0 49 11.98V47h35.02a8.08 8.08 0 0 1 6.66 4.13l.43.84a6.91 6.91 0 0 1-1.22 7.56l-2.36 2.36A10.06 10.06 0 0 0 85 68a11 11 0 0 0 22 0c0-1.94-1.16-4.75-2.53-6.11l-2.36-2.36a6.93 6.93 0 0 1-1.22-7.56l.43-.84a8.08 8.08 0 0 1 6.66-4.13H143V11.98a6.1 6.1 0 0 0-3.03-4.87l-.84-.43c-1.59-.8-4-.4-5.24.85l-2.36 2.36A12 12 0 0 1 124 13a13 13 0 0 1-13-13h2a11 11 0 0 0 11 11c1.94 0 4.75-1.16 6.11-2.53l2.36-2.36a6.93 6.93 0 0 1 7.56-1.22l.84.43a8.08 8.08 0 0 1 4.13 6.66V47h35.02a6.1 6.1 0 0 0 4.87-3.03l.43-.84c.8-1.59.4-4-.85-5.24l-2.36-2.36A12 12 0 0 1 179 28a13 13 0 0 1 13-13zM84.02 143a6.1 6.1 0 0 0 4.87-3.03l.43-.84c.8-1.59.4-4-.85-5.24l-2.36-2.36A12 12 0 0 1 83 124a13 13 0 1 1 26 0c0 2.47-1.37 5.79-3.11 7.53l-2.36 2.36a4.94 4.94 0 0 0-.85 5.24l.43.84a6.1 6.1 0 0 0 4.87 3.03H143v-35.02a8.08 8.08 0 0 1 4.13-6.66l.84-.43a6.91 6.91 0 0 1 7.56 1.22l2.36 2.36A10.06 10.06 0 0 0 164 107a11 11 0 0 0 0-22c-1.94 0-4.75 1.16-6.11 2.53l-2.36 2.36a6.93 6.93 0 0 1-7.56 1.22l-.84-.43a8.08 8.08 0 0 1-4.13-6.66V49h-35.02a6.1 6.1 0 0 0-4.87 3.03l-.43.84c-.79 1.58-.4 4 .85 5.24l2.36 2.36a12.04 12.04 0 0 1 3.11 7.51A13 13 0 1 1 83 68a12 12 0 0 1 3.11-7.53l2.36-2.36a4.93 4.93 0 0 0 .85-5.24l-.43-.84A6.1 6.1 0 0 0 84.02 49H49v35.02a8.08 8.08 0 0 1-4.13 6.66l-.84.43a6.91 6.91 0 0 1-7.56-1.22l-2.36-2.36A10.06 10.06 0 0 0 28 85a11 11 0 0 0 0 22c1.94 0 4.75-1.16 6.11-2.53l2.36-2.36a6.93 6.93 0 0 1 7.56-1.22l.84.43a8.08 8.08 0 0 1 4.13 6.66V143h35.02z'%3E%3C/path%3E%3C/svg%3E\");
				";
				$design_heading_tablet .= "
					{$heading_padding_style['tablet']}
				";
				$design_heading_sp     .= '';
				break;
			case 'graph-paper-box':
				$color                  = rawurlencode( $heading_color_02 );
				$design_heading_pc     .= "
					{$heading_color_03_style};
					{$heading_padding_style['desktop']}
					background-image: url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='100' height='100' viewBox='0 0 100 100'%3E%3Cg fill-rule='evenodd'%3E%3Cg fill='{$color}' fill-opacity='0.5'%3E%3Cpath opacity='.5' d='M96 95h4v1h-4v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4H0v-1h15v-9H0v-1h15v-9H0v-1h15v-9H0v-1h15v-9H0v-1h15v-9H0v-1h15v-9H0v-1h15v-9H0v-1h15v-9H0v-1h15V0h1v15h9V0h1v15h9V0h1v15h9V0h1v15h9V0h1v15h9V0h1v15h9V0h1v15h9V0h1v15h9V0h1v15h4v1h-4v9h4v1h-4v9h4v1h-4v9h4v1h-4v9h4v1h-4v9h4v1h-4v9h4v1h-4v9h4v1h-4v9zm-1 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-9-10h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm9-10v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-9-10h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm9-10v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-9-10h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm9-10v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-9-10h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9z'/%3E%3Cpath d='M6 5V0H5v5H0v1h5v94h1V6h94V5H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E\");
				";
				$design_heading_tablet .= "
					{$heading_padding_style['tablet']}
				";
				$design_heading_sp     .= '';
				break;
			case 'brick-wall-box':
				$color                  = rawurlencode( $heading_color_02 );
				$design_heading_pc     .= "
					{$heading_color_03_style};
					{$heading_padding_style['desktop']}
					background-image: url(\"data:image/svg+xml,%3Csvg width='42' height='44' viewBox='0 0 42 44' xmlns='http://www.w3.org/2000/svg'%3E%3Cg id='Page-1' fill='none' fill-rule='evenodd'%3E%3Cg id='brick-wall' fill='{$color}' fill-opacity='0.5'%3E%3Cpath d='M0 0h42v44H0V0zm1 1h40v20H1V1zM0 23h20v20H0V23zm22 0h20v20H22V23z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E\");
				";
				$design_heading_tablet .= "
					{$heading_padding_style['tablet']}
				";
				$design_heading_sp     .= '';
				break;
			case 'sailor-anchor-box':
				$color                  = rawurlencode( $heading_color_02 );
				$design_heading_pc     .= "
					{$heading_color_03_style};
					{$heading_padding_style['desktop']}
					background-image: url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 80 80' width='80' height='80'%3E%3Cpath fill='{$color}' fill-opacity='0.5' d='M14 16H9v-2h5V9.87a4 4 0 1 1 2 0V14h5v2h-5v15.95A10 10 0 0 0 23.66 27l-3.46-2 8.2-2.2-2.9 5a12 12 0 0 1-21 0l-2.89-5 8.2 2.2-3.47 2A10 10 0 0 0 14 31.95V16zm40 40h-5v-2h5v-4.13a4 4 0 1 1 2 0V54h5v2h-5v15.95A10 10 0 0 0 63.66 67l-3.47-2 8.2-2.2-2.88 5a12 12 0 0 1-21.02 0l-2.88-5 8.2 2.2-3.47 2A10 10 0 0 0 54 71.95V56zm-39 6a2 2 0 1 1 0-4 2 2 0 0 1 0 4zm40-40a2 2 0 1 1 0-4 2 2 0 0 1 0 4zM15 8a2 2 0 1 0 0-4 2 2 0 0 0 0 4zm40 40a2 2 0 1 0 0-4 2 2 0 0 0 0 4z'%3E%3C/path%3E%3C/svg%3E\");
				";
				$design_heading_tablet .= "
					{$heading_padding_style['tablet']}
				";
				$design_heading_sp     .= '';
				break;
			case 'underline':
				$design_heading_pc     .= "
					{$heading_color_02_style};
					border-bottom-style: solid;
					border-bottom-width:1px;
				";
				$design_heading_tablet .= '
				    padding: 0.5rem 0;
				';
				$design_heading_sp     .= '
                    padding: 0.4rem 0;
				';
				break;
			case 'simple':
				$design_heading_pc     .= "
					{$heading_color_02_style};
					border-top-style: solid;
					border-top-width:1px;
					border-bottom-style: solid;
					border-bottom-width:1px;
				";
				$design_heading_tablet .= '
				    padding: 0.5rem 0;
				';
				$design_heading_sp     .= '
                    padding: 0.4rem 0;
				';
				break;
		}
		$design_heading_pc     .= '}';
		$design_heading_tablet .= '}}';
		$design_heading_sp     .= '}}';

		// Dark Mode
		if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_enable' ) ) {
			// Dark Mode Heading
			$heading_dark_mode_color_01 = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_heading_color_' . $heading . '_01' ) );
			$heading_dark_mode_color_02 = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_heading_color_' . $heading . '_02' ) );
			$heading_dark_mode_color_03 = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_heading_color_' . $heading . '_03' ) );

			if ( $heading_dark_mode_color_01 ) {
				$heading_dark_mode_color_01_style = "color: {$heading_dark_mode_color_01}";
			} else {
				$heading_dark_mode_color_01_style = '';
			}

			if ( $heading_dark_mode_color_02 ) {
				$heading_dark_mode_color_02_style     = "background: {$heading_dark_mode_color_02}";
				$heading_dark_mode_border_color_style = "border-color: {$heading_dark_mode_color_02}";
			} else {
				$heading_dark_mode_color_02_style     = '';
				$heading_dark_mode_border_color_style = '';
			}

			if ( $heading_dark_mode_color_03 ) {
				$heading_dark_mode_color_03_style = "background: {$heading_dark_mode_color_03}";
			} else {
				$heading_dark_mode_color_03_style = '';
			}

			$design_heading_pc .= "
				body[data-theme='dark'] .entry-content {$heading}{
					color: {$heading_dark_mode_color_01};
			";

			switch ( $heading_type ) {
				case 'baloon':
					if ( $heading_dark_mode_color_02 ) {
						$baloon_border_style = '
						';
					} else {
						$baloon_border_style = '';
					}
					$design_heading_pc .= "
						{$heading_dark_mode_color_02_style};
	                    {$heading_dark_mode_border_color_style};
					}
				";
					break;
				case 'box':
					$design_heading_pc .= "
					{$heading_dark_mode_color_02_style};
				";
					break;
				case 'stitch-box':
					if ( $heading_dark_mode_color_01_style ) {
						$stitch_text_color_style = "
						border: dashed 1px {$heading_dark_mode_color_01};
						";
					} else {
						$stitch_text_color_style = '';
					}
					if ( $heading_dark_mode_color_02_style ) {
						$stitch_background_color_style = "
						box-shadow: 0 0 0 6px {$heading_dark_mode_color_02};
					";
					} else {
						$stitch_background_color_style = '';
					}
					$design_heading_pc .= "
						{$heading_dark_mode_color_02_style};
						{$stitch_text_color_style}
						{$stitch_background_color_style}
					";
					break;
				case 'dot-box':
					$color              = rawurlencode( $heading_dark_mode_color_02 );
					$design_heading_pc .= "
					background-image: url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='4' height='4' viewBox='0 0 4 4'%3E%3Cpath fill='{$color}' fill-opacity='1' d='M1 3h1v1H1V3zm2-2h1v1H3V1z'%3E%3C/path%3E%3C/svg%3E\");
				";
					break;
				case 'polka-dot-box':
					if ( ! empty( $nishiki_pro_heading_type_color_03 ) ) {
						$color = $nishiki_pro_heading_type_color_03;
					} else {
						$color = '#fff';
					}
					$design_heading_pc .= "
					{$heading_dark_mode_color_02_style};
					background-image: radial-gradient({$color} 10%, transparent 20%), radial-gradient({$color} 10%, transparent 20%);
					background-size: 20px 20px;
					background-position: 0 0, 10px 10px;
				";
					break;
				case 'stripe-box':
					$color              = rawurlencode( $heading_dark_mode_color_02 );
					$design_heading_pc .= "
					{$heading_dark_mode_color_03_style};
					background-image: url(\"data:image/svg+xml,%3Csvg width='40' height='40' viewBox='0 0 40 40' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='{$color}' fill-opacity='0.5' fill-rule='evenodd'%3E%3Cpath d='M0 40L40 0H20L0 20M40 40V20L20 40'/%3E%3C/g%3E%3C/svg%3E\");
				";
					break;
				case 'houndstooth-box':
					$color              = rawurlencode( $heading_dark_mode_color_02 );
					$design_heading_pc .= "
					{$heading_dark_mode_color_03_style};
					background-image: url(\"data:image/svg+xml,%3Csvg width='24' height='24' viewBox='0 0 24 24' xmlns='http://www.w3.org/2000/svg'%3E%3Ctitle%3Ehoundstooth%3C/title%3E%3Cg fill='{$color}' fill-opacity='0.34' fill-rule='evenodd'%3E%3Cpath d='M0 18h6l6-6v6h6l-6 6H0M24 18v6h-6M24 0l-6 6h-6l6-6M12 0v6L0 18v-6l6-6H0V0'/%3E%3C/g%3E%3C/svg%3E\");
				";
					break;
				case 'jigsaw-puzzle-box':
					$color              = rawurlencode( $heading_dark_mode_color_02 );
					$design_heading_pc .= "
					{$heading_dark_mode_color_03_style};
					background-image: url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='192' height='192' viewBox='0 0 192 192'%3E%3Cpath fill='{$color}' fill-opacity='0.5' d='M192 15v2a11 11 0 0 0-11 11c0 1.94 1.16 4.75 2.53 6.11l2.36 2.36a6.93 6.93 0 0 1 1.22 7.56l-.43.84a8.08 8.08 0 0 1-6.66 4.13H145v35.02a6.1 6.1 0 0 0 3.03 4.87l.84.43c1.58.79 4 .4 5.24-.85l2.36-2.36a12.04 12.04 0 0 1 7.51-3.11 13 13 0 1 1 .02 26 12 12 0 0 1-7.53-3.11l-2.36-2.36a4.93 4.93 0 0 0-5.24-.85l-.84.43a6.1 6.1 0 0 0-3.03 4.87V143h35.02a8.08 8.08 0 0 1 6.66 4.13l.43.84a6.91 6.91 0 0 1-1.22 7.56l-2.36 2.36A10.06 10.06 0 0 0 181 164a11 11 0 0 0 11 11v2a13 13 0 0 1-13-13 12 12 0 0 1 3.11-7.53l2.36-2.36a4.93 4.93 0 0 0 .85-5.24l-.43-.84a6.1 6.1 0 0 0-4.87-3.03H145v35.02a8.08 8.08 0 0 1-4.13 6.66l-.84.43a6.91 6.91 0 0 1-7.56-1.22l-2.36-2.36A10.06 10.06 0 0 0 124 181a11 11 0 0 0-11 11h-2a13 13 0 0 1 13-13c2.47 0 5.79 1.37 7.53 3.11l2.36 2.36a4.94 4.94 0 0 0 5.24.85l.84-.43a6.1 6.1 0 0 0 3.03-4.87V145h-35.02a8.08 8.08 0 0 1-6.66-4.13l-.43-.84a6.91 6.91 0 0 1 1.22-7.56l2.36-2.36A10.06 10.06 0 0 0 107 124a11 11 0 0 0-22 0c0 1.94 1.16 4.75 2.53 6.11l2.36 2.36a6.93 6.93 0 0 1 1.22 7.56l-.43.84a8.08 8.08 0 0 1-6.66 4.13H49v35.02a6.1 6.1 0 0 0 3.03 4.87l.84.43c1.58.79 4 .4 5.24-.85l2.36-2.36a12.04 12.04 0 0 1 7.51-3.11A13 13 0 0 1 81 192h-2a11 11 0 0 0-11-11c-1.94 0-4.75 1.16-6.11 2.53l-2.36 2.36a6.93 6.93 0 0 1-7.56 1.22l-.84-.43a8.08 8.08 0 0 1-4.13-6.66V145H11.98a6.1 6.1 0 0 0-4.87 3.03l-.43.84c-.79 1.58-.4 4 .85 5.24l2.36 2.36a12.04 12.04 0 0 1 3.11 7.51A13 13 0 0 1 0 177v-2a11 11 0 0 0 11-11c0-1.94-1.16-4.75-2.53-6.11l-2.36-2.36a6.93 6.93 0 0 1-1.22-7.56l.43-.84a8.08 8.08 0 0 1 6.66-4.13H47v-35.02a6.1 6.1 0 0 0-3.03-4.87l-.84-.43c-1.59-.8-4-.4-5.24.85l-2.36 2.36A12 12 0 0 1 28 109a13 13 0 1 1 0-26c2.47 0 5.79 1.37 7.53 3.11l2.36 2.36a4.94 4.94 0 0 0 5.24.85l.84-.43A6.1 6.1 0 0 0 47 84.02V49H11.98a8.08 8.08 0 0 1-6.66-4.13l-.43-.84a6.91 6.91 0 0 1 1.22-7.56l2.36-2.36A10.06 10.06 0 0 0 11 28 11 11 0 0 0 0 17v-2a13 13 0 0 1 13 13c0 2.47-1.37 5.79-3.11 7.53l-2.36 2.36a4.94 4.94 0 0 0-.85 5.24l.43.84A6.1 6.1 0 0 0 11.98 47H47V11.98a8.08 8.08 0 0 1 4.13-6.66l.84-.43a6.91 6.91 0 0 1 7.56 1.22l2.36 2.36A10.06 10.06 0 0 0 68 11 11 11 0 0 0 79 0h2a13 13 0 0 1-13 13 12 12 0 0 1-7.53-3.11l-2.36-2.36a4.93 4.93 0 0 0-5.24-.85l-.84.43A6.1 6.1 0 0 0 49 11.98V47h35.02a8.08 8.08 0 0 1 6.66 4.13l.43.84a6.91 6.91 0 0 1-1.22 7.56l-2.36 2.36A10.06 10.06 0 0 0 85 68a11 11 0 0 0 22 0c0-1.94-1.16-4.75-2.53-6.11l-2.36-2.36a6.93 6.93 0 0 1-1.22-7.56l.43-.84a8.08 8.08 0 0 1 6.66-4.13H143V11.98a6.1 6.1 0 0 0-3.03-4.87l-.84-.43c-1.59-.8-4-.4-5.24.85l-2.36 2.36A12 12 0 0 1 124 13a13 13 0 0 1-13-13h2a11 11 0 0 0 11 11c1.94 0 4.75-1.16 6.11-2.53l2.36-2.36a6.93 6.93 0 0 1 7.56-1.22l.84.43a8.08 8.08 0 0 1 4.13 6.66V47h35.02a6.1 6.1 0 0 0 4.87-3.03l.43-.84c.8-1.59.4-4-.85-5.24l-2.36-2.36A12 12 0 0 1 179 28a13 13 0 0 1 13-13zM84.02 143a6.1 6.1 0 0 0 4.87-3.03l.43-.84c.8-1.59.4-4-.85-5.24l-2.36-2.36A12 12 0 0 1 83 124a13 13 0 1 1 26 0c0 2.47-1.37 5.79-3.11 7.53l-2.36 2.36a4.94 4.94 0 0 0-.85 5.24l.43.84a6.1 6.1 0 0 0 4.87 3.03H143v-35.02a8.08 8.08 0 0 1 4.13-6.66l.84-.43a6.91 6.91 0 0 1 7.56 1.22l2.36 2.36A10.06 10.06 0 0 0 164 107a11 11 0 0 0 0-22c-1.94 0-4.75 1.16-6.11 2.53l-2.36 2.36a6.93 6.93 0 0 1-7.56 1.22l-.84-.43a8.08 8.08 0 0 1-4.13-6.66V49h-35.02a6.1 6.1 0 0 0-4.87 3.03l-.43.84c-.79 1.58-.4 4 .85 5.24l2.36 2.36a12.04 12.04 0 0 1 3.11 7.51A13 13 0 1 1 83 68a12 12 0 0 1 3.11-7.53l2.36-2.36a4.93 4.93 0 0 0 .85-5.24l-.43-.84A6.1 6.1 0 0 0 84.02 49H49v35.02a8.08 8.08 0 0 1-4.13 6.66l-.84.43a6.91 6.91 0 0 1-7.56-1.22l-2.36-2.36A10.06 10.06 0 0 0 28 85a11 11 0 0 0 0 22c1.94 0 4.75-1.16 6.11-2.53l2.36-2.36a6.93 6.93 0 0 1 7.56-1.22l.84.43a8.08 8.08 0 0 1 4.13 6.66V143h35.02z'%3E%3C/path%3E%3C/svg%3E\");
				";
					break;
				case 'graph-paper-box':
					$color              = rawurlencode( $heading_dark_mode_color_02 );
					$design_heading_pc .= "
					{$heading_dark_mode_color_03_style};
					background-image: url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='100' height='100' viewBox='0 0 100 100'%3E%3Cg fill-rule='evenodd'%3E%3Cg fill='{$color}' fill-opacity='0.5'%3E%3Cpath opacity='.5' d='M96 95h4v1h-4v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4h-9v4h-1v-4H0v-1h15v-9H0v-1h15v-9H0v-1h15v-9H0v-1h15v-9H0v-1h15v-9H0v-1h15v-9H0v-1h15v-9H0v-1h15v-9H0v-1h15V0h1v15h9V0h1v15h9V0h1v15h9V0h1v15h9V0h1v15h9V0h1v15h9V0h1v15h9V0h1v15h9V0h1v15h4v1h-4v9h4v1h-4v9h4v1h-4v9h4v1h-4v9h4v1h-4v9h4v1h-4v9h4v1h-4v9h4v1h-4v9zm-1 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-9-10h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm9-10v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-9-10h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm9-10v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-9-10h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm9-10v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-10 0v-9h-9v9h9zm-9-10h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9zm10 0h9v-9h-9v9z'/%3E%3Cpath d='M6 5V0H5v5H0v1h5v94h1V6h94V5H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E\");
				";
					break;
				case 'brick-wall-box':
					$color              = rawurlencode( $heading_dark_mode_color_02 );
					$design_heading_pc .= "
					{$heading_dark_mode_color_03_style};
					background-image: url(\"data:image/svg+xml,%3Csvg width='42' height='44' viewBox='0 0 42 44' xmlns='http://www.w3.org/2000/svg'%3E%3Cg id='Page-1' fill='none' fill-rule='evenodd'%3E%3Cg id='brick-wall' fill='{$color}' fill-opacity='0.5'%3E%3Cpath d='M0 0h42v44H0V0zm1 1h40v20H1V1zM0 23h20v20H0V23zm22 0h20v20H22V23z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E\");
				";
					break;
				case 'sailor-anchor-box':
					$color              = rawurlencode( $heading_dark_mode_color_02 );
					$design_heading_pc .= "
					{$heading_dark_mode_color_03_style};
					background-image: url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 80 80' width='80' height='80'%3E%3Cpath fill='{$color}' fill-opacity='0.5' d='M14 16H9v-2h5V9.87a4 4 0 1 1 2 0V14h5v2h-5v15.95A10 10 0 0 0 23.66 27l-3.46-2 8.2-2.2-2.9 5a12 12 0 0 1-21 0l-2.89-5 8.2 2.2-3.47 2A10 10 0 0 0 14 31.95V16zm40 40h-5v-2h5v-4.13a4 4 0 1 1 2 0V54h5v2h-5v15.95A10 10 0 0 0 63.66 67l-3.47-2 8.2-2.2-2.88 5a12 12 0 0 1-21.02 0l-2.88-5 8.2 2.2-3.47 2A10 10 0 0 0 54 71.95V56zm-39 6a2 2 0 1 1 0-4 2 2 0 0 1 0 4zm40-40a2 2 0 1 1 0-4 2 2 0 0 1 0 4zM15 8a2 2 0 1 0 0-4 2 2 0 0 0 0 4zm40 40a2 2 0 1 0 0-4 2 2 0 0 0 0 4z'%3E%3C/path%3E%3C/svg%3E\");
				";
					break;
				case 'underline':
					$design_heading_pc .= "
					{$heading_dark_mode_color_02_style};
				";
					break;
				case 'simple':
					$design_heading_pc .= "
					{$heading_dark_mode_color_02_style};
				";
					break;
			}

			$design_heading_pc .= '}';
		}

		$design_heading = $design_heading_pc . $design_heading_tablet . $design_heading_sp;

		$output .= $design_heading;

	}

	return $output;
}

