<?php
if ( ! function_exists( 'nishiki_pro_dark_mode' ) ) {
	add_action( 'customize_register', 'nishiki_pro_dark_mode' );
	/**
	 * カスタマイザーの設定
	 *
	 * @param instance $wp_customize インスタンス
	 * @return void
	 */
	function nishiki_pro_dark_mode( $wp_customize ) {

		// Section
		$wp_customize->add_section(
			'section_' . NISHIKI_PRO_PREFIX_DARK_MODE,
			array(
				'title'    => __( 'ダークモード(Beta)', 'nishiki-pro' ),
				'panel'    => 'panel_' . NISHIKI_PRO_PREFIX,
				'priority' => '10000',
			)
		);

		// Heading
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_display_header',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_display_header',
				array(
					'label'    => '<p class="nishiki-pro-customizer-heading">表示</p>',
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_DARK_MODE,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_display_header',
				)
			)
		);

		// Enable Dark Mode.
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_enable',
			array(
				'default'           => false,
				'sanitize_callback' => 'nishiki_pro_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_enable',
			array(
				'label'    => __( 'Enable Dark Mode', 'nishiki-pro' ),
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_DARK_MODE,
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_enable',
				'type'     => 'checkbox',
			)
		);

		// Heading
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_color_header',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_color_header',
				array(
					'label'    => '<p class="nishiki-pro-customizer-heading">カラー</p>',
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_DARK_MODE,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_color_header',
				)
			)
		);

		// Background Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_background_color',
			array(
				'default'           => '#1e1e2b',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_background_color',
				array(
					'label'    => __( 'Background Color', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_DARK_MODE,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_background_color',
				)
			)
		);

		// Text Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_text_color',
			array(
				'default'           => '#999999',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_text_color',
				array(
					'label'    => __( 'Text Color', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_DARK_MODE,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_text_color',
				)
			)
		);

		// Accent Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_accent_color',
			array(
				'default'           => '#96994f',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_accent_color',
				array(
					'label'    => __( 'Accent Color', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_DARK_MODE,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_accent_color',
				)
			)
		);

		// Header & Footer Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_header_footer_color',
			array(
				'default'           => '#1b1823',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_header_footer_color',
				array(
					'label'    => __( 'Header & Footer Color', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_DARK_MODE,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_header_footer_color',
				)
			)
		);

		// Breadcrumbs Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_breadcrumbs_color',
			array(
				'default'           => '#292335',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_breadcrumbs_color',
				array(
					'label'    => __( 'Breadcrumbs Color', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_DARK_MODE,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_breadcrumbs_color',
				)
			)
		);

		// Social Account Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_social_color',
			array(
				'default'           => '#242230',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_social_color',
				array(
					'label'    => __( 'Social Color', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_DARK_MODE,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_social_color',
				)
			)
		);

		// Footer nav Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_footer_nav_color',
			array(
				'default'           => '#1f1b28',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_footer_nav_color',
				array(
					'label'    => __( 'Footer Nav Color', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_DARK_MODE,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_footer_nav_color',
				)
			)
		);

		$heading_color = array(
			'#999999',
			'',
			'#999999',
		);

		// Section
		for ( $i = 2; $i <= 6; ++$i ) {

			// Heading
			$wp_customize->add_setting(
				'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_heading_color_header' . $i,
				array(
					'sanitize_callback' => 'nishiki_pro_sanitize_text',
				)
			);

			$wp_customize->add_control(
				new Nishiki_WP_Customize_Content(
					$wp_customize,
					'ctrl_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_heading_color_header' . $i,
					array(
						'label'    => '<p class="nishiki-pro-customizer-heading item-num item-num' . $i . '">見出し h' . $i . '</p>',
						'section'  => 'section_' . NISHIKI_PRO_PREFIX_DARK_MODE,
						'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_heading_color_header' . $i,
					)
				)
			);

			// Section
			for ( $j = 1; $j <= 3; ++$j ) {
				// Heading Color01-03
				$wp_customize->add_setting(
					'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_heading_color_h' . $i . '_' . sprintf( '%02d', $j ),
					array(
						'default'           => $heading_color[ $j - 1 ],
						'sanitize_callback' => 'sanitize_hex_color',
					)
				);

				$wp_customize->add_control(
					new WP_Customize_Color_Control(
						$wp_customize,
						'ctrl_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_heading_color_h' . $i . '_' . sprintf( '%02d', $j ),
						array(
							'label'    => 'カラー' . $j,
							'section'  => 'section_' . NISHIKI_PRO_PREFIX_DARK_MODE,
							'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DARK_MODE . '_heading_color_h' . $i . '_' . sprintf( '%02d', $j ),
						)
					)
				);
			}
		}

	}
}
