<?php
if ( ! function_exists( 'nishiki_pro_design_customizer' ) ) {
	add_action( 'customize_register', 'nishiki_pro_design_customizer' );
	/**
	 * カスタマイザーの設定
	 *
	 * @param instance $wp_customize インスタンス
	 * @return void
	 */
	function nishiki_pro_design_customizer( $wp_customize ) {
		// Panel
		$wp_customize->add_panel(
			'panel_design',
			array(
				'title' => __( 'デザイン', 'nishiki-pro' ),
			)
		);

		/**
		 * Add Section
		 */

		// Section
		$wp_customize->add_section(
			'section_' . NISHIKI_PRO_PREFIX_DESIGN . '_btn',
			array(
				'title'    => __( 'ボタン', 'nishiki-pro' ),
				'priority' => 600,
				'panel'    => 'panel_design',
			)
		);

		// Section
		$wp_customize->add_section(
			'section_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading',
			array(
				'title'    => __( '見出し', 'nishiki-pro' ),
				'priority' => 600,
				'panel'    => 'panel_design',
			)
		);

		// Section
		$wp_customize->add_section(
			'section_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag',
			array(
				'title'    => __( 'タグ', 'nishiki-pro' ),
				'priority' => 600,
				'panel'    => 'panel_design',
			)
		);

		/**
		 * Add Customizer
		 */

		// Header
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_btn_type_header',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_DESIGN . '_btn_type_header',
				array(
					'label'    => '<p class="nishiki-pro-customizer-heading">ボタンのタイプ</p>',
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_DESIGN . '_btn',
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_btn_type_header',
				)
			)
		);

		// ボタンのタイプ
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_btn_type',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_radio',
				'default'           => 'simple',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_DESIGN . '_btn_type',
			array(
				'label'    => '',
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_DESIGN . '_btn',
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_btn_type',
				'type'     => 'radio',
				'choices'  => array(
					'simple' => __( 'シンプル（デフォルト）', 'nishiki-pro' ),
					'mild'   => __( 'マイルド', 'nishiki-pro' ),
					'custom' => __( 'カスタム', 'nishiki-pro' ),
				),
			)
		);

		// 角丸の px 数
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_btn_radius',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_number',
				'default'           => 30,
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_DESIGN . '_btn_radius',
			array(
				'label'       => __( 'コーナーの角丸（px）', 'nishiki-pro' ),
				'description' => __( '例：30 px（円）', 'nishiki-pro' ),
				'section'     => 'section_' . NISHIKI_PRO_PREFIX_DESIGN . '_btn',
				'settings'    => 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_btn_radius',
				'type'        => 'number',
			)
		);

		// Display Header
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_style_header',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_style_header',
				array(
					'label'    => '<p class="nishiki-pro-customizer-heading">見出しスタイル（Beta）</p><p>見出しのデザインを複数登録し、ブロックエディター内で使用できる「見出しスタイル」機能もあります。</p>',
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading',
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_style_header',
				)
			)
		);

		// Display Header
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_header_heading_type',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_DESIGN . '_header_heading_type',
				array(
					'label'    => '<p><a class="nishiki-pro-customizer-button" href="' . esc_url( admin_url( 'admin.php?page=nishiki-pro-block-editor.php&select=headings' ) ) . '">→見出しスタイルを作成する</a></p>',
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading',
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_header_heading_type',
				)
			)
		);

		// Section
		for ( $i = 2; $i <= 6; ++$i ) {
			if ( $i >= 3 ) {
				$default_heading = 'none';
			} else {
				$default_heading = 'simple';
			}

			// Header
			$wp_customize->add_setting(
				'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_header_heading_type_h' . $i,
				array(
					'sanitize_callback' => 'nishiki_pro_sanitize_text',
				)
			);

			$wp_customize->add_control(
				new Nishiki_WP_Customize_Content(
					$wp_customize,
					'ctrl_' . NISHIKI_PRO_PREFIX_DESIGN . '_header_heading_type_h' . $i,
					array(
						'label'    => '<p class="nishiki-pro-customizer-heading">h' . $i . '</p>',
						'section'  => 'section_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading',
						'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_header_heading_type_h' . $i,
					)
				)
			);

			// 見出しのタイプ
			$wp_customize->add_setting(
				'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_type_h' . $i,
				array(
					'sanitize_callback' => 'nishiki_pro_sanitize_choices_heading_type',
					'default'           => $default_heading,
				)
			);

			$wp_customize->add_control(
				'ctrl_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_type_h' . $i,
				array(
					'label'    => '',
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading',
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_type_h' . $i,
					'type'     => 'select',
					'choices'  => array(
						'simple'            => __( 'シンプル（デフォルト）', 'nishiki-pro' ),
						'underline'         => __( '下線', 'nishiki-pro' ),
						'baloon'            => __( 'フキダシ', 'nishiki-pro' ),
						'box'               => __( 'ボックス', 'nishiki-pro' ),
						'stitch-box'        => __( 'ステッチ風ボックス', 'nishiki-pro' ),
						'dot-box'           => __( 'ドット風ボックス', 'nishiki-pro' ),
						'polka-dot-box'     => __( '水玉ドット風ボックス', 'nishiki-pro' ),
						'stripe-box'        => __( 'ストライプ風ボックス', 'nishiki-pro' ),
						'houndstooth-box'   => __( '千鳥格子風ボックス', 'nishiki-pro' ),
						'jigsaw-puzzle-box' => __( 'ジグソーパズル風ボックス', 'nishiki-pro' ),
						'graph-paper-box'   => __( '方眼紙風ボックス', 'nishiki-pro' ),
						'brick-wall-box'    => __( 'レンガ風ボックス', 'nishiki-pro' ),
						'sailor-anchor-box' => __( 'イカリ風ボックス', 'nishiki-pro' ),
						'none'              => __( 'なし', 'nishiki-pro' ),
					),
				)
			);

			// Heading Color01
			$wp_customize->add_setting(
				'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_color_h' . $i . '_01',
				array(
					'default'           => '',
					'sanitize_callback' => 'sanitize_hex_color',
				)
			);

			$wp_customize->add_control(
				new WP_Customize_Color_Control(
					$wp_customize,
					'ctrl_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_color_h' . $i . '_01',
					array(
						'label'    => __( 'Color 01', 'nishiki-pro' ),
						'section'  => 'section_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading',
						'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_color_h' . $i . '_01',
					)
				)
			);

			// Heading Color02
			$wp_customize->add_setting(
				'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_color_h' . $i . '_02',
				array(
					'default'           => '',
					'sanitize_callback' => 'sanitize_hex_color',
				)
			);

			$wp_customize->add_control(
				new WP_Customize_Color_Control(
					$wp_customize,
					'ctrl_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_color_h' . $i . '_02',
					array(
						'label'    => __( 'Color 02', 'nishiki-pro' ),
						'section'  => 'section_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading',
						'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_color_h' . $i . '_02',
					)
				)
			);

			// Heading Color03
			$wp_customize->add_setting(
				'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_color_h' . $i . '_03',
				array(
					'default'           => '',
					'sanitize_callback' => 'sanitize_hex_color',
				)
			);

			$wp_customize->add_control(
				new WP_Customize_Color_Control(
					$wp_customize,
					'ctrl_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_color_h' . $i . '_03',
					array(
						'label'    => __( 'Color 03', 'nishiki-pro' ),
						'section'  => 'section_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading',
						'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_color_h' . $i . '_03',
					)
				)
			);

			// 角丸の px 数
			$wp_customize->add_setting(
				'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_radius_h' . $i,
				array(
					'sanitize_callback' => 'nishiki_pro_sanitize_number',
					'default'           => 0,
				)
			);

			$wp_customize->add_control(
				'ctrl_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_radius_h' . $i,
				array(
					'label'    => __( 'コーナーの角丸（px）', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading',
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_heading_radius_h' . $i,
					'type'     => 'number',
				)
			);
		}

		// Heading(Text Color)
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag_text_color_header',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag_text_color_header',
				array(
					'label'    => '<p class="nishiki-pro-customizer-heading">テキストカラー</p>',
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag',
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag_text_color_header',
				)
			)
		);

		// Main Color(Tag Text)
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag_text_color',
			array(
				'default'           => '#222222',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag_text_color',
				array(
					'label'    => __( 'Color 01', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag',
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag_text_color',
				)
			)
		);

		// Sub Color(Tag Text)
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag_text_hover_color',
			array(
				'default'           => '#222222',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag_text_hover_color',
				array(
					'label'    => __( 'Color 02', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag',
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag_text_hover_color',
				)
			)
		);

		// Heading(Background Color)
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag_background_color_header',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag_background_color_header',
				array(
					'label'    => '<p class="nishiki-pro-customizer-heading">背景カラー</p>',
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag',
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag_background_color_header',
				)
			)
		);

		// Main Color(Tag Background)
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag_background_color',
			array(
				'default'           => '#f5f5f5',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag_background_color',
				array(
					'label'    => __( 'Color 01', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag',
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag_background_color',
				)
			)
		);

		// Sub Color(Tag Background)
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag_background_hover_color',
			array(
				'default'           => '#f2f2f2',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag_background_hover_color',
				array(
					'label'    => __( 'Color 02', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag',
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_tag_background_hover_color',
				)
			)
		);

	}
}
