<?php
if ( ! function_exists( 'nishiki_pro_footer_customizer' ) ) {
	add_action( 'customize_register', 'nishiki_pro_footer_customizer' );
	/**
	 * カスタマイザーの設定
	 *
	 * @param instance $wp_customize インスタンス
	 * @return void
	 */
	function nishiki_pro_footer_customizer( $wp_customize ) {

		// Heading
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_nav_header',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_FOOTER . '_nav_header',
				array(
					'label'    => '<p class="nishiki-pro-customizer-heading">フッターメニュー</p><p><a class="nishiki-pro-customizer-button" href="https://support.animagate.com/manual/wp-nishiki-footer-menu/" target="_blank" rel="noopener noreferrer">→フッターメニューを作る方法はこちら</a></p>',
					'section'  => 'section_footer',
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_nav_header',
					'priority' => 10000,
				)
			)
		);

		// Footer Nav Background Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_nav_background_color',
			array(
				'default'           => '#f7f7f7',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_FOOTER . '_nav_background_color',
				array(
					'label'    => __( 'Background Color', 'nishiki-pro' ),
					'section'  => 'section_footer',
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_nav_background_color',
					'priority' => 10000,
				)
			)
		);

		// Footer Nav Background Hover Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_nav_background_hover_color',
			array(
				'default'           => '#eeeeee',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_FOOTER . '_nav_background_hover_color',
				array(
					'label'    => __( 'Background Hover Color', 'nishiki-pro' ),
					'section'  => 'section_footer',
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_nav_background_hover_color',
					'priority' => 10010,
				)
			)
		);

		// Footer Nav Text Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_nav_text_color',
			array(
				'default'           => '#444444',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_FOOTER . '_nav_text_color',
				array(
					'label'    => __( 'Text Color', 'nishiki-pro' ),
					'section'  => 'section_footer',
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_nav_text_color',
					'priority' => 10020,
				)
			)
		);

		// Footer Nav Text Hover Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_nav_text_hover_color',
			array(
				'default'           => '#222222',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_FOOTER . '_nav_text_hover_color',
				array(
					'label'    => __( 'Text Hover Color', 'nishiki-pro' ),
					'section'  => 'section_footer',
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_nav_text_hover_color',
					'priority' => 10030,
				)
			)
		);

		// Footer Nav Sticky
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_nav_sticky',
			array(
				'default'           => 'none',
				'sanitize_callback' => 'nishiki_pro_sanitize_choices_footer_nav_sticky',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_FOOTER . '_nav_sticky',
			array(
				'label'    => __( 'Footer Menu Sticky', 'nishiki-pro' ),
				'section'  => 'section_footer',
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_nav_sticky',
				'priority' => 10040,
				'type'     => 'select',
				'choices'  => array(
					'sticky'        => __( 'Anytime Sticky', 'nishiki-pro' ),
					'mobile-sticky' => __( 'Mobile Sticky', 'nishiki-pro' ),
					'none'          => __( 'None', 'nishiki-pro' ),
				),
			)
		);

		// Heading
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_bottom_right_header',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_FOOTER . '_bottom_right_header',
				array(
					'label'    => '<p class="nishiki-pro-customizer-heading">ページ上部へ戻るボタン</p>',
					'section'  => 'section_footer',
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_bottom_right_header',
					'priority' => 11000,
				)
			)
		);

		// Scroll Top
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_scroll_page_top_button_enable',
			array(
				'default'           => true,
				'sanitize_callback' => 'nishiki_pro_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_FOOTER . '_scroll_page_top_button_enable',
			array(
				'label'    => __( 'Display Scroll Page Top Button', 'nishiki-pro' ),
				'type'     => 'checkbox',
				'section'  => 'section_footer',
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_scroll_page_top_button_enable',
				'priority' => 11000,
			)
		);

		// Scroll Top(Desktop)
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_scroll_page_top_button_desktop',
			array(
				'default'           => true,
				'sanitize_callback' => 'nishiki_pro_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_FOOTER . '_scroll_page_top_button_desktop',
			array(
				'label'    => __( 'Display Desktop', 'nishiki-pro' ),
				'type'     => 'checkbox',
				'section'  => 'section_footer',
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_scroll_page_top_button_desktop',
				'priority' => 11100,
			)
		);

		// Scroll Top(Tablet)
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_scroll_page_top_button_tablet',
			array(
				'default'           => true,
				'sanitize_callback' => 'nishiki_pro_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_FOOTER . '_scroll_page_top_button_tablet',
			array(
				'label'    => __( 'Display Tablet', 'nishiki-pro' ),
				'type'     => 'checkbox',
				'section'  => 'section_footer',
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_scroll_page_top_button_tablet',
				'priority' => 11200,
			)
		);

		// Scroll Top(Smartphone)
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_scroll_page_top_button_smartphone',
			array(
				'default'           => true,
				'sanitize_callback' => 'nishiki_pro_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_FOOTER . '_scroll_page_top_button_smartphone',
			array(
				'label'    => __( 'Display Smartphone', 'nishiki-pro' ),
				'type'     => 'checkbox',
				'section'  => 'section_footer',
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_FOOTER . '_scroll_page_top_button_smartphone',
				'priority' => 11300,
			)
		);
	}
}
