<?php
/**
 * Meta 情報の読み込み
 *
 * @author     AnimaGate, Inc.
 * @link       https://support.animagate.com/product/wp-nishiki-pro/
 */

// OGP
require_once 'add_ogp.php';

// Json-ld
require_once 'add_json-ld.php';

// Hook
if ( ! function_exists( 'nishiki_pro_add_meta' ) ) {
	add_action( 'wp_head', 'nishiki_pro_add_meta', 1 );
	/**
	 * メタ情報作成
	 *
	 * @return void
	 */
	function nishiki_pro_add_meta() {
		$json_ld = new NISHIKI_PRO_META_JSON_LD();
		$json_ld->create();

		$ogp = new NISHIKI_PRO_META_OGP();
		$ogp->create();

		$twitter_card = new NISHIKI_PRO_META_OGP_TWITTER();
		$twitter_card->create();

		$facebook = new NISHIKI_PRO_META_OGP_FACEBOOK();
		$facebook->create();
	}
}
