<?php
if ( ! function_exists( 'nishiki_pro_meta_ogp_customizer' ) ) {
	add_action( 'customize_register', 'nishiki_pro_meta_ogp_customizer' );
	/**
	 * カスタマイザーの設定
	 *
	 * @param instance $wp_customize インスタンス
	 * @return void
	 */
	function nishiki_pro_meta_ogp_customizer( $wp_customize ) {

		// Section
		$wp_customize->add_section(
			'section_' . NISHIKI_PRO_PREFIX_META . '_ogp',
			array(
				'title'    => __( 'OGP', 'nishiki_pro' ),
				'priority' => 500,
				'panel'    => 'panel_' . NISHIKI_PRO_PREFIX,
			)
		);

		/**
		 * OGP共通
		 */

		// Display Header
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_META . '_ogp_header',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_META . '_ogp_header',
				array(
					'label'    => '<p><a class="nishiki-pro-customizer-button" href="' . esc_url( admin_url( 'admin.php?page=nishiki-pro-meta-ogp.php' ) ) . '">→表示設定はこちら</a></p>',
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_META . '_ogp',
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_META . '_ogp_header',
				)
			)
		);

		// image
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_META . '_ogp_image',
			array(
				'default'           => '',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'nishiki_pro_sanitize_image',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Image_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_META . '_ogp_image',
				array(
					'label'       => __( 'og:image（画像）', 'nishiki_pro' ),
					'description' => 'アイキャッチ画像が設定されていない場合の画像を指定します。推奨：1200×630px以上　最低：600×315px　※200×200px以上の画像を設定しないとFacebookでエラーになります。　画像の最大サイズ8MBまで',
					'section'     => 'section_' . NISHIKI_PRO_PREFIX_META . '_ogp',
					'settings'    => 'setting_' . NISHIKI_PRO_PREFIX_META . '_ogp_image',
					'priority'    => 1000,
				)
			)
		);

		/**
		 * Twitter Card
		 */
		// Type
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_META . '_ogp_twitter_card',
			array(
				'default'           => 'summary',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'nishiki_pro_sanitize_choices_meta_cards_type',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_META . '_ogp_twitter_card',
			array(
				'label'    => __( 'twitter:card（カードタイプ）', 'nishiki_pro' ),
				'type'     => 'select',
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_META . '_ogp',
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_META . '_ogp_twitter_card',
				'priority' => 2000,
				'choices'  => array(
					'summary'             => __( 'summary', 'nishiki_pro' ),
					'summary_large_image' => __( 'summary_large_image', 'nishiki_pro' ),
				),
			)
		);

		// Site
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_META . '_ogp_twitter_site',
			array(
				'default'           => '',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_META . '_ogp_twitter_site',
			array(
				'label'    => __( 'twitter:site（ウェブサイトのTwitter ID）', 'nishiki_pro' ),
				'type'     => 'text',
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_META . '_ogp',
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_META . '_ogp_twitter_site',
				'priority' => 2010,
			)
		);

		/**
		 * Facebook
		 */
		// App ID
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_META . '_ogp_facebook_app_id',
			array(
				'default'           => '',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_META . '_ogp_facebook_app_id',
			array(
				'label'       => __( 'fb:app_id', 'nishiki_pro' ),
				'description' => 'FacebookアプリのID（取得方法：https://developers.facebook.com/docs/apps/register?locale=ja_JP）',
				'type'        => 'text',
				'section'     => 'section_' . NISHIKI_PRO_PREFIX_META . '_ogp',
				'settings'    => 'setting_' . NISHIKI_PRO_PREFIX_META . '_ogp_facebook_app_id',
				'priority'    => 7010,
			)
		);

		// Facebook Page
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_META . '_ogp_facebook_publisher',
			array(
				'default'           => '',
				'transport'         => 'postMessage',
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_META . '_ogp_facebook_publisher',
			array(
				'label'       => __( 'article:publisher', 'nishiki_pro' ),
				'description' => 'FacebookページのURL',
				'type'        => 'text',
				'section'     => 'section_' . NISHIKI_PRO_PREFIX_META . '_ogp',
				'settings'    => 'setting_' . NISHIKI_PRO_PREFIX_META . '_ogp_facebook_publisher',
				'priority'    => 7020,
			)
		);

	}
}
