<?php
if ( ! function_exists( 'nishiki_pro_pr_customizer' ) ) {
	add_action( 'customize_register', 'nishiki_pro_pr_customizer' );
	/**
	 * カスタマイザーの設定
	 *
	 * @param instance $wp_customize インスタンス
	 * @return void
	 */
	function nishiki_pro_pr_customizer( $wp_customize ) {

		// Section
		$wp_customize->add_section(
			'section_' . NISHIKI_PRO_PREFIX_PR,
			array(
				'title'    => __( 'PR 表記', 'nishiki-pro' ),
				'panel'    => 'panel_' . NISHIKI_PRO_PREFIX,
				'priority' => '8000',
			)
		);

		// Heading
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_PR . '_before_content',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_PR . '_label_before_content_header',
				array(
					'label'    => 'PR（広告）であることを明示したい投稿ページ/固定ページの各編集画面で表示設定をしてください。',
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_PR,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_PR . '_before_content',
				)
			)
		);

		// Heading
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_PR . '_label_header',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_PR . '_label_header',
				array(
					'label'    => '<p class="nishiki-pro-customizer-heading">ラベル</p>',
					'description' => __( 'タイトルの下に表示します。', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_PR,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_PR . '_label_header',
				)
			)
		);

		// PR Label Type
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_PR . '_label_type',
			array(
				'default'           => 'fill',
				'sanitize_callback' => 'nishiki_pro_sanitize_choices_pr_type',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_PR . '_label_type',
			array(
				'label'    => __( 'Type', 'nishiki-pro' ),
				'type'     => 'select',
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_PR,
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_PR . '_label_type',
				'choices'  => array(
					'fill' => __( '塗り', 'nishiki-pro' ),
					'outline' => __( 'アウトライン', 'nishiki-pro' ),
				),
			)
		);

		// PR Label Text
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_PR . '_label_text',
			array(
				'default'           => __( 'PR', 'nishiki-pro' ),
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_PR . '_label_text',
			array(
				'label'    => 'テキスト',
				'type'     => 'text',
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_PR,
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_PR . '_label_text',
			)
		);

		// Heading
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_PR . '_before_content_header',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_PR . '_before_content_header',
				array(
					'label'    => '<p class="nishiki-pro-customizer-heading">本文の冒頭</p>',
					'description' => __( '本文の最初に表示します。', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_PR,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_PR . '_before_content_header',
				)
			)
		);

		// PR Content Type
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_PR . '_before_content_type',
			array(
				'default'           => 'outline',
				'sanitize_callback' => 'nishiki_pro_sanitize_choices_pr_type',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_PR . '_before_content_type',
			array(
				'label'    => __( 'Type', 'nishiki-pro' ),
				'type'     => 'select',
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_PR,
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_PR . '_before_content_type',
				'choices'  => array(
					'fill' => __( '塗り', 'nishiki-pro' ),
					'outline' => __( 'アウトライン', 'nishiki-pro' ),
				),
			)
		);

		// PR Before Content Text
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_PR . '_before_content_text',
			array(
				'default'           => __( '本ページはプロモーションが含まれています。', 'nishiki-pro' ),
				'sanitize_callback' => 'nishiki_pro_sanitize_textarea',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_PR . '_before_content_text',
			array(
				'label'    => 'テキスト',
				'type'     => 'textarea',
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_PR,
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_PR . '_before_content_text',
			)
		);

		// PR Before Content Color 01
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_PR . '_before_content_color_01',
			array(
				'default'           => '#222222',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_PR . '_before_content_color_01',
				array(
					'label'     => __( 'Color 01', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_PR,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_PR . '_before_content_color_01',
				)
			)
		);

		// PR Before Content Color 02
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_PR . '_before_content_color_02',
			array(
				'default'           => '#ffffff',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_PR . '_before_content_color_02',
				array(
					'label'     => __( 'Color 02', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_PR,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_PR . '_before_content_color_02',
				)
			)
		);
	}
}
