<?php
if ( ! function_exists( 'nishiki_pro_social_customizer' ) ) {
	add_action( 'customize_register', 'nishiki_pro_social_customizer' );
	/**
	 * カスタマイザーの設定
	 *
	 * @param instance $wp_customize インスタンス
	 * @return void
	 */
	function nishiki_pro_social_customizer( $wp_customize ) {

		// Section
		$wp_customize->add_section(
			'section_' . NISHIKI_PRO_PREFIX_SOCIAL,
			array(
				'title'    => __( 'ソーシャルアカウント', 'nishiki_pro' ),
				'priority' => 500,
				'panel'    => 'panel_' . NISHIKI_PRO_PREFIX,
			)
		);

		// ソーシャルアカウントのデザイン適用
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_css',
			array(
				'default'           => true,
				'sanitize_callback' => 'nishiki_pro_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_css',
			array(
				'label'    => __( 'デザイン適用（チェックを入れるとテーマ側で用意されたデザインを適用します）', 'nishiki_pro' ),
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_SOCIAL,
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_css',
				'priority' => 700,
				'type'     => 'checkbox',
			)
		);

		// デザインパターン
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_design_pattern',
			array(
				'default'           => '02',
				'sanitize_callback' => 'nishiki_pro_sanitize_choices_social_design_pattern',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_SOCIAL . '_design_pattern',
			array(
				'label'    => __( 'デザインパターン', 'nishiki_pro' ),
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_SOCIAL,
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_design_pattern',
				'priority' => 800,
				'type'     => 'select',
				'choices'  => array(
					'01' => __( '01', 'nishiki_pro' ),
					'02' => __( '02（デフォルト）', 'nishiki_pro' ),
				),
			)
		);

		// テキストカラー
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_text_color',
			array(
				'default'           => '#fff',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_SOCIAL . '_text_color',
				array(
					'label'    => __( 'テキストカラー', 'nishiki_pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_SOCIAL,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_text_color',
					'priority' => 750,
				)
			)
		);

		// 背景カラー
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_background_color',
			array(
				'default'           => '#222222',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_SOCIAL . '_background_color',
				array(
					'label'    => __( '背景カラー', 'nishiki_pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_SOCIAL,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_background_color',
					'priority' => 750,
				)
			)
		);

		// ソーシャルアカウント上のテキスト
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_before_text',
			array(
				'default'           => '',
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_SOCIAL . '_before_text',
			array(
				'label'    => __( 'ソーシャルアカウントの上 テキスト', 'nishiki_pro' ),
				'type'     => 'text',
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_SOCIAL,
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_before_text',
				'priority' => 800,
			)
		);

		// ソーシャルアカウント下のテキスト
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_after_text',
			array(
				'default'           => '',
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_SOCIAL . '_after_text',
			array(
				'label'    => __( 'ソーシャルアカウントの下 テキスト', 'nishiki_pro' ),
				'type'     => 'text',
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_SOCIAL,
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_after_text',
				'priority' => 800,
			)
		);

		$nishiki_pro_social_button_type = [
			[ 'name' => 'Twitter', 'default' => '', 'desc' => ':ユーザーID（例：animagate）' ],
			[ 'name' => 'X', 'default' => 'animagate', 'desc' => ':ユーザーID（例：animagate）' ],
			[ 'name' => 'Facebook', 'default' => 'animagate.inc', 'desc' => ':アカウントID または ページID（例：animagate.inc）' ],
			[ 'name' => 'Instagram', 'default' => '', 'desc' => ':アカウントID（例：instagramjapan）' ],
			[ 'name' => 'LINE', 'default' => '', 'desc' => ':URL（例：https://line.me/ti/p/xxxxxxxxxxx）' ],
			[ 'name' => 'YouTube', 'default' => 'UCA2ir-aKvKqqxV-RxQW0KHA', 'desc' => ':チャンネルID（例：UCA2ir-aKvKqqxV-RxQW0KHA）' ],
			[ 'name' => 'Pinterest', 'default' => '', 'desc' => ':ユーザーID（例：pinterestjp）' ],
			[ 'name' => 'GitHub', 'default' => '', 'desc' => ':アカウント名（例：WordPress）' ],
			[ 'name' => 'Steam', 'default' => '', 'desc' => ':Steam ID（例：wpnishiki）' ],
			[ 'name' => 'Twitch', 'default' => '', 'desc' => ':ユーザーID（例：wpnishiki）' ],
		];

		foreach ( $nishiki_pro_social_button_type as $button ) {
			$wp_customize->add_setting(
				'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_' . $button['name'],
				array(
					'default'           => $button['default'],
					'sanitize_callback' => 'nishiki_pro_sanitize_text',
				)
			);

			$wp_customize->add_control(
				'ctrl_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_' . $button['name'],
				array(
					'label'    => $button['name'] . $button['desc'],
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_SOCIAL,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_' . $button['name'],
					'priority' => 1000,
					'type'     => 'text',
				)
			);

			// remove_theme_mod( 'setting_' . $xxxx_customizer_prefix . '_' . $button );
		}

		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_rss',
			array(
				'default'           => false,
				'sanitize_callback' => 'nishiki_pro_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_SOCIAL . '_rss',
			array(
				'label'    => __( 'RSSフィード', 'nishiki_pro' ),
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_SOCIAL,
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_rss',
				'priority' => 1000,
				'type'     => 'checkbox',
			)
		);
	}
}

if ( ! function_exists( 'nishiki_pro_account_social_button' ) ) {
	/**
	 * ソーシャルアカウント出力
	 *
	 * @return $output
	 */
	function nishiki_pro_account_social_button() {
		$output = '';
		$button = '';
		$class = '';

		if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_Twitter', false ) ) {
			$button .= '<a target="_blank" aria-label="twitter" rel="noopener noreferrer" href="https://twitter.com/' . get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_Twitter', false ) . '/"><i class="icomoon icon-twitter"></i></a>';
		}
		if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_X', false ) ) {
			$button .= '<a target="_blank" aria-label="x" rel="noopener noreferrer" href="https://x.com/' . get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_X', false ) . '/"><i class="icomoon icon-x"></i></a>';
		}
		if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_Facebook', false ) ) {
			$button .= '<a target="_blank" aria-label="facebook" rel="noopener noreferrer" href="https://www.facebook.com/' . get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_Facebook', false ) . '/"><i class="icomoon icon-facebook2"></i></a>';
		}
		if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_Instagram', false ) ) {
			$button .= '<a target="_blank" aria-label="instagram" rel="noopener noreferrer" href="https://www.instagram.com/' . get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_Instagram', false ) . '/"><i class="icomoon icon-instagram"></i></a>';
		}
		if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_LINE', false ) ) {
			$button .= '<a target="_blank" aria-label="line" rel="noopener noreferrer" href="' . get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_LINE', false ) . '/"><i class="icomoon icon-line"></i></a>';
		}
		if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_YouTube', false ) ) {
			$button .= '<a target="_blank" aria-label="youtube" rel="noopener noreferrer" href="https://www.youtube.com/channel/' . get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_YouTube', false ) . '/"><i class="icomoon icon-youtube"></i></a>';
		}
		if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_Pinterest', false ) ) {
			$button .= '<a target="_blank" aria-label="pinterest" rel="noopener noreferrer" href="https://www.pinterest.com/' . get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_Pinterest', false ) . '/"><i class="icomoon icon-pinterest"></i></a>';
		}
		if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_GitHub', false ) ) {
			$button .= '<a target="_blank" aria-label="github" rel="noopener noreferrer" href="https://github.com/' . get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_GitHub', false ) . '/"><i class="icomoon icon-github"></i></a>';
		}
		if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_Steam', false ) ) {
			$button .= '<a target="_blank" aria-label="steam" rel="noopener noreferrer" href="https://steamcommunity.com/id/' . get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_Steam', false ) . '/"><i class="icomoon icon-steam"></i></a>';
		}
		if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_Twitch', false ) ) {
			$button .= '<a target="_blank" aria-label="twitch" rel="noopener noreferrer" href="https://www.twitch.tv/' . get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_Twitch', false ) . '/"><i class="icomoon icon-twitch"></i></a>';
		}

		if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_rss', false ) ) {
			$button .= '<a target="_blank" aria-label="rss" rel="noopener noreferrer" href="' . get_bloginfo_rss( 'rss2_url' ) . '"><i class="icomoon icon-rss"></i></a>';
		}

		if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_button_css', true ) ) {
			$design_pattern = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_design_pattern', '02' );
			$class          = ' nishiki-pro-social-button-style nishiki-pro-social-button-style-' . $design_pattern;
		}

		if ( $button ) {
			$output  = '<div id="nishiki-pro-social-button-wrapper" class="center">';
			$output .= '<div class="nishiki-pro-social-button-inner">';
			if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_before_text', false ) ) {
				$output .= '<p class="before-text">' . get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_before_text', false ) . '</p>';
			}
			$output .= '<div class="nishiki-pro-social-buttons' . $class . '">';
			$output .= $button;
			$output .= '</div>';
			if ( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_after_text', false ) ) {
				$output .= '<p class="after-text">' . get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_SOCIAL . '_after_text', false ) . '</p>';
			}
			$output .= '</div>';
			$output .= '</div>';
		}

		return $output;
	}
}

if ( ! function_exists( 'nishiki_pro_add_account_social_after_footer' ) ) {
	add_action( 'nishiki_pro_before_site_footer', 'nishiki_pro_add_account_social_after_footer', 100 );
	/**
	 * Add social account after content
	 *
	 * @return void
	 */
	function nishiki_pro_add_account_social_after_footer() {
		echo wp_kses_post( nishiki_pro_account_social_button() );
	}
}
