<?php
/**
 * フロント ページ
 *
 * @author     AnimaGate, Inc.
 * @link       https://support.animagate.com/product/wp-nishiki-pro/
 */

if ( 'page' === get_option( 'show_on_front' ) && ! empty( get_page_template() ) ) {
	include get_page_template();
} else {

	get_header();
	?>
	<main id="main" class="site-main" role="main" <?php do_action( 'nishiki_pro_main_attributes' ); ?>>
		<?php
		if ( get_theme_mod( 'setting_top_main_visual_display', true ) ) {
			nishiki_pro_get_template_part( 'parts/front/main-visual' );
		}
		?>
		<?php
		if ( have_posts() ) :
			while ( have_posts() ) :
				the_post();
				?>
				<?php do_action( 'nishiki_pro_before_home_header' ); ?>
				<?php do_action( 'nishiki_pro_after_home_header' ); ?>
				<?php do_action( 'nishiki_pro_before_home_container' ); ?>
					<div class="container">
						<?php do_action( 'nishiki_pro_before_home_content' ); ?>
							<div class="entry">
								<div class="entry-content">
								<?php the_content(); ?>
								</div>
							</div>
						<?php do_action( 'nishiki_pro_after_home_content' ); ?>
					</div>
				<?php do_action( 'nishiki_pro_after_home_container' ); ?>
				<?php
			endwhile;
		endif;
		?>
		<?php
		if ( get_theme_mod( 'setting_front_page_section_display', false ) ) {
			nishiki_pro_get_template_part( 'parts/front/section' );
		}
		?>
	</main>
	<?php get_footer();
}
