<?php
/**
 * Theme About Page
 *
 * @author     AnimaGate, Inc.
 * @link       https://support.animagate.com/product/wp-nishiki-pro/
 */

if ( ! class_exists( 'NISHIKI_PRO_ABOUT_PAGE' ) ) {
	/**
	 * テーマ概要ページ
	 */
	class NISHIKI_PRO_ABOUT_PAGE {

		/**
		 * メニュータイトル
		 *
		 * @var string
		 */
		public $menu_title = '';

		/**
		 * Construct
		 */
		public function __construct() {
			add_action( 'admin_menu', array( $this, 'about_page' ) );
			add_action( 'after_switch_theme', array( $this, 'switch_theme' ) );
		}

		/**
		 * Active Theme Notice
		 */
		public function about_page_notice() {
			$theme_data = wp_get_theme( 'nishiki-pro' );

			/* translators: %1$s: theme name %2$s: about page url */
			$message = sprintf( wp_kses( __( 'Welcome and thanks for choosing %1$s theme. Please visit our <a href="%2$s">about page</a>.', 'nishiki-pro' ), array( 'a' => array( 'href' => array() ) ) ), esc_attr( $theme_data->name ), esc_url( admin_url( 'themes.php?page=nishiki-pro-about&tab=welcome' ) ) );
			printf( '<div class="updated notice notice-success notice-alt is-dismissible"><p>%s</p></div>', wp_kses_post( $message ) );
		}

		/**
		 * Switch Theme
		 */
		public function switch_theme() {
			add_action( 'admin_notices', array( $this, 'about_page_notice' ) );
		}

		/**
		 * Add Theme Page
		 */
		public function about_page() {
			$this->menu_title = __( 'Nishiki Pro About Page', 'nishiki-pro' );
			add_theme_page(
				esc_html__( 'Nishiki Pro About Page', 'nishiki-pro' ),
				$this->menu_title,
				'edit_theme_options',
				'nishiki-pro-about',
				array( $this, 'theme_info_page' )
			);
		}

		/**
		 * Tab Array
		 */
		public function tab_array() {
			$nishiki_tab_array = array(
				'welcome'  => __( 'About Theme', 'nishiki-pro' ),
				'iconfont' => __( 'Use Icon', 'nishiki-pro' ),
			);

			return $nishiki_tab_array;
		}

		/**
		 * Theme Page Info
		 */
		public function theme_info_page() {
			$theme_data = wp_get_theme( 'nishiki-pro' );
			?>
					<div class="wrap about-wrap nishiki-pro-info-wrap">
						<div class="cols">
							<div class="left-col">
								<div class="main-visual">
									<h1><?php printf( esc_html__( 'Welcome to Nishiki Pro - Version %1s', 'nishiki-pro' ), esc_html( $theme_data->version ) ); ?></h1>
									<p class="description">Nishiki Pro は、ウェブサイト運営に必要な機能が豊富に搭載されたテーマです。<br>ブロックエディター（Gutenberg）対応。テーマ専用ブロック「Nishiki Blocks Pro」を使うことで、自由度の高いコンテンツ作成が可能です。</p>
									<?php
									$product_ver = 'お試し版';
									$reg_key_data = get_option( 'nishiki_pro' );
									$reg_key      = isset( $reg_key_data['reg_key'] ) ? $reg_key_data['reg_key'] : '';
									
									if ( isset( $reg_key ) && ! empty( $reg_key ) ) {
										$product_ver = '製品版';
										?>
										<p><strong>Nishiki Pro <?php echo $product_ver; ?></strong> を使用しています。</p>
										<?php
									} else {
										?>
										<h2>製品登録してください</h2>
										<p>現在 <strong>Nishiki Pro <?php echo $product_ver; ?></strong> を使用しています。製品登録を行うと、管理画面（ダッシュボード）でテーマのアップデートがワンクリックで可能になります。</p>
										<p>
											<a class="button button-primary" href="<?php echo esc_url( admin_url( 'admin.php?page=nishiki-pro-registration.php' ) ); ?>">製品登録する</a>
										</p>
										<?php
									}
									?>
									<div class="">
										<h2>はじめに</h2>
										<p>Nishiki Pro をインストールして間もない方、他のテーマから変更した方は、設定をまとめたページがありますのでご参考ください。マニュアルや Nishiki Blocks Pro のページもあわせてご参考ください。</p>
										<div class="link-buttons">
											<a target="_blank" rel="noopener noreferrer" class="button button-primary" href="https://support.animagate.com/replace-nishiki-theme-check-setting/">設定まとめ</a>
											<a target="_blank" rel="noopener noreferrer" class="button" href="https://support.animagate.com/manual/wp-nishiki/">操作マニュアル</a>
											<a target="_blank" rel="noopener noreferrer" class="button" href="https://support.animagate.com/manual/list/wp-nishiki-pro-gutenberg/">Nishiki Blocks Pro</a>
										</div>
									</div>
									<h2>外観をカスタマイズ</h2>
									<p>主に見た目に関係するカスタマイズは「カスタマイザー」から行ってください。</p>
									<p>
										<a href="<?php echo esc_url( admin_url( 'customize.php' ) ); ?>" class="button button-primary">カスタマイザーを開く</a>
									</p>
									<h2>基本設定</h2>
									<div class="link-buttons">
										<a href="<?php echo esc_url( admin_url( 'admin.php?page=nishiki-pro-general.php' ) ); ?>" class="button button-primary">一般設定</a>
										<a href="<?php echo esc_url( admin_url( 'admin.php?page=nishiki-pro-filter-search.php' ) ); ?>" class="button button-primary">絞り込み検索</a>
										<a href="<?php echo esc_url( admin_url( 'admin.php?page=nishiki-pro-meta-ogp.php' ) ); ?>" class="button button-primary">OGP</a>
										<a href="<?php echo esc_url( admin_url( 'admin.php?page=nishiki-pro-meta-json-ld.php' ) ); ?>" class="button button-primary">Schema.org</a>
										<a href="<?php echo esc_url( admin_url( 'admin.php?page=nishiki-pro-content.php' ) ); ?>" class="button button-primary">再利用コンテンツ</a>
										<a href="<?php echo esc_url( admin_url( 'admin.php?page=nishiki-pro-block-editor.php' ) ); ?>" class="button button-primary">ブロックエディター管理</a>
									</div>
									<h2>おすすめツール</h2>
									<p>ワンクリックでデモサイトをそのまま再現できる「デモデータ インポート」や、ウェブサイト制作を効率化する「Nishiki Pro Patterns」が無料で利用できます。ぜひご活用ください。</p>
									<div class="link-buttons">
										<a href="https://support.animagate.com/manual/wp-nishiki-pro-speed-builder" class="button button-primary" target="_blank">Nishiki Pro Speed Builder</a>
										<a href="https://demo.animagate.com/patterns/how-to-use" class="button button-primary" target="_blank">Nishiki Pro Patterns</a>
									</div>
									<h2>使用できるアイコンフォント</h2>
									<?php $this->iconfont(); ?>
								</div>
							</div>
							<div class="right-col">
								<div class="cards">
									<div class="about-card featured">
										<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/wp-nishiki-pro-09.webp' ); ?>" alt="Nishiki Pro Speed Builder import demo">
										<h2 class="products-title">Nishiki Pro Speed Builder</h2>
										<p class="card-description"><?php _e( 'デモサイトのデータをまるごとすべてインポートができる便利なプラグイン。ウェブサイト制作のスピード向上に役立ちます。', 'nishiki-pro' ); ?></p>
										<p><a class="button button-primary" href="https://support.animagate.com/manual/wp-nishiki-pro-speed-builder/" target="_blank">プラグインのダウンロード・使い方</a></p>
									</div>
									<div class="about-card featured">
										<img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/nishiki-pro-patterns.jpg' ); ?>" alt="Nishiki Pro Patterns">
										<h2 class="products-title">Nishiki Pro Patterns</h2>
										<p class="card-description"><?php _e( 'Streamline content and page creation in web production, including corporate sites, branding sites, and landing pages (LPs)! We carefully select and distribute high-quality, highly practical “ready-to-use patterns”.', 'nishiki-pro' ); ?></p>
										<p><a class="button button-primary" href="https://demo.animagate.com/patterns/" target="_blank">Nishiki Pro Patterns</a></p>
									</div>
									<div class="about-card">
										<svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="1.5"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-messages"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M21 14l-3 -3h-7a1 1 0 0 1 -1 -1v-6a1 1 0 0 1 1 -1h9a1 1 0 0 1 1 1v10" /><path d="M14 15v2a1 1 0 0 1 -1 1h-7l-3 3v-10a1 1 0 0 1 1 -1h2" /></svg>
										<h2 class="products-title"><?php _e( 'Support & Forum', 'nishiki-pro' ); ?></h2>
										<p class="card-description"><?php _e( 'Join the Discord user community for support and forums.', 'nishiki-pro' ); ?></p>
										<p><a class="button button-primary" href="https://discord.gg/54XtRAYMwj" target="_blank"><?php _e( 'Join Discord', 'nishiki-pro' ); ?></a></p>
									</div>
									<div class="about-card">
										<svg class="official" width="100%" height="100%" viewBox="0 0 190 181" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xml:space="preserve" xmlns:serif="http://www.serif.com/" style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2;">
											<g transform="matrix(1,0,0,1,-296,-788)">
												<g id="ol" transform="matrix(0.261671,0,0,0.261671,-139.586,448.255)">
													<g transform="matrix(0.0543478,0,-0.132405,0.494142,1863.79,727.253)">
														<rect x="1795.28" y="1157.48" width="543.307" height="874.016"/>
													</g>
													<g transform="matrix(0.0543478,0,-0.0103981,0.0388064,1603.65,1698.16)">
														<rect x="1795.28" y="1157.48" width="543.307" height="874.016"/>
													</g>
													<g transform="matrix(0.0543478,0,-0.0104269,0.0389137,1591.38,1743.93)">
														<rect x="1795.28" y="1157.48" width="543.307" height="874.016"/>
													</g>
													<g transform="matrix(0.76087,0,0.00874389,0.0326326,592.834,1755.84)">
														<rect x="1795.28" y="1157.48" width="543.307" height="874.016"/>
														<rect x="1795.28" y="1157.48" width="543.307" height="874.016"/>
													</g>
													<g transform="matrix(0.566165,0,0.00874389,0.0326326,806.709,1261.44)">
														<rect x="1795.28" y="1157.48" width="543.307" height="874.016"/>
													</g>
													<g transform="matrix(0.0652174,0,0.00874389,0.0326326,2084,1261.44)">
														<rect x="1795.28" y="1157.48" width="543.307" height="874.016"/>
													</g>
													<g transform="matrix(0.0652174,0,0.00874389,0.0326326,2031.09,1261.44)">
														<rect x="1795.28" y="1157.48" width="543.307" height="874.016"/>
													</g>
													<g transform="matrix(0.326087,0,0.114868,0.428693,1394.02,951.244)">
														<path d="M2338.58,1157.48L1795.28,1157.48L1795.28,2031.5L2338.58,2031.5L2338.58,1157.48ZM2244.84,1226.36L2244.84,1962.62C2244.84,1962.62 1889.02,1962.62 1889.02,1962.62C1889.02,1962.62 1889.02,1226.36 1889.02,1226.36L2244.84,1226.36Z"/>
													</g>
													<g transform="matrix(0.326087,0,0.211219,0.788278,861.623,386.796)">
														<path d="M2338.58,1157.48L2152.81,1157.48L1795.28,1433.47L1795.28,2031.5L2338.58,2031.5L2338.58,1157.48Z" style="fill:rgb(144,84,154);"/>
														<path d="M2338.58,1157.48L2152.81,1157.48L1795.28,1433.47L1795.28,2031.5L2338.58,2031.5L2338.58,1157.48ZM2244.84,1194.94L2244.84,1994.04C2244.84,1994.04 1889.02,1994.04 1889.02,1994.04C1889.02,1994.04 1889.02,1433.47 1889.02,1433.47C1889.02,1433.47 2198.03,1194.94 2198.03,1194.94L2244.84,1194.94Z"/>
													</g>
												</g>
											</g>
										</svg>
										<h3 class="products-title"><?php _e( 'Follow AnimaGate, Inc.', 'nishiki-pro' ); ?></h3>
										<p class="card-description"><?php _e( '製品の最新ニュースや追加機能などの情報を公式 X や YouTube で配信しています。ぜひフォローしてください。', 'nishiki-pro' ); ?></p>
										<ul>
											<li><a href="https://x.com/animagate" target="_blank"><i class="icomoon icon-x"></i></a></li>
											<li><a href="https://www.youtube.com/@animagate" target="_blank"><i class="icomoon icon-youtube2"></i></a></li>
										</ul>
									</div>

								</div>
							</div>
						</div>

					</div>
			<?php
		}

		/**
		 * Iconfont Page.
		 */
		public function iconfont() {

			$json = file_get_contents( get_template_directory() . '/assets/fonts/icomoon/selection.json' );
			$data = json_decode( $json, true );
			echo '<ul class="dashboard-icons">';
			foreach ( $data['icons'] as $icon ) {
				$icons_array[] = $icon['properties']['name'];
			}

			natcasesort( $icons_array );
			foreach ( $icons_array as $icon ) {
				echo '<li><i class="icomoon icon-' . esc_html( $icon ) . '"></i>' . esc_html( $icon ) . '</li>';
			}
			echo '</ul>';
		}

	}

	$output = new NISHIKI_PRO_ABOUT_PAGE();
}
